/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandrasstableoutput.writer;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.io.sstable.CQLSSTableWriter;
import org.pentaho.cassandra.CassandraUtils;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.steps.cassandrasstableoutput.writer.AbstractSSTableWriter;

class CQL3SSTableWriter
extends AbstractSSTableWriter {
    private CQLSSTableWriter writer;
    private RowMetaInterface rowMeta;

    CQL3SSTableWriter() {
    }

    @Override
    public void init() throws Exception {
        this.purgeSchemaInstance();
        this.writer = this.getCQLSSTableWriter();
    }

    void purgeSchemaInstance() {
        Schema.instance.purge(new CFMetaData(this.getKeyspace(), this.getColumnFamily(), null, null));
    }

    CQLSSTableWriter getCQLSSTableWriter() {
        return CQLSSTableWriter.builder().inDirectory(this.getDirectory()).forTable(this.buildCreateColumnFamilyCQLStatement()).using(this.buildInsertCQLStatement()).withBufferSizeInMB(this.getBufferSize()).build();
    }

    @Override
    public void processRow(Map<String, Object> record) throws Exception {
        this.writer.addRow(record);
    }

    @Override
    public void close() throws Exception {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void setRowMeta(RowMetaInterface rowMeta) {
        this.rowMeta = rowMeta;
    }

    String buildCreateColumnFamilyCQLStatement() {
        StringBuilder tableColumnsSpecification = new StringBuilder();
        for (ValueMetaInterface valueMeta : this.rowMeta.getValueMetaList()) {
            tableColumnsSpecification.append(CassandraUtils.cql3MixedCaseQuote(valueMeta.getName())).append(" ").append(CassandraUtils.getCQLTypeForValueMeta(valueMeta)).append(",");
        }
        tableColumnsSpecification.append("PRIMARY KEY (\"").append(this.getKeyField().replaceAll(",", "\",\"")).append("\")");
        return String.format("CREATE TABLE %s.%s (%s);", this.getKeyspace(), this.getColumnFamily(), tableColumnsSpecification);
    }

    String buildInsertCQLStatement() {
        Joiner columnsJoiner = Joiner.on((String)"\",\"").skipNulls();
        Joiner valuesJoiner = Joiner.on((String)",").skipNulls();
        Object[] columnNames = this.rowMeta.getFieldNames();
        Object[] valuePlaceholders = new String[columnNames.length];
        Arrays.fill(valuePlaceholders, "?");
        return String.format("INSERT INTO %s.%s (\"%s\") VALUES (%s);", this.getKeyspace(), this.getColumnFamily(), columnsJoiner.join(columnNames), valuesJoiner.join(valuePlaceholders));
    }
}

