/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandrasstableoutput.writer;

import org.apache.cassandra.config.YamlConfigurationLoader;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.steps.cassandrasstableoutput.writer.AbstractSSTableWriter;
import org.pentaho.di.trans.steps.cassandrasstableoutput.writer.CQL2SSTableWriter;
import org.pentaho.di.trans.steps.cassandrasstableoutput.writer.CQL3SSTableWriter;

public class SSTableWriterBuilder {
    private String configFilePath;
    private int cqlVersion;
    private String directory;
    private String keyspace;
    private String columnFamily;
    private String keyField;
    private int bufferSize;
    private RowMetaInterface rowMeta;

    public SSTableWriterBuilder withConfig(String configFilePath) {
        this.configFilePath = !configFilePath.startsWith("file:") ? "file:" + configFilePath : configFilePath;
        return this;
    }

    public SSTableWriterBuilder withDirectory(String outputDirectoryPath) {
        this.directory = outputDirectoryPath;
        return this;
    }

    public SSTableWriterBuilder withKeyspace(String keyspaceName) {
        this.keyspace = keyspaceName;
        return this;
    }

    public SSTableWriterBuilder withColumnFamily(String columnFamilyName) {
        this.columnFamily = columnFamilyName;
        return this;
    }

    public SSTableWriterBuilder withKeyField(String keyField) {
        this.keyField = keyField;
        return this;
    }

    public SSTableWriterBuilder withBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public SSTableWriterBuilder withRowMeta(RowMetaInterface rowMeta) {
        this.rowMeta = rowMeta;
        return this;
    }

    public SSTableWriterBuilder withCqlVersion(int cqlVersion) {
        this.cqlVersion = cqlVersion;
        return this;
    }

    public AbstractSSTableWriter build() throws Exception {
        AbstractSSTableWriter result;
        System.setProperty("cassandra.config", this.configFilePath);
        if (this.cqlVersion == 3) {
            CQL3SSTableWriter writer = this.getCql3SSTableWriter();
            writer.setRowMeta(this.rowMeta);
            result = writer;
        } else {
            CQL2SSTableWriter writer = this.getCql2SSTableWriter();
            writer.setPartitionerClassName(this.getPartitionerClass());
            result = writer;
        }
        result.setDirectory(this.directory);
        result.setKeyspace(this.keyspace);
        result.setColumnFamily(this.columnFamily);
        result.setKeyField(this.keyField);
        result.setBufferSize(this.bufferSize);
        return result;
    }

    String getPartitionerClass() throws ConfigurationException {
        return new YamlConfigurationLoader().loadConfig().partitioner;
    }

    CQL2SSTableWriter getCql2SSTableWriter() {
        return new CQL2SSTableWriter();
    }

    CQL3SSTableWriter getCql3SSTableWriter() {
        return new CQL3SSTableWriter();
    }
}

