/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager.importer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.aries.rsa.topologymanager.importer.EndpointListenerManager;
import org.apache.aries.rsa.topologymanager.importer.ListenerHookImpl;
import org.apache.aries.rsa.topologymanager.importer.RSFindHook;
import org.apache.aries.rsa.topologymanager.importer.ReferenceCounter;
import org.apache.aries.rsa.topologymanager.importer.ServiceInterestListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyManagerImport
implements EndpointListener,
RemoteServiceAdminListener,
ServiceInterestListener {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyManagerImport.class);
    private ExecutorService execService;
    private final EndpointListenerManager endpointListenerManager;
    private final BundleContext bctx;
    private Set<RemoteServiceAdmin> rsaSet;
    private final ListenerHookImpl listenerHook;
    private RSFindHook findHook;
    private boolean importAllAvailable = true;
    private final ReferenceCounter<String> importInterestsCounter = new ReferenceCounter();
    private final Map<String, List<EndpointDescription>> importPossibilities = new HashMap<String, List<EndpointDescription>>();
    private final Map<String, List<ImportRegistration>> importedServices = new HashMap<String, List<ImportRegistration>>();

    public TopologyManagerImport(BundleContext bc) {
        this.rsaSet = new HashSet<RemoteServiceAdmin>();
        this.bctx = bc;
        this.endpointListenerManager = new EndpointListenerManager(this.bctx, this);
        this.execService = new ThreadPoolExecutor(5, 10, 50L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.listenerHook = new ListenerHookImpl(bc, this);
        this.findHook = new RSFindHook(bc, this);
    }

    public void start() {
        this.bctx.registerService(RemoteServiceAdminListener.class, (Object)this, null);
        this.bctx.registerService(ListenerHook.class, (Object)this.listenerHook, null);
        this.bctx.registerService(FindHook.class, (Object)this.findHook, null);
        this.endpointListenerManager.start();
    }

    public void stop() {
        this.endpointListenerManager.stop();
        this.execService.shutdown();
    }

    @Override
    public void addServiceInterest(String filter) {
        if (this.importInterestsCounter.add(filter) == 1) {
            this.endpointListenerManager.extendScope(filter);
        }
    }

    @Override
    public void removeServiceInterest(String filter) {
        if (this.importInterestsCounter.remove(filter) == 0) {
            LOG.debug("last reference to import interest is gone -> removing interest filter: {}", (Object)filter);
            this.endpointListenerManager.reduceScope(filter);
            List irs = this.remove(filter, this.importedServices);
            if (irs != null) {
                for (ImportRegistration ir : irs) {
                    ir.close();
                }
            }
        }
    }

    public void endpointAdded(EndpointDescription endpoint, String filter) {
        if (filter == null) {
            LOG.error("Endpoint is not handled because no matching filter was provided!");
            return;
        }
        LOG.debug("importable service added for filter {}, endpoint {}", (Object)filter, (Object)endpoint);
        this.addImportPossibility(endpoint, filter);
        this.triggerImport(filter);
    }

    public void endpointRemoved(EndpointDescription endpoint, String filter) {
        LOG.debug("EndpointRemoved {}", (Object)endpoint);
        this.removeImportPossibility(endpoint, filter);
        this.triggerImport(filter);
    }

    private void addImportPossibility(EndpointDescription endpoint, String filter) {
        this.put(filter, this.importPossibilities, endpoint);
    }

    private void removeImportPossibility(EndpointDescription endpoint, String filter) {
        List endpoints = this.get(filter, this.importPossibilities);
        this.remove(filter, this.importPossibilities, endpoint);
        if (endpoints.isEmpty()) {
            this.remove(filter, this.importPossibilities, null);
        }
    }

    public void add(RemoteServiceAdmin rsa) {
        this.rsaSet.add(rsa);
        for (String filter : this.keySet(this.importPossibilities)) {
            this.triggerImport(filter);
        }
    }

    public void remove(RemoteServiceAdmin rsa) {
        this.rsaSet.remove(rsa);
    }

    private void triggerImport(final String filter) {
        LOG.debug("Import of a service for filter {} was queued", (Object)filter);
        this.execService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TopologyManagerImport.this.unexportNotAvailableServices(filter);
                    TopologyManagerImport.this.importServices(filter);
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private void unexportNotAvailableServices(String filter) {
        List importRegistrations = this.get(filter, this.importedServices);
        for (ImportRegistration ir : importRegistrations) {
            EndpointDescription endpoint = ir.getImportReference().getImportedEndpoint();
            if (this.isImportPossibilityAvailable(endpoint, filter)) continue;
            this.removeImport(ir, null);
        }
    }

    private boolean isImportPossibilityAvailable(EndpointDescription endpoint, String filter) {
        List endpoints = this.get(filter, this.importPossibilities);
        return endpoints != null && endpoints.contains(endpoint);
    }

    private void importServices(String filter) {
        List<ImportRegistration> importRegistrations = this.get(filter, this.importedServices);
        for (EndpointDescription endpoint : this.get(filter, this.importPossibilities)) {
            ImportRegistration ir;
            if (this.alreadyImported(endpoint, importRegistrations) || (ir = this.importService(endpoint)) == null) continue;
            this.put(filter, this.importedServices, ir);
            if (this.importAllAvailable) continue;
            return;
        }
    }

    private boolean alreadyImported(EndpointDescription endpoint, List<ImportRegistration> importRegistrations) {
        if (importRegistrations != null) {
            for (ImportRegistration ir : importRegistrations) {
                if (!endpoint.equals((Object)ir.getImportReference().getImportedEndpoint())) continue;
                return true;
            }
        }
        return false;
    }

    private ImportRegistration importService(EndpointDescription endpoint) {
        for (RemoteServiceAdmin rsa : this.rsaSet) {
            ImportRegistration ir = rsa.importService(endpoint);
            if (ir == null) continue;
            if (ir.getException() == null) {
                LOG.debug("Service import was successful {}", (Object)ir);
                return ir;
            }
            LOG.info("Error importing service " + endpoint, ir.getException());
        }
        return null;
    }

    private void removeImport(ImportRegistration reg, ImportReference ref) {
        ArrayList<ImportRegistration> removed = new ArrayList<ImportRegistration>();
        Set entries = this.entrySet(this.importedServices);
        for (Map.Entry entry : entries) {
            for (ImportRegistration ir : entry.getValue()) {
                if (!ir.equals(reg) && !ir.getImportReference().equals(ref)) continue;
                removed.add(ir);
                this.remove(entry.getKey(), this.importedServices, ir);
            }
        }
        for (ImportRegistration ir : removed) {
            ir.close();
        }
    }

    public void remoteAdminEvent(RemoteServiceAdminEvent event) {
        if (event.getType() == 4) {
            this.removeImport(null, event.getImportReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void put(String key, Map<String, List<T>> map, T value) {
        Map<String, List<T>> map2 = map;
        synchronized (map2) {
            List<T> list = map.get(key);
            if (list == null) {
                list = new CopyOnWriteArrayList<T>();
                map.put(key, list);
            }
            if (!list.contains(value)) {
                list.add(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> get(String key, Map<String, List<T>> map) {
        Map<String, List<T>> map2 = map;
        synchronized (map2) {
            List<T> list = map.get(key);
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> remove(String key, Map<String, List<T>> map) {
        Map<String, List<T>> map2 = map;
        synchronized (map2) {
            return map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void remove(String key, Map<String, List<T>> map, T value) {
        Map<String, List<T>> map2 = map;
        synchronized (map2) {
            List<T> list = map.get(key);
            if (list != null) {
                list.remove(value);
                if (list.isEmpty()) {
                    map.remove(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Set<Map.Entry<String, List<T>>> entrySet(Map<String, List<T>> map) {
        Map<String, List<T>> map2 = map;
        synchronized (map2) {
            Set<Map.Entry<String, List<T>>> entries = map.entrySet();
            return new HashSet<Map.Entry<String, List<T>>>(entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Set<String> keySet(Map<String, List<T>> map) {
        Map<String, List<T>> map2 = map;
        synchronized (map2) {
            Set<String> keySet = map.keySet();
            return new HashSet<String>(keySet);
        }
    }
}

