/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.AbstractRenderer;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.IterativeOutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.LayoutPagebreakHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.process.ApplyAutoCommitPageHeaderStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CleanFlowBoxesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CountBoxesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.FillFlowPagesStep;
import org.pentaho.reporting.engine.classic.core.states.PerformanceMonitorContext;

public class StreamingRenderer
extends AbstractRenderer {
    private static final Log logger = LogFactory.getLog(StreamingRenderer.class);
    private CountBoxesStep countBoxesStep = new CountBoxesStep();
    private CleanFlowBoxesStep cleanBoxesStep = new CleanFlowBoxesStep();
    private ApplyAutoCommitPageHeaderStep applyAutoCommitPageHeaderStep = new ApplyAutoCommitPageHeaderStep();
    private FillFlowPagesStep fillPhysicalPagesStep = new FillFlowPagesStep();
    private int floodPrevention;
    private int pageCount;

    public StreamingRenderer(OutputProcessor outputProcessor) {
        super(outputProcessor);
        this.initialize();
    }

    @Override
    protected boolean isPageFinished() {
        return !this.getPageBox().isOpen();
    }

    @Override
    public void startReport(ReportDefinition report, ProcessingContext processingContext, PerformanceMonitorContext performanceMonitorContext) {
        this.pageCount = 0;
        super.startReport(report, processingContext, performanceMonitorContext);
    }

    @Override
    public void processIncrementalUpdate(boolean performOutput) throws ContentProcessingException {
        if (!this.isDirty()) {
            return;
        }
        this.clearDirty();
        ++this.floodPrevention;
        if (this.floodPrevention < 50) {
            return;
        }
        this.floodPrevention = 0;
        OutputProcessor outputProcessor = this.getOutputProcessor();
        if (!(outputProcessor instanceof IterativeOutputProcessor) || !outputProcessor.getMetaData().isFeatureSupported(OutputProcessorFeature.ITERATIVE_RENDERING)) {
            return;
        }
        LogicalPageBox pageBox = this.getPageBox();
        pageBox.setPageOffset(0L);
        pageBox.setPageEnd(pageBox.getHeight());
        if (pageBox.isOpen()) {
            IterativeOutputProcessor io = (IterativeOutputProcessor)outputProcessor;
            if (this.applyAutoCommitPageHeaderStep.compute(pageBox)) {
                io.processIterativeContent(pageBox, performOutput);
                this.countBoxesStep.process(pageBox);
                this.cleanBoxesStep.compute(pageBox);
            }
        }
    }

    @Override
    protected boolean performPagination(LayoutPagebreakHandler handler, boolean performOutput) throws ContentProcessingException {
        if (!performOutput) {
            return false;
        }
        OutputProcessor outputProcessor = this.getOutputProcessor();
        LogicalPageBox pageBox = this.getPageBox();
        pageBox.setPageOffset(0L);
        pageBox.setPageEnd(pageBox.getHeight());
        if (pageBox.isOpen()) {
            return false;
        }
        long nextOffset = pageBox.computePageEnd();
        pageBox.setPageEnd(nextOffset);
        long pageOffset = pageBox.getPageOffset();
        this.applyAutoCommitPageHeaderStep.commitAll(pageBox);
        if (outputProcessor.isNeedAlignedPage()) {
            LogicalPageBox box = this.fillPhysicalPagesStep.compute(pageBox, pageOffset, nextOffset);
            logger.debug((Object)("Processing contents for stream. Page-Offset: " + pageOffset + " -> " + nextOffset));
            outputProcessor.processContent(box);
        } else {
            logger.debug((Object)("Processing fast contents for stream. Page-Offset: " + pageOffset + " -> " + nextOffset));
            outputProcessor.processContent(pageBox);
        }
        this.countBoxesStep.process(pageBox);
        this.cleanBoxesStep.compute(pageBox);
        this.debugPrint(pageBox);
        outputProcessor.processingFinished();
        this.pageCount = 1;
        this.setPagebreaks(1);
        return false;
    }

    @Override
    public int getPageCount() {
        return this.pageCount;
    }

    @Override
    protected void debugPrint(LogicalPageBox pageBox) {
    }

    @Override
    public void createRollbackInformation() {
        throw new UnsupportedOperationException("Streaming-Renderer do not implement the createRollbackInformation-method.");
    }

    @Override
    public void applyRollbackInformation() {
        throw new UnsupportedOperationException("Streaming-Renderer do not implement the applyRollbackInformation method.");
    }

    @Override
    public void rollback() {
        throw new UnsupportedOperationException("Streaming-Renderer do not implement the rollback method.");
    }
}

