/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output.crosstab;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.CrosstabCell;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroupBody;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultOutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.output.GroupOutputHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.crosstab.CrosstabOutputHelper;
import org.pentaho.reporting.engine.classic.core.layout.output.crosstab.RenderedCrosstabLayout;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class CrosstabRowOutputHandler
implements GroupOutputHandler {
    private static final Log logger = LogFactory.getLog(CrosstabRowOutputHandler.class);

    @Override
    public void groupStarted(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        int firstRowGroupIndex;
        RenderedCrosstabLayout crosstabLayout = outputFunction.getCurrentRenderedCrosstabLayout();
        LayoutModelBuilder layoutModelBuilder = outputFunction.getRenderer().getNormalFlowLayoutModelBuilder();
        int gidx = event.getState().getCurrentGroupIndex();
        CrosstabRowGroup group = (CrosstabRowGroup)event.getReport().getGroup(gidx);
        if (!crosstabLayout.isCrosstabTableOpen()) {
            this.buildHeaderPlaceholder(crosstabLayout, layoutModelBuilder);
            crosstabLayout.setFirstRowGroupIndex(gidx);
            crosstabLayout.setCrosstabTableOpen(true);
        }
        if (crosstabLayout.isCrosstabHeaderOpen()) {
            layoutModelBuilder.startSubFlow(crosstabLayout.getRowTitleHeaderId());
            CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder);
            outputFunction.getRenderer().add(group.getTitleHeader(), outputFunction.getRuntime());
            layoutModelBuilder.finishBox();
            layoutModelBuilder.suspendSubFlow();
        }
        if (!crosstabLayout.isCrosstabRowOpen()) {
            layoutModelBuilder.startBox(CrosstabOutputHelper.createTableRow());
            crosstabLayout.setCrosstabRowOpen(true);
            layoutModelBuilder.legacyFlagNotEmpty();
            TableSectionRenderBox rowRenderNode = CrosstabOutputHelper.findTableSection(layoutModelBuilder.dangerousRawAccess());
            int i = crosstabLayout.getFirstRowGroupIndex();
            int count = 0;
            while (i < gidx) {
                InstanceID rowHeader = crosstabLayout.getRowHeader(i - crosstabLayout.getFirstRowGroupIndex());
                RenderNode cell = CrosstabOutputHelper.findNode(rowRenderNode, rowHeader);
                if (!(cell instanceof TableCellRenderBox)) {
                    throw new IllegalStateException("Unable to find previously defined row header. Aborting report processing.");
                }
                TableCellRenderBox cellBox = (TableCellRenderBox)cell;
                cellBox.update(cellBox.getRowSpan() + 1, cellBox.getColSpan());
                ++i;
                ++count;
            }
        }
        if (gidx == (firstRowGroupIndex = crosstabLayout.getFirstRowGroupIndex())) {
            RenderNode renderNode = layoutModelBuilder.dangerousRawAccess();
            RenderBox parentNode = (RenderBox)CrosstabOutputHelper.findParentNode(renderNode, crosstabLayout.getCrosstabId());
            parentNode.setPreventPagination(true);
        }
        CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder, 1, 1, group.getHeader());
        crosstabLayout.setRowHeader(gidx - crosstabLayout.getFirstRowGroupIndex(), layoutModelBuilder.dangerousRawAccess().getInstanceId());
        outputFunction.getRenderer().add(group.getHeader(), outputFunction.getRuntime());
        layoutModelBuilder.finishBox();
    }

    @Override
    public void groupFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        int firstRowGroupIndex;
        int gidx;
        CrosstabOutputHelper.printCrosstabSummary(outputFunction, event);
        RenderedCrosstabLayout crosstabLayout = outputFunction.getCurrentRenderedCrosstabLayout();
        LayoutModelBuilder layoutModelBuilder = outputFunction.getRenderer().getNormalFlowLayoutModelBuilder();
        if (crosstabLayout.isCrosstabRowOpen()) {
            layoutModelBuilder.finishBox();
            crosstabLayout.setCrosstabRowOpen(false);
        }
        if (crosstabLayout.isCrosstabHeaderOpen()) {
            InstanceID[] columnHeaders = crosstabLayout.getColumnHeaderSubFlows();
            for (int i = 0; i < columnHeaders.length; ++i) {
                InstanceID columnHeader = columnHeaders[i];
                layoutModelBuilder.startSubFlow(columnHeader);
                layoutModelBuilder.endSubFlow();
            }
            crosstabLayout.setCrosstabHeaderOpen(false);
        }
        if ((gidx = event.getState().getCurrentGroupIndex()) == (firstRowGroupIndex = crosstabLayout.getFirstRowGroupIndex())) {
            RenderNode renderNode = layoutModelBuilder.dangerousRawAccess();
            RenderBox parentNode = (RenderBox)CrosstabOutputHelper.findParentNode(renderNode, crosstabLayout.getCrosstabId());
            parentNode.setPreventPagination(false);
        }
    }

    @Override
    public void groupBodyFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
    }

    private void buildHeaderPlaceholder(RenderedCrosstabLayout crosstabLayout, LayoutModelBuilder layoutModelBuilder) {
        crosstabLayout.setCrosstabId(layoutModelBuilder.startBox(CrosstabOutputHelper.createTable(crosstabLayout.getTableLayout())));
        layoutModelBuilder.startBox(CrosstabOutputHelper.createTableBand("table-header"));
        int columnGroupCount = crosstabLayout.getColumnGroups();
        if (crosstabLayout.isGenerateColumnTitleHeaders()) {
            columnGroupCount += crosstabLayout.getColumnGroups();
        }
        if (crosstabLayout.isGenerateMeasureHeaders()) {
            ++columnGroupCount;
        }
        InstanceID[] columnHeaders = new InstanceID[Math.max(1, columnGroupCount)];
        for (int i = 0; i < columnHeaders.length; ++i) {
            columnHeaders[i] = layoutModelBuilder.createSubflowPlaceholder(CrosstabOutputHelper.createTableRow());
        }
        if (columnHeaders.length > 1) {
            layoutModelBuilder.startSubFlow(columnHeaders[0]);
            CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder, crosstabLayout.getRowGroups(), columnHeaders.length - 1);
            layoutModelBuilder.legacyFlagNotEmpty();
            layoutModelBuilder.finishBox();
            layoutModelBuilder.suspendSubFlow();
        }
        layoutModelBuilder.finishBox();
        layoutModelBuilder.startBox(CrosstabOutputHelper.createTableBand("table-body"));
        crosstabLayout.setCrosstabHeaderOpen(true);
        crosstabLayout.setColumnHeaderRowIds(columnHeaders);
    }

    @Override
    public void itemsStarted(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        throw new ReportProcessingException("A crosstab-row cannot contain a detail band. Never.");
    }

    @Override
    public void itemsAdvanced(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        throw new ReportProcessingException("A crosstab-row cannot contain a detail band. Never.");
    }

    @Override
    public void itemsFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        throw new ReportProcessingException("A crosstab-row cannot contain a detail band. Never.");
    }

    @Override
    public void summaryRowStart(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        RenderedCrosstabLayout crosstabLayout = outputFunction.getCurrentRenderedCrosstabLayout();
        LayoutModelBuilder layoutModelBuilder = outputFunction.getRenderer().getNormalFlowLayoutModelBuilder();
        if (crosstabLayout.isCrosstabRowOpen()) {
            throw new IllegalStateException("Event Order Error: A summary row cannot be printed while a row is still open.");
        }
        int gidx = event.getState().getCurrentGroupIndex() + 1;
        CrosstabRowGroup group = (CrosstabRowGroup)event.getReport().getGroup(gidx);
        if (!group.isPrintSummary()) {
            crosstabLayout.startSummaryRowProcessing(false, gidx, null);
            return;
        }
        if (group.getField() == null) {
            crosstabLayout.startSummaryRowProcessing(false, gidx, null);
            return;
        }
        CrosstabCellBody dataBody = event.getReport().getCrosstabCellBody();
        CrosstabCell element = dataBody.findElement(group.getField(), null);
        if (element == null) {
            crosstabLayout.startSummaryRowProcessing(false, gidx, null);
            return;
        }
        if (!crosstabLayout.isCrosstabRowOpen()) {
            layoutModelBuilder.startBox(CrosstabOutputHelper.createTableRow());
            crosstabLayout.setCrosstabRowOpen(true);
            layoutModelBuilder.legacyFlagNotEmpty();
            TableSectionRenderBox rowRenderNode = CrosstabOutputHelper.findTableSection(layoutModelBuilder.dangerousRawAccess());
            int i = crosstabLayout.getFirstRowGroupIndex();
            int count = 0;
            while (i < gidx) {
                InstanceID rowHeader = crosstabLayout.getRowHeader(i - crosstabLayout.getFirstRowGroupIndex());
                RenderNode cell = CrosstabOutputHelper.findNode(rowRenderNode, rowHeader);
                if (!(cell instanceof TableCellRenderBox)) {
                    throw new IllegalStateException("Unable to find previously defined row header. Aborting report processing.");
                }
                TableCellRenderBox cellBox = (TableCellRenderBox)cell;
                cellBox.update(cellBox.getRowSpan() + 1, cellBox.getColSpan());
                ++i;
                ++count;
            }
        }
        int colSpan = crosstabLayout.getFirstColGroupIndex() - gidx;
        CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder, colSpan, 1, group.getSummaryHeader());
        crosstabLayout.setRowHeader(gidx - crosstabLayout.getFirstRowGroupIndex(), layoutModelBuilder.dangerousRawAccess().getInstanceId());
        outputFunction.getRenderer().add(group.getSummaryHeader(), outputFunction.getRuntime());
        layoutModelBuilder.finishBox();
        crosstabLayout.startSummaryRowProcessing(true, gidx, group.getField());
        crosstabLayout.setDetailsRendered(false);
        crosstabLayout.setProcessingCrosstabHeader(false);
    }

    @Override
    public void summaryRowEnd(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        RenderedCrosstabLayout crosstabLayout = outputFunction.getCurrentRenderedCrosstabLayout();
        if (!crosstabLayout.isSummaryRowPrintable()) {
            return;
        }
        LayoutModelBuilder layoutModelBuilder = outputFunction.getRenderer().getNormalFlowLayoutModelBuilder();
        if (crosstabLayout.isCrosstabRowOpen()) {
            this.printSummaryCell(outputFunction, event);
            layoutModelBuilder.finishBox();
            crosstabLayout.setCrosstabRowOpen(false);
        }
    }

    @Override
    public void summaryRow(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        RenderedCrosstabLayout crosstabLayout = outputFunction.getCurrentRenderedCrosstabLayout();
        if (!crosstabLayout.isSummaryRowPrintable()) {
            return;
        }
        this.printSummaryCell(outputFunction, event);
    }

    private void printSummaryCell(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        String columnField;
        RenderedCrosstabLayout crosstabLayout = outputFunction.getCurrentRenderedCrosstabLayout();
        int gidx = event.getState().getCurrentGroupIndex();
        Group group = event.getReport().getGroup(gidx);
        GroupBody groupBody = group.getBody();
        if (groupBody instanceof CrosstabColumnGroupBody) {
            CrosstabColumnGroupBody columnGroupBody = (CrosstabColumnGroupBody)groupBody;
            CrosstabColumnGroup next = columnGroupBody.getGroup();
            if (!next.isPrintSummary()) {
                return;
            }
            columnField = next.getField();
        } else if (groupBody instanceof CrosstabRowGroupBody) {
            CrosstabColumnGroup colGroup = (CrosstabColumnGroup)event.getReport().getGroup(crosstabLayout.getFirstColGroupIndex());
            if (!colGroup.isPrintSummary()) {
                return;
            }
            columnField = colGroup.getField();
        } else {
            columnField = null;
        }
        LayoutModelBuilder layoutModelBuilder = outputFunction.getRenderer().getNormalFlowLayoutModelBuilder();
        CrosstabCellBody dataBody = event.getReport().getCrosstabCellBody();
        CrosstabCell element = dataBody.findElement(crosstabLayout.getSummaryRowField(), columnField);
        if (element != null) {
            CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder);
            layoutModelBuilder.legacyFlagNotEmpty();
            outputFunction.getRenderer().startSection(Renderer.SectionType.NORMALFLOW);
            outputFunction.getRenderer().add(element, outputFunction.getRuntime());
            outputFunction.addSubReportMarkers(outputFunction.getRenderer().endSection());
            layoutModelBuilder.finishBox();
        } else {
            CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder);
            layoutModelBuilder.legacyFlagNotEmpty();
            logger.debug((Object)String.format("Unable to find summary cell: %s - %s", crosstabLayout.getSummaryRowField(), columnField));
            layoutModelBuilder.finishBox();
        }
    }
}

