/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.richtext;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import javax.swing.text.rtf.RTFEditorKit;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.types.LabelType;
import org.pentaho.reporting.engine.classic.core.layout.richtext.RichTextConverter;
import org.pentaho.reporting.engine.classic.core.layout.richtext.RichTextConverterUtilities;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;

public class RtfRichTextConverter
implements RichTextConverter {
    private RTFEditorKit editorKit = new RTFEditorKit();

    @Override
    public boolean isRecognizedType(String mimeType) {
        if (mimeType.equals("application/rtf")) {
            return true;
        }
        return mimeType.equals("text/rtf");
    }

    @Override
    public Object convert(ReportElement source, Object value) {
        try {
            Document doc = RichTextConverterUtilities.parseDocument(this.editorKit, value);
            if (doc == null) {
                return value;
            }
            Element element = this.process(doc.getDefaultRootElement());
            Band band = RichTextConverterUtilities.convertToBand(StyleKey.getDefinedStyleKeysList(), source, element);
            band.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "inline");
            return band;
        }
        catch (Exception e) {
            return value;
        }
    }

    private void configureStyle(AttributeSet attributes, Element element) {
        Object underline;
        Object strikeThrough;
        Object spaceBelow;
        Object spaceAbove;
        Object lineSpacing;
        Object leftIndent;
        Object italic;
        Object foreground;
        Object fontSize;
        Object family;
        Object firstLineIndent;
        Object bold;
        Object background;
        Object alignment = attributes.getAttribute(StyleConstants.Alignment);
        if (alignment instanceof Integer) {
            int alignmentValue = (Integer)alignment;
            if (1 == alignmentValue) {
                element.getStyle().setStyleProperty(ElementStyleKeys.ALIGNMENT, ElementAlignment.CENTER);
            } else if (2 == alignmentValue) {
                element.getStyle().setStyleProperty(ElementStyleKeys.ALIGNMENT, ElementAlignment.RIGHT);
            } else if (3 == alignmentValue) {
                element.getStyle().setStyleProperty(ElementStyleKeys.ALIGNMENT, ElementAlignment.JUSTIFY);
            } else {
                element.getStyle().setStyleProperty(ElementStyleKeys.ALIGNMENT, ElementAlignment.LEFT);
            }
        }
        if ((background = attributes.getAttribute(StyleConstants.Background)) instanceof Color) {
            element.getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, background);
        }
        if ((bold = attributes.getAttribute(StyleConstants.Bold)) instanceof Boolean) {
            element.getStyle().setStyleProperty(TextStyleKeys.BOLD, bold);
        }
        if ((firstLineIndent = attributes.getAttribute(StyleConstants.FirstLineIndent)) instanceof Float) {
            element.getStyle().setStyleProperty(TextStyleKeys.FIRST_LINE_INDENT, firstLineIndent);
        }
        if ((family = attributes.getAttribute(StyleConstants.FontFamily)) instanceof String) {
            element.getStyle().setStyleProperty(TextStyleKeys.FONT, family);
        }
        if ((fontSize = attributes.getAttribute(StyleConstants.FontSize)) instanceof Integer) {
            element.getStyle().setStyleProperty(TextStyleKeys.FONTSIZE, fontSize);
        }
        if ((foreground = attributes.getAttribute(StyleConstants.Foreground)) instanceof Color) {
            element.getStyle().setStyleProperty(ElementStyleKeys.PAINT, foreground);
        }
        if ((italic = attributes.getAttribute(StyleConstants.Italic)) instanceof Boolean) {
            element.getStyle().setStyleProperty(TextStyleKeys.ITALIC, italic);
        }
        if ((leftIndent = attributes.getAttribute(StyleConstants.LeftIndent)) instanceof Float) {
            element.getStyle().setStyleProperty(TextStyleKeys.TEXT_INDENT, leftIndent);
        }
        if ((lineSpacing = attributes.getAttribute(StyleConstants.LineSpacing)) instanceof Float) {
            element.getStyle().setStyleProperty(TextStyleKeys.LINEHEIGHT, lineSpacing);
        }
        if ((spaceAbove = attributes.getAttribute(StyleConstants.SpaceAbove)) instanceof Float) {
            element.getStyle().setStyleProperty(ElementStyleKeys.PADDING_TOP, spaceAbove);
        }
        if ((spaceBelow = attributes.getAttribute(StyleConstants.SpaceBelow)) instanceof Float) {
            element.getStyle().setStyleProperty(ElementStyleKeys.PADDING_BOTTOM, spaceBelow);
        }
        if ((strikeThrough = attributes.getAttribute(StyleConstants.StrikeThrough)) instanceof Boolean) {
            element.getStyle().setStyleProperty(TextStyleKeys.STRIKETHROUGH, strikeThrough);
        }
        if ((underline = attributes.getAttribute(StyleConstants.Underline)) instanceof Boolean) {
            element.getStyle().setStyleProperty(TextStyleKeys.UNDERLINED, underline);
        }
        element.getStyle().setStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT, Boolean.TRUE);
    }

    private Element process(javax.swing.text.Element textElement) throws BadLocationException {
        if (textElement.isLeaf()) {
            int endOffset = textElement.getEndOffset();
            int startOffset = textElement.getStartOffset();
            String text = textElement.getDocument().getText(startOffset, endOffset - startOffset);
            Element result = new Element();
            result.setElementType(LabelType.INSTANCE);
            result.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", text);
            this.configureStyle(textElement.getAttributes(), result);
            return result;
        }
        Band band = new Band();
        this.configureStyle(textElement.getAttributes(), band);
        this.configureBand(textElement, band);
        int size = textElement.getElementCount();
        for (int i = 0; i < size; ++i) {
            Element element = this.process(textElement.getElement(i));
            band.addElement(element);
        }
        return band;
    }

    private void configureBand(javax.swing.text.Element textElement, Band band) {
        if ("paragraph".equals(textElement.getName()) || "section".equals(textElement.getName())) {
            band.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "block");
            band.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, new Float(-100.0f));
        } else {
            band.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "inline");
        }
    }
}

