/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence;

import java.math.BigDecimal;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.AbstractSequence;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.NumberSequenceDescription;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceDescription;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;

public class NumberSequence
extends AbstractSequence {
    @Override
    public SequenceDescription getSequenceDescription() {
        return new NumberSequenceDescription();
    }

    @Override
    public TableModel produce(DataRow parameters, DataFactoryContext dataFactoryContext) throws ReportDataFactoryException {
        Integer limit = this.getTypedParameter("limit", Integer.class, 100);
        BigDecimal stepSize = this.getTypedParameter("step", BigDecimal.class, new BigDecimal(1));
        BigDecimal start = this.getTypedParameter("start", BigDecimal.class, new BigDecimal(1));
        Boolean ascending = this.getTypedParameter("ascending", Boolean.class, true);
        TypedTableModel tableModel = new TypedTableModel();
        tableModel.addColumn("number", BigDecimal.class);
        BigDecimal value = Boolean.TRUE.equals(ascending) ? start : start.add(stepSize.multiply(new BigDecimal(limit)));
        for (int i = 0; i < limit; ++i) {
            tableModel.setValueAt(value, i, 0);
            value = value.add(stepSize);
        }
        return tableModel;
    }
}

