/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class FunctionStorageKey {
    private ReportStateKey parentKey;
    private InstanceID reportId;
    private String reportName;

    protected FunctionStorageKey(ReportStateKey parentKey, InstanceID reportId, String reportName) {
        this.parentKey = parentKey;
        this.reportId = reportId;
        this.reportName = reportName;
    }

    public String getReportName() {
        return this.reportName;
    }

    public InstanceID getReportId() {
        return this.reportId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionStorageKey that = (FunctionStorageKey)o;
        if (this.reportId != that.reportId) {
            return false;
        }
        return !(this.parentKey != null ? !this.parentKey.equals(that.parentKey) : that.parentKey != null);
    }

    public int hashCode() {
        int result = this.parentKey != null ? this.parentKey.hashCode() : 0;
        result = 31 * result + this.reportId.hashCode();
        return result;
    }

    public String toString() {
        return "FunctionStorageKey{reportId=" + this.reportId + ", reportName=" + this.reportName + " ,parentKey=" + this.parentKey + '}';
    }

    public static FunctionStorageKey createKey(ReportStateKey parent, ReportDefinition reportDefinition) {
        String name = reportDefinition.getName();
        return new FunctionStorageKey(parent, reportDefinition.getObjectID(), name);
    }
}

