/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard;

import org.pentaho.reporting.engine.classic.core.wizard.ConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeReference;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;

public class StaticDataAttributeReference
implements DataAttributeReference {
    private String name;
    private String domain;
    private Class type;
    private ConceptQueryMapper queryMapper;

    public StaticDataAttributeReference(String domain, String name) {
        this(domain, name, Object.class, DefaultConceptQueryMapper.INSTANCE);
    }

    public StaticDataAttributeReference(String domain, String name, Class type, ConceptQueryMapper queryMapper) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (queryMapper == null) {
            throw new NullPointerException();
        }
        this.domain = domain;
        this.name = name;
        this.type = type;
        this.queryMapper = queryMapper;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object resolve(DataAttributes attributes, DataAttributeContext context) {
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        Object value = attributes.getMetaAttribute(this.domain, this.name, null, context);
        return this.queryMapper.getValue(value, this.type, context);
    }

    @Override
    public ConceptQueryMapper resolveMapper(DataAttributes attributes) {
        return this.queryMapper;
    }
}

