/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.repo.controller;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.LastUsedFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleJobException;
import org.pentaho.di.core.exception.KettleObjectExistsException;
import org.pentaho.di.core.exception.KettleTransException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryExtended;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.repo.model.RepositoryDirectory;
import org.pentaho.repo.model.RepositoryFile;
import org.pentaho.repo.util.Util;

public class RepositoryBrowserController {
    public static final String TRANSFORMATION = "transformation";
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;

    public boolean loadFile(String id, String type) {
        try {
            this.getSpoon().getDisplay().asyncExec(() -> {
                try {
                    this.getSpoon().loadObjectFromRepository(() -> id, type.equals(TRANSFORMATION) ? RepositoryObjectType.TRANSFORMATION : RepositoryObjectType.JOB, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String getActiveFileName() {
        try {
            return this.getSpoon().getActiveMeta().getName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public ObjectId rename(String id, String path, String newName, String type, String oldName) throws KettleException {
        RepositoryDirectoryInterface repositoryDirectoryInterface = this.getRepository().findDirectory(path);
        ObjectId objectId = null;
        switch (type) {
            case "job": {
                if (this.getRepository().exists(newName, repositoryDirectoryInterface, RepositoryObjectType.JOB)) {
                    throw new KettleObjectExistsException();
                }
                if (this.isJobOpened(id, path, oldName)) {
                    throw new KettleJobException();
                }
                this.renameRecent(id, type, newName);
                objectId = this.getRepository().renameJob(() -> id, repositoryDirectoryInterface, newName);
                break;
            }
            case "transformation": {
                if (this.getRepository().exists(newName, repositoryDirectoryInterface, RepositoryObjectType.TRANSFORMATION)) {
                    throw new KettleObjectExistsException();
                }
                if (this.isTransOpened(id, path, oldName)) {
                    throw new KettleTransException();
                }
                this.renameRecent(id, type, newName);
                objectId = this.getRepository().renameTransformation(() -> id, repositoryDirectoryInterface, newName);
                break;
            }
            case "folder": {
                RepositoryDirectoryInterface child;
                this.isFileOpenedInFolder(path);
                RepositoryDirectoryInterface parent = this.getRepository().findDirectory(path).getParent();
                if (parent == null) {
                    parent = this.getRepository().findDirectory(path);
                }
                if ((child = parent.findChild(newName)) != null) {
                    throw new KettleObjectExistsException();
                }
                objectId = this.getRepository() instanceof RepositoryExtended ? ((RepositoryExtended)this.getRepository()).renameRepositoryDirectory(() -> id, null, newName, true) : this.getRepository().renameRepositoryDirectory(() -> id, null, newName);
            }
        }
        return objectId;
    }

    private boolean isTransOpened(String id, String path, String name) {
        List openedTransFiles = this.getSpoon().delegates.trans.getTransformationList();
        for (TransMeta t : openedTransFiles) {
            if ((t.getObjectId() == null || !id.equals(t.getObjectId().getId())) && (!path.equals(t.getRepositoryDirectory().getPath()) || !name.equals(t.getName()))) continue;
            return true;
        }
        return false;
    }

    private boolean isJobOpened(String id, String path, String name) {
        List openedJobFiles = this.getSpoon().delegates.jobs.getJobList();
        for (JobMeta j : openedJobFiles) {
            if ((j.getObjectId() == null || !id.equals(j.getObjectId().getId())) && (!path.equals(j.getRepositoryDirectory().getPath()) || !name.equals(j.getName()))) continue;
            return true;
        }
        return false;
    }

    private void isFileOpenedInFolder(String path) throws KettleException {
        List openedTransFiles = this.getSpoon().delegates.trans.getTransformationList();
        for (TransMeta t : openedTransFiles) {
            if (t.getRepositoryDirectory().getPath() == null || !(t.getRepositoryDirectory().getPath() + "/").startsWith(path + "/")) continue;
            throw new KettleTransException();
        }
        List openedJobFiles = this.getSpoon().delegates.jobs.getJobList();
        for (JobMeta j : openedJobFiles) {
            if (j.getRepositoryDirectory().getPath() == null || !(j.getRepositoryDirectory().getPath() + "/").startsWith(path + "/")) continue;
            throw new KettleJobException();
        }
    }

    private void removeRecentsUsingPath(String path) {
        Collection lastUsedRepoFiles = PropsUI.getInstance().getLastUsedRepoFiles().values();
        for (List lastUsedFiles : lastUsedRepoFiles) {
            for (int i = 0; i < lastUsedFiles.size(); ++i) {
                if (!(((LastUsedFile)lastUsedFiles.get(i)).getDirectory() + "/").startsWith(path + "/")) continue;
                lastUsedFiles.remove(i);
                --i;
            }
        }
    }

    public boolean remove(String id, String name, String path, String type) throws KettleException {
        try {
            switch (type) {
                case "job": {
                    if (this.isJobOpened(id, path, name)) {
                        throw new KettleJobException();
                    }
                    this.removeRecent(id, type);
                    this.getRepository().deleteJob(() -> id);
                    break;
                }
                case "transformation": {
                    if (this.isTransOpened(id, path, name)) {
                        throw new KettleTransException();
                    }
                    this.removeRecent(id, type);
                    this.getRepository().deleteTransformation(() -> id);
                    break;
                }
                case "folder": {
                    this.isFileOpenedInFolder(path);
                    this.removeRecentsUsingPath(path);
                    RepositoryDirectoryInterface repositoryDirectoryInterface = this.getRepository().findDirectory(path);
                    if (this.getRepository() instanceof RepositoryExtended) {
                        ((RepositoryExtended)this.getRepository()).deleteRepositoryDirectory(repositoryDirectoryInterface, true);
                        break;
                    }
                    this.getRepository().deleteRepositoryDirectory(repositoryDirectoryInterface);
                }
            }
            return true;
        }
        catch (KettleJobException | KettleTransException ke) {
            throw ke;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean removeRecent(String id, String type) {
        RepositoryObject repositoryObject = null;
        try {
            repositoryObject = this.getRepository().getObjectInformation(() -> id, type == TRANSFORMATION ? RepositoryObjectType.TRANSFORMATION : RepositoryObjectType.JOB);
        }
        catch (Exception e) {
            return false;
        }
        if (repositoryObject != null) {
            Collection lastUsedRepoFiles = PropsUI.getInstance().getLastUsedRepoFiles().values();
            for (List lastUsedFiles : lastUsedRepoFiles) {
                for (LastUsedFile lastUsedFile : lastUsedFiles) {
                    if (!lastUsedFile.getDirectory().equals(repositoryObject.getRepositoryDirectory().getPath()) || !lastUsedFile.getFilename().equals(repositoryObject.getName())) continue;
                    lastUsedFiles.remove(lastUsedFile);
                    return true;
                }
            }
        }
        return true;
    }

    private boolean renameRecent(String id, String type, String name) {
        RepositoryObject repositoryObject = null;
        try {
            repositoryObject = this.getRepository().getObjectInformation(() -> id, type == TRANSFORMATION ? RepositoryObjectType.TRANSFORMATION : RepositoryObjectType.JOB);
        }
        catch (Exception e) {
            return false;
        }
        if (repositoryObject != null) {
            Collection lastUsedRepoFiles = PropsUI.getInstance().getLastUsedRepoFiles().values();
            for (List lastUsedFiles : lastUsedRepoFiles) {
                for (LastUsedFile lastUsedFile : lastUsedFiles) {
                    if (!lastUsedFile.getDirectory().equals(repositoryObject.getRepositoryDirectory().getPath()) || !lastUsedFile.getFilename().equals(repositoryObject.getName())) continue;
                    lastUsedFile.setFilename(name);
                    return true;
                }
            }
        }
        return true;
    }

    public boolean updateRecentFiles(String oldPath, String newPath) {
        try {
            Collection lastUsedRepoFiles = PropsUI.getInstance().getLastUsedRepoFiles().values();
            for (List lastUsedFiles : lastUsedRepoFiles) {
                for (int i = 0; i < lastUsedFiles.size(); ++i) {
                    if (!(((LastUsedFile)lastUsedFiles.get(i)).getDirectory() + "/").startsWith(oldPath + "/")) continue;
                    if (((LastUsedFile)lastUsedFiles.get(i)).getDirectory().length() == oldPath.length()) {
                        ((LastUsedFile)lastUsedFiles.get(i)).setDirectory(newPath);
                        continue;
                    }
                    String prefix = newPath.substring(0, newPath.lastIndexOf("/")) + "/";
                    String newFolder = newPath.substring(newPath.lastIndexOf("/") + 1);
                    String suffix = ((LastUsedFile)lastUsedFiles.get(i)).getDirectory().substring(oldPath.length());
                    ((LastUsedFile)lastUsedFiles.get(i)).setDirectory(prefix + newFolder + suffix);
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public RepositoryDirectory create(String parent, String name) {
        try {
            RepositoryDirectoryInterface repositoryDirectoryInterface = this.getRepository().createRepositoryDirectory(this.getRepository().findDirectory(parent), name);
            RepositoryDirectory repositoryDirectory = new RepositoryDirectory();
            repositoryDirectory.setName(repositoryDirectoryInterface.getName());
            repositoryDirectory.setPath(repositoryDirectoryInterface.getPath());
            repositoryDirectory.setObjectId(repositoryDirectoryInterface.getObjectId());
            repositoryDirectory.setParent(parent);
            return repositoryDirectory;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean saveFile(String path, String name) {
        boolean result = this.checkSecurity();
        if (result) {
            try {
                RepositoryDirectoryInterface repositoryDirectoryInterface = this.getRepository().findDirectory(path);
                this.getSpoon().getDisplay().asyncExec(() -> {
                    try {
                        EngineMetaInterface meta = this.getSpoon().getActiveMeta();
                        meta.setRepositoryDirectory(repositoryDirectoryInterface);
                        meta.setName(name);
                        this.getSpoon().saveToRepositoryConfirmed(meta);
                        this.getSpoon().delegates.tabs.renameTabs();
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                });
            }
            catch (Exception e) {
                return false;
            }
        }
        return result;
    }

    private boolean checkSecurity() {
        EngineMetaInterface meta = this.getSpoon().getActiveMeta();
        return this.getSpoon().saveToRepositoryCheckSecurity(meta);
    }

    public List<RepositoryDirectory> loadDirectoryTree() {
        return this.loadDirectoryTree("*.ktr|*.kjb");
    }

    public List<RepositoryDirectory> loadDirectoryTree(String filter) {
        if (this.getRepository() != null) {
            try {
                RepositoryDirectoryInterface repositoryDirectoryInterface = this.getRepository() instanceof RepositoryExtended ? ((RepositoryExtended)this.getRepository()).loadRepositoryDirectoryTree("/", filter, -1, BooleanUtils.isTrue((Boolean)this.getRepository().getUserInfo().isAdmin()), true, true) : this.getRepository().loadRepositoryDirectoryTree();
                LinkedList<RepositoryDirectory> repositoryDirectories = new LinkedList<RepositoryDirectory>();
                boolean isPentahoRepository = this.getRepository().getRepositoryMeta().getId().equals("PentahoEnterpriseRepository");
                int depth = isPentahoRepository ? -1 : 0;
                this.createRepositoryDirectory(repositoryDirectoryInterface, repositoryDirectories, depth, null, filter);
                if (isPentahoRepository) {
                    repositoryDirectories.remove(0);
                }
                return repositoryDirectories;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public List<RepositoryFile> loadFiles(String id) {
        try {
            List repositoryElementMetaInterfaces = this.getRepository().getJobAndTransformationObjects(() -> id, false);
            ArrayList<RepositoryFile> repositoryFiles = new ArrayList<RepositoryFile>();
            for (RepositoryObjectInterface repositoryObject : repositoryElementMetaInterfaces) {
                RepositoryObject ro = (RepositoryObject)repositoryObject;
                RepositoryFile repositoryFile = new RepositoryFile();
                repositoryFile.setObjectId(repositoryObject.getObjectId());
                repositoryFile.setName(repositoryObject.getName());
                repositoryFile.setType(ro.getObjectType().getTypeDescription());
                repositoryFile.setExtension(ro.getObjectType().getExtension());
                repositoryFile.setDate(ro.getModifiedDate());
                repositoryFile.setObjectId(ro.getObjectId());
                repositoryFile.setPath(ro.getRepositoryDirectory().getPath());
                repositoryFiles.add(repositoryFile);
            }
            return repositoryFiles;
        }
        catch (KettleException ke) {
            return Collections.emptyList();
        }
    }

    public List<RepositoryFile> getRecentFiles() {
        PropsUI props = PropsUI.getInstance();
        ArrayList<RepositoryFile> repositoryFiles = new ArrayList<RepositoryFile>();
        IUser userInfo = Spoon.getInstance().rep.getUserInfo();
        String repoAndUser = Spoon.getInstance().rep.getName() + ":" + (userInfo != null ? userInfo.getLogin() : "");
        List lastUsedFiles = props.getLastUsedRepoFiles().getOrDefault(repoAndUser, Collections.emptyList());
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -30);
        Date dateBefore = calendar.getTime();
        for (int i = 0; i < lastUsedFiles.size(); ++i) {
            LastUsedFile lastUsedFile = (LastUsedFile)lastUsedFiles.get(i);
            if (lastUsedFile.getLastOpened().before(dateBefore) || lastUsedFile.getRepositoryName() == null || !lastUsedFile.getRepositoryName().equals(Spoon.getInstance().rep.getName())) continue;
            RepositoryFile repositoryFile = new RepositoryFile();
            String index = String.valueOf(i);
            repositoryFile.setObjectId(() -> index);
            repositoryFile.setType(lastUsedFile.isTransformation() ? TRANSFORMATION : "job");
            repositoryFile.setName(lastUsedFile.getFilename());
            repositoryFile.setPath(lastUsedFile.getDirectory());
            repositoryFile.setDate(lastUsedFile.getLastOpened());
            repositoryFile.setRepository(lastUsedFile.getRepositoryName());
            repositoryFile.setUsername(lastUsedFile.getUsername());
            repositoryFiles.add(repositoryFile);
        }
        return repositoryFiles;
    }

    public void openRecentFile(String repo, String id) {
        this.getSpoon().getDisplay().asyncExec(() -> this.getSpoon().lastRepoFileSelect(repo, id));
    }

    private void createRepositoryDirectory(RepositoryDirectoryInterface repositoryDirectoryInterface, List<RepositoryDirectory> repositoryDirectories, int depth, RepositoryDirectory parent, String filter) {
        RepositoryDirectory repositoryDirectory = new RepositoryDirectory();
        repositoryDirectory.setName(repositoryDirectoryInterface.getName());
        repositoryDirectory.setPath(repositoryDirectoryInterface.getPath());
        repositoryDirectory.setObjectId(repositoryDirectoryInterface.getObjectId());
        repositoryDirectory.setDepth(depth);
        repositoryDirectories.add(repositoryDirectory);
        if (parent != null) {
            repositoryDirectory.setParent(parent.getPath());
            parent.addChild(repositoryDirectory);
        }
        if (!Utils.isEmpty((List)repositoryDirectoryInterface.getChildren())) {
            repositoryDirectory.setHasChildren(true);
            for (RepositoryDirectoryInterface child : repositoryDirectoryInterface.getChildren()) {
                this.createRepositoryDirectory(child, repositoryDirectories, depth + 1, repositoryDirectory, filter);
            }
        }
        List repositoryElementMetaInterfaces = new ArrayList();
        if (repositoryDirectoryInterface.getRepositoryObjects() == null) {
            try {
                repositoryElementMetaInterfaces = this.getRepository().getJobAndTransformationObjects(repositoryDirectoryInterface.getObjectId(), false);
            }
            catch (KettleException child) {}
        } else {
            repositoryElementMetaInterfaces = repositoryDirectoryInterface.getRepositoryObjects();
        }
        Date latestDate = null;
        for (RepositoryObjectInterface repositoryObject : repositoryElementMetaInterfaces) {
            RepositoryObject ro = (RepositoryObject)repositoryObject;
            String extension = ro.getObjectType().getExtension();
            if (!Util.isFiltered(extension, filter)) {
                RepositoryFile repositoryFile = new RepositoryFile();
                repositoryFile.setObjectId(repositoryObject.getObjectId());
                repositoryFile.setName(repositoryObject.getName());
                repositoryFile.setType(ro.getObjectType().getTypeDescription());
                repositoryFile.setExtension(extension);
                repositoryFile.setDate(ro.getModifiedDate());
                repositoryFile.setObjectId(ro.getObjectId());
                repositoryFile.setPath(ro.getRepositoryDirectory().getPath());
                repositoryDirectory.addChild(repositoryFile);
            }
            if (latestDate != null && !ro.getModifiedDate().after(latestDate)) continue;
            latestDate = ro.getModifiedDate();
        }
        repositoryDirectory.setDate(latestDate);
    }

    private Spoon getSpoon() {
        return this.spoonSupplier.get();
    }

    private Repository getRepository() {
        return this.getSpoon().rep;
    }

    public LinkedList<String> getRecentSearches() {
        LinkedList<String> recentSearches = new LinkedList<String>();
        try {
            PropsUI props = PropsUI.getInstance();
            String jsonValue = props.getRecentSearches();
            if (jsonValue != null) {
                JSONParser jsonParser = new JSONParser();
                JSONObject jsonObject = (JSONObject)jsonParser.parse(jsonValue);
                String login = "file_repository_no_login";
                if (Spoon.getInstance().rep.getUserInfo() != null) {
                    login = Spoon.getInstance().rep.getUserInfo().getLogin();
                }
                JSONArray jsonArray = (JSONArray)jsonObject.get((Object)login);
                CollectionUtils.addAll(recentSearches, (Object[])jsonArray.toArray());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return recentSearches;
    }

    public LinkedList<String> storeRecentSearch(String recentSearch) {
        LinkedList<String> recentSearches = this.getRecentSearches();
        try {
            if (recentSearch == null || recentSearches.contains(recentSearch)) {
                return recentSearches;
            }
            recentSearches.push(recentSearch);
            if (recentSearches.size() > 5) {
                recentSearches.pollLast();
            }
            JSONArray jsonArray = new JSONArray();
            CollectionUtils.addAll((Collection)jsonArray, (Object[])recentSearches.toArray());
            PropsUI props = PropsUI.getInstance();
            String jsonValue = props.getRecentSearches();
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObject = jsonValue != null ? (JSONObject)jsonParser.parse(jsonValue) : new JSONObject();
            String login = "file_repository_no_login";
            if (Spoon.getInstance().rep.getUserInfo() != null) {
                login = Spoon.getInstance().rep.getUserInfo().getLogin();
            }
            jsonObject.put((Object)login, (Object)jsonArray);
            props.setRecentSearches(jsonObject.toJSONString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return recentSearches;
    }
}

