/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.repo.dialog;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.ui.core.dialog.ThinDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.platform.settings.ServerPort;
import org.pentaho.platform.settings.ServerPortRegistry;

public class RepositoryOpenSaveDialog
extends ThinDialog {
    public static final String STATE_SAVE = "save";
    public static final String STATE_OPEN = "open";
    private static final Image LOGO = GUIResource.getInstance().getImageLogoSmall();
    private static final String OSGI_SERVICE_PORT = "OSGI_SERVICE_PORT";
    private static final String CLIENT_PATH = "/file-open-save-core/8.0.0.0-28/index.html";
    private static final int OPTIONS = 68720;
    private static final String THIN_CLIENT_HOST = "THIN_CLIENT_HOST";
    private static final String THIN_CLIENT_PORT = "THIN_CLIENT_PORT";
    private static final String LOCALHOST = "localhost";
    private String objectId;
    private String objectName;
    private String objectDirectory;
    private String objectType;

    public RepositoryOpenSaveDialog(Shell shell, int width, int height) {
        super(shell, width, height);
    }

    public void open(String directory, String state, String filter, String origin) {
        StringBuilder clientPath = new StringBuilder();
        clientPath.append(CLIENT_PATH);
        clientPath.append(!Utils.isEmpty((CharSequence)directory) ? "#?path=" + directory : "#?");
        clientPath.append(!Utils.isEmpty((CharSequence)directory) ? "&" : "");
        clientPath.append(!Utils.isEmpty((CharSequence)state) ? "state=" + state : "");
        clientPath.append(!Utils.isEmpty((CharSequence)state) ? "&" : "");
        clientPath.append(!Utils.isEmpty((CharSequence)filter) ? "filter=" + filter : "");
        clientPath.append(!Utils.isEmpty((CharSequence)filter) ? "&" : "");
        clientPath.append(!Utils.isEmpty((CharSequence)origin) ? "origin=" + origin : "");
        super.createDialog(StringUtils.capitalize((String)state), RepositoryOpenSaveDialog.getRepoURL(clientPath.toString()), 68720, LOGO);
        this.dialog.setMinimumSize(545, 458);
        new BrowserFunction(this.browser, "close"){

            public Object function(Object[] arguments) {
                RepositoryOpenSaveDialog.this.browser.dispose();
                RepositoryOpenSaveDialog.this.dialog.close();
                RepositoryOpenSaveDialog.this.dialog.dispose();
                return true;
            }
        };
        new BrowserFunction(this.browser, "select"){

            public Object function(Object[] arguments) {
                RepositoryOpenSaveDialog.this.objectId = (String)arguments[0];
                RepositoryOpenSaveDialog.this.objectName = (String)arguments[1];
                RepositoryOpenSaveDialog.this.objectDirectory = (String)arguments[2];
                RepositoryOpenSaveDialog.this.objectType = (String)arguments[3];
                RepositoryOpenSaveDialog.this.browser.dispose();
                RepositoryOpenSaveDialog.this.dialog.close();
                RepositoryOpenSaveDialog.this.dialog.dispose();
                return true;
            }
        };
        while (!this.dialog.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private static Integer getOsgiServicePort() {
        ServerPort osgiServicePort = ServerPortRegistry.getPort((String)OSGI_SERVICE_PORT);
        if (osgiServicePort != null) {
            return osgiServicePort.getAssignedPort();
        }
        return null;
    }

    private static String getRepoURL(String path) {
        Integer port;
        String host;
        try {
            host = RepositoryOpenSaveDialog.getKettleProperty(THIN_CLIENT_HOST);
            port = Integer.valueOf(RepositoryOpenSaveDialog.getKettleProperty(THIN_CLIENT_PORT));
        }
        catch (Exception e) {
            host = LOCALHOST;
            port = RepositoryOpenSaveDialog.getOsgiServicePort();
        }
        return "http://" + host + ":" + port + path;
    }

    private static String getKettleProperty(String propertyName) throws KettleException {
        return System.getProperty(propertyName);
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String transName) {
        this.objectName = this.objectName;
    }

    public String getObjectDirectory() {
        return this.objectDirectory;
    }

    public void setObjectDirectory(String objectDirectory) {
        this.objectDirectory = objectDirectory;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }
}

