/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.repo.endpoint;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleJobException;
import org.pentaho.di.core.exception.KettleObjectExistsException;
import org.pentaho.di.core.exception.KettleTransException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.repo.controller.RepositoryBrowserController;
import org.pentaho.repo.model.RepositoryDirectory;

public class RepositoryBrowserEndpoint {
    private RepositoryBrowserController repositoryBrowserController;

    public RepositoryBrowserEndpoint(RepositoryBrowserController repositoryBrowserController) {
        this.repositoryBrowserController = repositoryBrowserController;
    }

    @GET
    @Path(value="/loadDirectoryTree{filter : (/filter)?}")
    @Produces(value={"application/json"})
    public Response loadDirectoryTree(@PathParam(value="filter") String filter) {
        List<RepositoryDirectory> repositoryDirectories;
        List<RepositoryDirectory> list = repositoryDirectories = Utils.isEmpty((CharSequence)filter) ? this.repositoryBrowserController.loadDirectoryTree() : this.repositoryBrowserController.loadDirectoryTree(filter);
        if (repositoryDirectories != null) {
            return Response.ok(repositoryDirectories).build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/loadFile/{id}/{type}")
    public Response loadFile(@PathParam(value="id") String id, @PathParam(value="type") String type) {
        if (this.repositoryBrowserController.loadFile(id, type)) {
            return Response.ok().build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/loadFiles/{id}")
    public Response loadFile(@PathParam(value="id") String id) {
        return Response.ok(this.repositoryBrowserController.loadFiles(id)).build();
    }

    @GET
    @Path(value="/getActiveFileName")
    public Response getActiveFileName() {
        String name = this.repositoryBrowserController.getActiveFileName();
        return Response.ok(Collections.singletonMap("fileName", name)).build();
    }

    @GET
    @Path(value="/loadRecent/{repo}/{id}")
    public Response loadRecent(@PathParam(value="repo") String repo, @PathParam(value="id") String id) {
        this.repositoryBrowserController.openRecentFile(repo, id);
        return Response.ok().build();
    }

    @GET
    @Path(value="/saveFile/{path}/{name}")
    public Response saveFile(@PathParam(value="path") String path, @PathParam(value="name") String name) {
        if (this.repositoryBrowserController.saveFile(path, name)) {
            return Response.ok().build();
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="/rename/{id}/{path}/{newName}/{type}/{oldName}")
    public Response rename(@PathParam(value="id") String id, @PathParam(value="path") String path, @PathParam(value="newName") String newName, @PathParam(value="type") String type, @PathParam(value="oldName") String oldName) {
        try {
            ObjectId objectId = this.repositoryBrowserController.rename(id, path, newName, type, oldName);
            if (objectId != null) {
                return Response.ok((Object)objectId).build();
            }
        }
        catch (KettleObjectExistsException koee) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (KettleJobException | KettleTransException ktje) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        catch (KettleException ke) {
            return Response.notModified().build();
        }
        return Response.notModified().build();
    }

    @POST
    @Path(value="/create/{parent}/{name}")
    @Produces(value={"application/json"})
    public Response rename(@PathParam(value="parent") String parent, @PathParam(value="name") String name) {
        RepositoryDirectory repositoryDirectory = this.repositoryBrowserController.create(parent, name);
        if (repositoryDirectory != null) {
            return Response.ok((Object)repositoryDirectory).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @DELETE
    @Path(value="/remove/{id}/{name}/{path}/{type}")
    public Response delete(@PathParam(value="id") String id, @PathParam(value="name") String name, @PathParam(value="path") String path, @PathParam(value="type") String type) {
        try {
            if (this.repositoryBrowserController.remove(id, name, path, type)) {
                return Response.ok().build();
            }
        }
        catch (KettleException ke) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
    }

    @GET
    @Path(value="/recentFiles")
    @Produces(value={"application/json"})
    public Response recentFiles() {
        return Response.ok(this.repositoryBrowserController.getRecentFiles()).build();
    }

    @GET
    @Path(value="/updateRecentFiles/{oldPath}/{newPath}")
    @Produces(value={"application/json"})
    public Response updateRecentFiles(@PathParam(value="oldPath") String oldPath, @PathParam(value="newPath") String newPath) {
        return Response.ok((Object)this.repositoryBrowserController.updateRecentFiles(oldPath, newPath)).build();
    }

    @GET
    @Path(value="/recentSearches")
    @Produces(value={"application/json"})
    public Response recentSearches() {
        return Response.ok(this.repositoryBrowserController.getRecentSearches()).build();
    }

    @GET
    @Path(value="/storeRecentSearch/{recentSearch}")
    @Produces(value={"application/json"})
    public Response storeRecentSearch(@PathParam(value="recentSearch") String recentSearch) {
        return Response.ok(this.repositoryBrowserController.storeRecentSearch(recentSearch)).build();
    }
}

