/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.repo.extension;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import org.pentaho.di.core.LastUsedFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.ui.core.FileDialogOperation;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.repo.dialog.RepositoryOpenSaveDialog;

@ExtensionPoint(id="RepositoryOpenSaveExtensionPoint", extensionPointId="SpoonOpenSaveRepository", description="Open the repository browser")
public class RepositoryOpenSaveExtensionPoint
implements ExtensionPointInterface {
    public static final String TRANSFORMATION = "transformation";
    public static final int WIDTH = 947;
    public static final int HEIGHT = 626;
    public static final int DAYS = -30;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private Supplier<PropsUI> propsUISupplier = PropsUI::getInstance;

    public void callExtensionPoint(LogChannelInterface logChannelInterface, Object o) throws KettleException {
        FileDialogOperation fileDialogOperation = (FileDialogOperation)o;
        PropsUI propsUI = this.propsUISupplier.get();
        String username = this.getRepository().getUserInfo() != null ? this.getRepository().getUserInfo().getLogin() : "";
        String repoAndUser = this.getRepository().getName() + ":" + username;
        List<LastUsedFile> lastUsedFileList = propsUI.getLastUsedRepoFiles().getOrDefault(repoAndUser, Collections.emptyList());
        String startingDir = this.getStartingDir(fileDialogOperation, lastUsedFileList);
        RepositoryOpenSaveDialog repositoryOpenSaveDialog = new RepositoryOpenSaveDialog(this.spoonSupplier.get().getShell(), 947, 626);
        repositoryOpenSaveDialog.open(startingDir, "save".equals(fileDialogOperation.getCommand()) ? "save" : "open", fileDialogOperation.getFilter(), fileDialogOperation.getOrigin());
        if (!Utils.isEmpty((CharSequence)repositoryOpenSaveDialog.getObjectName())) {
            RepositoryObject repositoryObject = new RepositoryObject();
            repositoryObject.setObjectId(repositoryOpenSaveDialog::getObjectId);
            repositoryObject.setName(repositoryOpenSaveDialog.getObjectName());
            repositoryObject.setRepositoryDirectory(this.getRepository().findDirectory(repositoryOpenSaveDialog.getObjectDirectory()));
            repositoryObject.setObjectType(repositoryOpenSaveDialog.getObjectType().equals(TRANSFORMATION) ? RepositoryObjectType.TRANSFORMATION : RepositoryObjectType.JOB);
            fileDialogOperation.setRepositoryObject(repositoryObject);
        }
    }

    private String getStartingDir(FileDialogOperation fileDialogOperation, List<LastUsedFile> lastUsedFileList) {
        String startingDir = fileDialogOperation.getStartDir();
        if (!Utils.isEmpty((CharSequence)startingDir)) {
            return startingDir;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -30);
        Date dateBefore = calendar.getTime();
        LastUsedFile lastUsedFile = null;
        if (lastUsedFileList.size() > 0 && lastUsedFileList.get(0).getLastOpened().after(dateBefore)) {
            lastUsedFile = lastUsedFileList.get(0);
        }
        return lastUsedFile != null ? lastUsedFile.getDirectory() : null;
    }

    private Repository getRepository() {
        return this.spoonSupplier.get().getRepository();
    }
}

