/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.propforms;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.format.DataFormatHolder;
import org.pentaho.agilebi.modeler.nodes.BaseAggregationMetaDataNode;
import org.pentaho.agilebi.modeler.propforms.AbstractModelerNodeForm;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.stereotype.Bindable;

public class MeasuresPropertiesForm
extends AbstractModelerNodeForm<BaseAggregationMetaDataNode> {
    private static final long serialVersionUID = -8703255300288774342L;
    protected Vector aggTypes;
    private String colName;
    private String locale;
    protected AggregationType defaultAggregation;
    protected String format;
    protected List<String> formatstring;
    private XulButton messageBtn;
    private PropertyChangeListener propListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("logicalColumn")) {
                MeasuresPropertiesForm.this.setColumnName(((BaseAggregationMetaDataNode)MeasuresPropertiesForm.this.getNode()).getLogicalColumn());
            } else if (evt.getPropertyName().equals("possibleAggregations")) {
                MeasuresPropertiesForm.this.setPossibleAggregations(new Vector<AggregationType>(((BaseAggregationMetaDataNode)MeasuresPropertiesForm.this.getNode()).getPossibleAggregations()));
            } else if (evt.getPropertyName().equals("defaultAggregation")) {
                MeasuresPropertiesForm.this.setDefaultAggregation(((BaseAggregationMetaDataNode)MeasuresPropertiesForm.this.getNode()).getDefaultAggregation());
            } else if (evt.getPropertyName().equals("format")) {
                MeasuresPropertiesForm.this.setFormat(((BaseAggregationMetaDataNode)MeasuresPropertiesForm.this.getNode()).getFormat());
            } else if (evt.getPropertyName().equals("formatList")) {
                MeasuresPropertiesForm.this.setFormatstring(((BaseAggregationMetaDataNode)MeasuresPropertiesForm.this.getNode()).getFormatstring());
            }
        }
    };
    private PropertyChangeListener validListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals("valid")) {
                return;
            }
            MeasuresPropertiesForm.this.showValidations();
        }
    };

    public MeasuresPropertiesForm(String panelId, String locale) {
        super(panelId);
        this.locale = locale;
    }

    public MeasuresPropertiesForm(String locale) {
        this("measuresprops", locale);
    }

    @Override
    @Bindable
    public void init(ModelerWorkspace workspace) {
        super.init(workspace);
        XulMenuList formatXulMenuList = (XulMenuList)this.document.getElementById("formatstring");
        this.bf.createBinding((Object)this, "notValid", "messages2", "visible", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "validMessages", "messages2label", "value", new BindingConvertor[]{validMsgTruncatedBinding});
        this.bf.createBinding((Object)this, "displayName", "displayname", "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "possibleAggregations", "defaultAggregation", "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "defaultAggregation", "defaultAggregation", "selectedItem", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "format", (Object)formatXulMenuList, "value", new BindingConvertor[]{new FormatStringConverter()});
        this.bf.createBinding((Object)this, "formatstring", (Object)formatXulMenuList, "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "backingColumnAvailable", "fixMeasuresColumnsBtn", "!visible", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "columnName", "measure_column_name", "value", new BindingConvertor[0]);
        this.messageBtn = (XulButton)this.document.getElementById("measure_message_btn");
        this.bf.createBinding((Object)this, "validMessages", (Object)this.messageBtn, "visible", new BindingConvertor[]{showMsgBinding});
    }

    private void showValidations() {
        this.setNotValid(!((BaseAggregationMetaDataNode)this.getNode()).isValid());
        this.setBackingColumnAvailable(((BaseAggregationMetaDataNode)this.getNode()).getLogicalColumn() != null);
        this.setValidMessages(((BaseAggregationMetaDataNode)this.getNode()).getValidationMessagesString());
    }

    @Override
    public void setObject(BaseAggregationMetaDataNode t) {
        if (this.getNode() != null) {
            ((BaseAggregationMetaDataNode)this.getNode()).removePropertyChangeListener(this.validListener);
            ((BaseAggregationMetaDataNode)this.getNode()).removePropertyChangeListener(this.propListener);
            this.setNode(null);
        }
        if (t == null) {
            return;
        }
        t.addPropertyChangeListener(this.validListener);
        t.addPropertyChangeListener(this.propListener);
        if (null != t.getLogicalColumn()) {
            switch (t.getLogicalColumn().getDataType()) {
                case DATE: {
                    this.setFormatstring(DataFormatHolder.DATE_FORMATS);
                    break;
                }
                case NUMERIC: {
                    this.setFormatstring(DataFormatHolder.NUMBER_FORMATS);
                    break;
                }
                case STRING: {
                    this.setFormatstring(DataFormatHolder.CONVERSION_FORMATS);
                    break;
                }
            }
        }
        this.setDisplayName(t.getName());
        this.setFormat(t.getFormat() != null && t.getFormat().length() > 0 ? t.getFormat() : "#");
        AggregationType aggType = t.getDefaultAggregation();
        if (t.getPossibleAggregations() != null) {
            this.setPossibleAggregations(new Vector<AggregationType>(t.getPossibleAggregations()));
        }
        this.setValidMessages(t.getValidationMessagesString());
        this.setColumnName(t.getLogicalColumn());
        this.setNode(t);
        this.showValidations();
        this.setDefaultAggregation(aggType);
    }

    @Bindable
    public void setColumnName(LogicalColumn col) {
        String prevName = this.colName;
        this.colName = col != null && col.getPhysicalColumn() != null ? col.getPhysicalColumn().getName(this.locale) : "";
        this.firePropertyChange("columnName", prevName, this.colName);
    }

    @Bindable
    public String getColumnName() {
        return this.colName;
    }

    @Bindable
    public boolean isNotValid() {
        if (this.getNode() != null) {
            return !((BaseAggregationMetaDataNode)this.getNode()).isValid();
        }
        return false;
    }

    @Bindable
    public void setNotValid(boolean notValid) {
        this.firePropertyChange("notValid", null, notValid);
    }

    @Bindable
    public boolean isBackingColumnAvailable() {
        if (this.getNode() != null) {
            return ((BaseAggregationMetaDataNode)this.getNode()).getLogicalColumn() != null;
        }
        return false;
    }

    @Bindable
    public void setBackingColumnAvailable(boolean available) {
        this.firePropertyChange("backingColumnAvailable", null, available);
    }

    public String getName() {
        return "propertiesForm";
    }

    @Bindable
    public String getDisplayName() {
        if (this.getNode() == null) {
            return null;
        }
        return ((BaseAggregationMetaDataNode)this.getNode()).getName();
    }

    @Bindable
    public void setDisplayName(String displayName) {
        if (this.getNode() != null) {
            ((BaseAggregationMetaDataNode)this.getNode()).setName(displayName);
        }
        this.firePropertyChange("displayName", null, displayName);
    }

    @Bindable
    public String getFormat() {
        return this.format;
    }

    @Bindable
    public void setFormat(String format) {
        String previousFormat = this.format;
        this.format = format;
        if (this.getNode() != null) {
            ((BaseAggregationMetaDataNode)this.getNode()).setFormat(format);
        }
        this.firePropertyChange("format", previousFormat, format);
    }

    @Bindable
    public Vector getPossibleAggregations() {
        return this.aggTypes;
    }

    @Bindable
    public void setPossibleAggregations(Vector aggTypes) {
        Vector previous = this.aggTypes;
        this.aggTypes = aggTypes;
        this.firePropertyChange("possibleAggregations", previous, aggTypes);
    }

    @Bindable
    public AggregationType getDefaultAggregation() {
        return this.defaultAggregation;
    }

    @Bindable
    public void setDefaultAggregation(AggregationType defaultAggregation) {
        AggregationType previousAggregation = this.defaultAggregation;
        if (previousAggregation == null && defaultAggregation == null) {
            return;
        }
        if (previousAggregation != null && defaultAggregation != null && previousAggregation.equals((Object)defaultAggregation)) {
            return;
        }
        this.defaultAggregation = defaultAggregation;
        this.firePropertyChange("defaultAggregation", previousAggregation, defaultAggregation);
        if (this.getNode() != null) {
            ((BaseAggregationMetaDataNode)this.getNode()).setDefaultAggregation(defaultAggregation);
        }
    }

    @Bindable
    public List<String> getFormatstring() {
        return this.formatstring;
    }

    @Bindable
    public void setFormatstring(List<String> formatList) {
        List<String> previousXulMenuList = this.formatstring;
        this.formatstring = formatList;
        this.firePropertyChange("formatstring", previousXulMenuList, this.formatstring);
        if (this.getNode() != null) {
            ((BaseAggregationMetaDataNode)this.getNode()).setFormatstring(formatList);
        }
    }

    @Override
    public String getValidMessages() {
        if (this.getNode() != null) {
            return ((BaseAggregationMetaDataNode)this.getNode()).getValidationMessagesString();
        }
        return null;
    }

    private static class FormatStringConverter
    extends BindingConvertor<String, String> {
        private FormatStringConverter() {
        }

        public String sourceToTarget(String value) {
            if (value == null) {
                return "NONE";
            }
            return value;
        }

        public String targetToSource(String value) {
            if (value.equalsIgnoreCase("NONE")) {
                return null;
            }
            return value;
        }
    }
}

