/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.MetaStoreSchemaInfo;
import org.apache.hadoop.hive.metastore.tools.HiveSchemaHelper;
import org.apache.hive.common.util.HiveVersionInfo;

public class CDHMetaStoreSchemaInfo
extends MetaStoreSchemaInfo {
    private static String CDH_VERSION_UPGRADE_LIST = "cdh.upgrade.order";
    private static final Log LOG = LogFactory.getLog((String)CDHMetaStoreSchemaInfo.class.getName());

    @VisibleForTesting
    Collection<CDHVersion> getCDHVersionsWithSchemaChanges() throws HiveMetaException {
        String[] cdhUpgradeScriptNames = this.loadAllCDHUpgradeScripts(this.dbType);
        TreeSet<CDHVersion> cdhVersionsWithSchemaChanges = new TreeSet<CDHVersion>();
        for (String cdhUpgradeScriptName : cdhUpgradeScriptNames) {
            String toVersionFromUpgradePath = cdhUpgradeScriptName.split("-to-")[1];
            LOG.debug((Object)("Adding " + toVersionFromUpgradePath + " to cdh versions with schema changes"));
            cdhVersionsWithSchemaChanges.add(new CDHVersion(toVersionFromUpgradePath));
        }
        return cdhVersionsWithSchemaChanges;
    }

    public CDHMetaStoreSchemaInfo(String hiveHome, String dbType) throws HiveMetaException {
        super(hiveHome, dbType);
    }

    @VisibleForTesting
    String[] loadAllCDHUpgradeScripts(String dbType) throws HiveMetaException {
        ArrayList<String> cdhUpgradeOrderList = new ArrayList<String>();
        String upgradeListFile = this.getMetaStoreScriptDir() + File.separator + CDH_VERSION_UPGRADE_LIST + "." + dbType;
        if (new File(upgradeListFile).exists()) {
            try (BufferedReader bfReader = new BufferedReader(new FileReader(upgradeListFile));){
                String line;
                while ((line = bfReader.readLine()) != null) {
                    cdhUpgradeOrderList.add(line.trim());
                }
            }
            catch (IOException e) {
                throw new HiveMetaException("Error reading " + upgradeListFile, e);
            }
        }
        return cdhUpgradeOrderList.toArray(new String[cdhUpgradeOrderList.size()]);
    }

    @Override
    public List<String> getUpgradeScripts(String fromVersion) throws HiveMetaException {
        ArrayList<String> upgradeScriptList = new ArrayList();
        try {
            upgradeScriptList = super.getUpgradeScripts(fromVersion);
        }
        catch (HiveMetaException ex) {
            // empty catch block
        }
        List<String> cdhScriptList = this.getCDHSchemaUpgrades(fromVersion);
        if (cdhScriptList.size() > 0) {
            upgradeScriptList.addAll(cdhScriptList);
        }
        return upgradeScriptList;
    }

    @Override
    public String generateInitFileName(String toVersion) throws HiveMetaException {
        if (toVersion == null) {
            toVersion = this.getHiveSchemaVersion();
        }
        toVersion = this.getMajorVersion(toVersion);
        return super.generateInitFileName(toVersion);
    }

    private String generateUpgradeFileName(String fileVersion) {
        return "upgrade-" + fileVersion + "." + this.dbType + ".sql";
    }

    private String getMajorVersion(String fullVersion) {
        return fullVersion.split("-")[0];
    }

    @Override
    public String getHiveSchemaVersion() {
        return HiveVersionInfo.getVersion().replaceAll("-SNAPSHOT", "");
    }

    private List<String> getCDHSchemaUpgrades(String from) throws HiveMetaException {
        ArrayList<String> minorUpgradeList = new ArrayList<String>();
        String cdhVersion = this.getHiveSchemaVersion();
        if (cdhVersion.equals(from)) {
            return minorUpgradeList;
        }
        CDHVersion currentCdhVersion = new CDHVersion(cdhVersion);
        String[] cdhSchemaVersions = this.loadAllCDHUpgradeScripts(this.dbType);
        CDHVersion fromCdhVersion = null;
        if (from.indexOf(45) != -1) {
            fromCdhVersion = new CDHVersion(from);
        }
        for (int i = 0; i < cdhSchemaVersions.length; ++i) {
            CDHVersion toVersionFromUpgradePath = new CDHVersion(cdhSchemaVersions[i].split("-to-")[1]);
            if (fromCdhVersion != null && fromCdhVersion.compareTo(toVersionFromUpgradePath) >= 0) {
                LOG.info((Object)("Current version is higher than or equal to " + toVersionFromUpgradePath + " Skipping file " + cdhSchemaVersions[i]));
                continue;
            }
            if (toVersionFromUpgradePath.compareTo(currentCdhVersion) <= 0) {
                String scriptFile = this.generateUpgradeFileName(cdhSchemaVersions[i]);
                minorUpgradeList.add(scriptFile);
                continue;
            }
            LOG.info((Object)("Upgrade script version is newer than current hive version, skipping file " + cdhSchemaVersions[i]));
        }
        return minorUpgradeList;
    }

    @Override
    public boolean isVersionCompatible(String cdhHiveVersion, String dbVersion) {
        boolean isCompatible = super.isVersionCompatible(this.getMajorVersion(cdhHiveVersion), this.getMajorVersion(dbVersion));
        if (!isCompatible) {
            return isCompatible;
        }
        LOG.debug((Object)"Upstream versions are compatible, comparing downstream");
        String[] cdhFullVersion = cdhHiveVersion.split("-");
        String[] hmsFullVersion = dbVersion.split("-");
        if (cdhFullVersion.length != hmsFullVersion.length) {
            return false;
        }
        if (cdhFullVersion.length < 2) {
            throw new RuntimeException("Invalid CDH version string " + cdhHiveVersion + ". The version string should be of the format <hiveversion>-<cdhversion>");
        }
        return this.isCDHVersionCompatible(new CDHVersion(cdhHiveVersion), new CDHVersion(dbVersion));
    }

    private boolean isCDHVersionCompatible(CDHVersion cdhVersion, CDHVersion dbVersion) {
        Collection<CDHVersion> cdhVersionsWithSchemaChanges;
        if (cdhVersion.equals(dbVersion)) {
            return true;
        }
        CDHVersion minRequiredSchemaVersion = null;
        try {
            cdhVersionsWithSchemaChanges = this.getCDHVersionsWithSchemaChanges();
        }
        catch (HiveMetaException e) {
            LOG.error((Object)"Unable to load the cdh versions with schema changes ", (Throwable)e);
            throw new RuntimeException(e);
        }
        for (CDHVersion currentCheckPoint : cdhVersionsWithSchemaChanges) {
            if (currentCheckPoint.compareTo(cdhVersion) > 0) continue;
            minRequiredSchemaVersion = currentCheckPoint;
        }
        if (minRequiredSchemaVersion != null) {
            return dbVersion.compareTo(minRequiredSchemaVersion) >= 0;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getMetaStoreSchemaVersion(HiveSchemaHelper.MetaStoreConnectionInfo connectionInfo) throws HiveMetaException {
        boolean needsQuotedIdentifier = HiveSchemaHelper.getDbCommandParser(connectionInfo.getDbType()).needsQuotedIdentifier();
        String versionQuery = needsQuotedIdentifier ? "select * from \"VERSION\" t" : "select * from VERSION t";
        try (Connection metastoreDbConnection = HiveSchemaHelper.getConnectionToMetastore(connectionInfo);){
            Statement stmt = metastoreDbConnection.createStatement();
            ResultSet res = stmt.executeQuery(versionQuery);
            if (!res.next()) {
                throw new HiveMetaException("Could not find version info in metastore VERSION table.");
            }
            String version = this.getSchemaVersion(res);
            if (res.next()) {
                throw new HiveMetaException("Multiple versions were found in metastore.");
            }
            String string = version;
            return string;
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to get schema version, Cause:" + e.getMessage());
        }
    }

    private String getSchemaVersion(ResultSet res) throws SQLException {
        String version = this.getColumnValue(res, "SCHEMA_VERSION_V2");
        if (version == null) {
            version = this.getColumnValue(res, "SCHEMA_VERSION");
        }
        return version;
    }

    private String getColumnValue(ResultSet res, String columnName) throws SQLException {
        if (res.getMetaData() == null) {
            throw new IllegalArgumentException("ResultSet metadata cannot be null");
        }
        int numCols = res.getMetaData().getColumnCount();
        for (int i = 1; i <= numCols; ++i) {
            if (!columnName.equalsIgnoreCase(res.getMetaData().getColumnName(i))) continue;
            return res.getString(i);
        }
        return null;
    }

    @VisibleForTesting
    static class CDHVersion
    implements Comparable<CDHVersion> {
        private final String version;
        private final boolean skipMaintainenceRelease;

        private String getCdhVersionString() {
            String[] parts = this.version.split("-");
            if (parts.length > 1) {
                return parts[1].replaceAll("cdh", "");
            }
            throw new IllegalArgumentException("Invalid format of cdh version string " + this.version);
        }

        public CDHVersion(String versionStr) {
            this(versionStr, false);
        }

        public String toString() {
            return this.version;
        }

        public CDHVersion(String versionStr, boolean skipMaintainenceRelease) {
            if (versionStr == null) {
                throw new IllegalArgumentException("Version cannot be null");
            }
            this.version = versionStr.toLowerCase();
            this.skipMaintainenceRelease = skipMaintainenceRelease;
        }

        @Override
        public int compareTo(CDHVersion other) {
            LOG.debug((Object)("Comparing " + this + " with " + other));
            String cdhVersion1 = this.getCdhVersionString();
            String cdhVersion2 = other.getCdhVersionString();
            String[] aVersionParts = cdhVersion1.split("\\.");
            String[] bVersionParts = cdhVersion2.split("\\.");
            if (aVersionParts.length != bVersionParts.length) {
                throw new IllegalArgumentException("Cannot compare Version strings " + cdhVersion1 + " and " + cdhVersion2 + " since follow different format");
            }
            for (int i = 0; i < aVersionParts.length; ++i) {
                Integer aVersionPart = Integer.valueOf(aVersionParts[i]);
                Integer bVersionPart = Integer.valueOf(bVersionParts[i]);
                if (this.skipMaintainenceRelease && i == aVersionParts.length - 1) continue;
                if (aVersionPart > bVersionPart) {
                    LOG.debug((Object)("Version " + aVersionPart + " is higher than " + bVersionPart));
                    return 1;
                }
                if (aVersionPart >= bVersionPart) continue;
                LOG.debug((Object)("Version " + aVersionPart + " is lower than " + bVersionPart));
                return -1;
            }
            return 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CDHVersion other = (CDHVersion)obj;
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }
}

