/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.aries.rsa.core.ClientServiceFactory;
import org.apache.aries.rsa.core.RemoteServiceAdminCore;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportRegistrationImpl
implements ImportRegistration,
ImportReference {
    private static final Logger LOG = LoggerFactory.getLogger(ImportRegistrationImpl.class);
    private volatile Throwable exception;
    private volatile ServiceRegistration importedService;
    private EndpointDescription endpoint;
    private volatile ClientServiceFactory clientServiceFactory;
    private RemoteServiceAdminCore rsaCore;
    private boolean closed;
    private boolean detached;
    private ImportRegistrationImpl parent;
    private List<ImportRegistrationImpl> children;

    public ImportRegistrationImpl(Throwable ex) {
        this.exception = ex;
        this.initParent();
    }

    public ImportRegistrationImpl(EndpointDescription endpoint, RemoteServiceAdminCore rsac) {
        this.endpoint = endpoint;
        this.rsaCore = rsac;
        this.initParent();
    }

    public ImportRegistrationImpl(ImportRegistrationImpl ir) {
        this.parent = ir.getParent();
        this.exception = this.parent.getException();
        this.endpoint = this.parent.getImportedEndpointDescription();
        this.clientServiceFactory = this.parent.clientServiceFactory;
        this.rsaCore = this.parent.rsaCore;
        this.parent.instanceAdded(this);
    }

    private void initParent() {
        this.parent = this;
        this.children = new ArrayList<ImportRegistrationImpl>(1);
    }

    private void ensureParent() {
        if (this.parent != this) {
            throw new IllegalStateException("this method may only be called on the parent");
        }
    }

    private synchronized void instanceAdded(ImportRegistrationImpl iri) {
        this.ensureParent();
        this.children.add(iri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instanceClosed(ImportRegistrationImpl iri) {
        this.ensureParent();
        ImportRegistrationImpl importRegistrationImpl = this;
        synchronized (importRegistrationImpl) {
            this.children.remove(iri);
            if (!this.children.isEmpty() || this.detached || !this.closed) {
                return;
            }
            this.detached = true;
        }
        LOG.debug("really closing ImportRegistration now");
        if (this.importedService != null) {
            try {
                this.importedService.unregister();
            }
            catch (IllegalStateException ise) {
                LOG.debug("imported service is already unregistered");
            }
            this.importedService = null;
        }
        if (this.clientServiceFactory != null) {
            this.clientServiceFactory.setCloseable(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LOG.debug("close() called");
        ImportRegistrationImpl importRegistrationImpl = this;
        synchronized (importRegistrationImpl) {
            if (this.isInvalid()) {
                return;
            }
            this.closed = true;
        }
        this.rsaCore.removeImportRegistration(this);
        this.parent.instanceClosed(this);
    }

    public void closeAll() {
        if (this == this.parent) {
            LOG.info("closing down all child ImportRegistrations");
            for (ImportRegistrationImpl ir : this.copyChildren()) {
                ir.close();
            }
            this.close();
        } else {
            this.parent.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportRegistrationImpl> copyChildren() {
        ImportRegistrationImpl importRegistrationImpl = this;
        synchronized (importRegistrationImpl) {
            return new ArrayList<ImportRegistrationImpl>(this.children);
        }
    }

    public EndpointDescription getImportedEndpointDescription() {
        return this.isInvalid() ? null : this.endpoint;
    }

    @Override
    public EndpointDescription getImportedEndpoint() {
        return this.getImportedEndpointDescription();
    }

    @Override
    public ServiceReference getImportedService() {
        return this.isInvalid() || this.parent.importedService == null ? null : this.parent.importedService.getReference();
    }

    @Override
    public ImportReference getImportReference() {
        return this;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable ex) {
        this.exception = ex;
    }

    private synchronized boolean isInvalid() {
        return this.exception != null || this.closed;
    }

    public void setImportedServiceRegistration(ServiceRegistration sreg) {
        this.ensureParent();
        this.importedService = sreg;
    }

    public void setClientServiceFactory(ClientServiceFactory csf) {
        this.ensureParent();
        this.clientServiceFactory = csf;
    }

    public ImportRegistrationImpl getParent() {
        return this.parent;
    }

    public EndpointDescription getImportedEndpointAlways() {
        return this.endpoint;
    }
}

