/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.api.format;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SchemaDescription
implements Iterable<Field> {
    private final List<Field> fields = new ArrayList<Field>();

    public void addField(Field field) {
        this.fields.add(field);
    }

    public String marshall() {
        StringBuilder o = new StringBuilder(2048);
        for (Field f : this.fields) {
            o.append(f.marshall()).append('\n');
        }
        return o.toString();
    }

    public static SchemaDescription unmarshall(String str) {
        String[] lines;
        SchemaDescription r = new SchemaDescription();
        if (str.isEmpty()) {
            return r;
        }
        for (String line : lines = str.split("\n")) {
            r.addField(r.unmarshallField(line));
        }
        return r;
    }

    public Field unmarshallField(String str) {
        String[] values = new String[5];
        int prev = 0;
        for (int i = 0; i < 4; ++i) {
            int pos = str.indexOf(124, prev);
            if (pos < 0) {
                throw new RuntimeException("Wrong field: " + str);
            }
            values[i] = str.substring(prev, pos);
            prev = pos + 1;
        }
        if (str.indexOf(124, prev) >= 0) {
            throw new RuntimeException("Wrong field: " + str);
        }
        values[4] = str.substring(prev);
        Field r = new Field(SchemaDescription.uc(values[0]), SchemaDescription.uc(values[1]), Integer.parseInt(values[2]), Boolean.parseBoolean(values[4]));
        r.defaultValue = SchemaDescription.uc(values[3]);
        return r;
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    @Override
    public Iterator<Field> iterator() {
        return this.fields.iterator();
    }

    public String toString() {
        return this.marshall();
    }

    public static String c(String s) {
        if (s == null) {
            return "";
        }
        if (s.contains("|")) {
            throw new RuntimeException("Wrong value: " + s);
        }
        return s;
    }

    public static String uc(String s) {
        if (s != null && s.isEmpty()) {
            return null;
        }
        return s;
    }

    public Field getField(String pentahoFieldName) {
        if (pentahoFieldName == null || pentahoFieldName.trim().isEmpty()) {
            return null;
        }
        for (Field field : this.fields) {
            if (!field.pentahoFieldName.equals(pentahoFieldName)) continue;
            return field;
        }
        return null;
    }

    public Field getFormatField(String formatFieldName) {
        if (formatFieldName == null || formatFieldName.trim().isEmpty()) {
            return null;
        }
        for (Field field : this.fields) {
            if (!field.formatFieldName.equals(formatFieldName)) continue;
            return field;
        }
        return null;
    }

    public class Field {
        public String formatFieldName;
        public String pentahoFieldName;
        public int pentahoValueMetaType;
        public String defaultValue;
        public boolean allowNull;

        public Field(String formatFieldName, String pentahoFieldName, int pentahoValueMetaType, boolean allowNull) {
            this.formatFieldName = formatFieldName;
            this.pentahoFieldName = pentahoFieldName;
            this.pentahoValueMetaType = pentahoValueMetaType;
            this.allowNull = allowNull;
        }

        public Field(String formatFieldName, String pentahoFieldName, int pentahoValueMetaType, String defaultValue, boolean allowNull) {
            this.formatFieldName = formatFieldName;
            this.pentahoFieldName = pentahoFieldName;
            this.pentahoValueMetaType = pentahoValueMetaType;
            this.defaultValue = defaultValue;
            this.allowNull = allowNull;
        }

        public String marshall() {
            StringBuilder o = new StringBuilder(256);
            o.append(SchemaDescription.c(this.formatFieldName));
            o.append('|');
            o.append(SchemaDescription.c(this.pentahoFieldName));
            o.append('|');
            o.append(Integer.toString(this.pentahoValueMetaType));
            o.append('|');
            o.append(SchemaDescription.c(this.defaultValue));
            o.append('|');
            o.append(Boolean.toString(this.allowNull));
            return o.toString();
        }
    }
}

