/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.webpackage.extender.http.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.pentaho.webpackage.core.PentahoWebPackage;
import org.pentaho.webpackage.core.PentahoWebPackageBundle;
import org.pentaho.webpackage.extender.http.impl.PentahoWebPackageImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PentahoWebPackageBundleImpl
implements PentahoWebPackageBundle {
    private static Logger logger = LoggerFactory.getLogger(PentahoWebPackageBundleImpl.class);
    private static final JSONParser parser = new JSONParser();
    private final Bundle bundle;
    private ArrayList<PentahoWebPackage> pentahoWebPackages;

    PentahoWebPackageBundleImpl(Bundle bundle) {
        this.bundle = bundle;
        this.pentahoWebPackages = new ArrayList();
    }

    private static Map<String, Object> parsePackageJson(URL resourceUrl) throws IOException, ParseException {
        URLConnection urlConnection = resourceUrl.openConnection();
        InputStream inputStream = urlConnection.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        return (Map)parser.parse((Reader)bufferedReader);
    }

    public void init() {
        BundleWiring wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            List capabilities = wiring.getCapabilities("org.pentaho.webpackage");
            capabilities.forEach(bundleCapability -> {
                Map attributes = bundleCapability.getAttributes();
                String root = attributes.getOrDefault("root", "");
                while (root.endsWith("/")) {
                    root = root.substring(0, root.length() - 1);
                }
                try {
                    URL capabilityPackageJsonUrl = this.bundle.getResource(root + "/package.json");
                    if (capabilityPackageJsonUrl != null) {
                        Map<String, Object> packageJson = PentahoWebPackageBundleImpl.parsePackageJson(capabilityPackageJsonUrl);
                        String name = (String)packageJson.get("name");
                        String version = (String)packageJson.get("version");
                        if (name != null && version != null) {
                            this.pentahoWebPackages.add(new PentahoWebPackageImpl(this.bundle, name, version, root.isEmpty() ? "/" : root));
                        }
                    } else {
                        logger.warn(this.bundle.getSymbolicName() + " [" + this.bundle.getBundleId() + "]: " + root + "/package.json not found.");
                    }
                }
                catch (IOException | RuntimeException | ParseException ignored) {
                    logger.error(this.bundle.getSymbolicName() + " [" + this.bundle.getBundleId() + "]: Error parsing " + root + "/package.json.");
                }
            });
            this.pentahoWebPackages.forEach(PentahoWebPackage::init);
        }
    }

    public void destroy() {
        this.pentahoWebPackages.forEach(PentahoWebPackage::destroy);
    }
}

