/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.master;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupCopyService;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.BackupRestoreServerFactory;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.backup.impl.IncrementalBackupManager;
import org.apache.hadoop.hbase.backup.master.FullTableBackupProcedure;
import org.apache.hadoop.hbase.backup.util.BackupClientUtil;
import org.apache.hadoop.hbase.backup.util.BackupServerUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.mapreduce.WALPlayer;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.protobuf.generated.BackupProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class IncrementalTableBackupProcedure
extends StateMachineProcedure<MasterProcedureEnv, BackupProtos.IncrementalTableBackupState>
implements TableProcedureInterface {
    private static final Log LOG = LogFactory.getLog(IncrementalTableBackupProcedure.class);
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    private Configuration conf;
    private String backupId;
    private List<TableName> tableList;
    private String targetRootDir;
    HashMap<String, Long> newTimestamps = null;
    private BackupManager backupManager;
    private BackupInfo backupContext;

    public IncrementalTableBackupProcedure() {
    }

    public IncrementalTableBackupProcedure(MasterProcedureEnv env, String backupId, List<TableName> tableList, String targetRootDir, int workers, long bandwidth) throws IOException {
        this.backupManager = new BackupManager(env.getMasterConfiguration());
        this.backupId = backupId;
        this.tableList = tableList;
        this.targetRootDir = targetRootDir;
        this.backupContext = this.backupManager.createBackupInfo(backupId, BackupType.INCREMENTAL, tableList, targetRootDir, workers, bandwidth);
    }

    public byte[] getResult() {
        return this.backupId.getBytes();
    }

    private List<String> filterMissingFiles(List<String> incrBackupFileList) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        ArrayList<String> list = new ArrayList<String>();
        for (String file : incrBackupFileList) {
            if (fs.exists(new Path(file))) {
                list.add(file);
                continue;
            }
            LOG.warn((Object)("Can't find file: " + file));
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    Map<byte[], List<Path>>[] handleBulkLoad(List<TableName> sTableList) throws IOException {
        mapForSrc = new Map[sTableList.size()];
        pair = this.backupManager.readOrigBulkloadRows(sTableList);
        map = (Map)pair.getFirst();
        fs = FileSystem.get((Configuration)this.conf);
        try {
            tgtFs = FileSystem.get((URI)new URI(this.backupContext.getTargetRootDir()), (Configuration)this.conf);
        }
        catch (URISyntaxException use) {
            throw new IOException("Unable to get FileSystem", use);
        }
        rootdir = FSUtils.getRootDir(this.conf);
        tgtRoot = new Path(new Path(this.backupContext.getTargetRootDir()), this.backupId);
        IncrementalTableBackupProcedure.LOG.debug((Object)("in handleBulkLoad, tgtRoot = " + tgtRoot));
        for (Map.Entry<K, V> tblEntry : map.entrySet()) {
            srcTable = (TableName)tblEntry.getKey();
            srcIdx = BackupSystemTable.getIndex((TableName)srcTable, sTableList);
            if (srcIdx < 0) {
                IncrementalTableBackupProcedure.LOG.warn((Object)("Couldn't find " + srcTable + " in source table List"));
                continue;
            }
            if (mapForSrc[srcIdx] == null) {
                mapForSrc[srcIdx] = new TreeMap<K, V>(Bytes.BYTES_COMPARATOR);
            }
            tblDir = FSUtils.getTableDir(rootdir, srcTable);
            tgtTable = new Path(new Path(tgtRoot, srcTable.getNamespaceAsString()), srcTable.getQualifierAsString());
            for (Map.Entry<K, V> regionEntry : ((Map)tblEntry.getValue()).entrySet()) {
                regionName = (String)regionEntry.getKey();
                regionDir = new Path(tblDir, regionName);
                for (Map.Entry<K, V> famEntry : ((Map)regionEntry.getValue()).entrySet()) {
                    fam = (String)famEntry.getKey();
                    famDir = new Path(regionDir, fam);
                    if (!mapForSrc[srcIdx].containsKey(fam.getBytes())) {
                        files = new ArrayList<E>();
                        mapForSrc[srcIdx].put(fam.getBytes(), files);
                    } else {
                        files = (List)mapForSrc[srcIdx].get(fam.getBytes());
                    }
                    archiveDir = HFileArchiveUtil.getStoreArchivePath(this.conf, srcTable, regionName, fam);
                    tblName = srcTable.getQualifierAsString();
                    tgtFam = new Path(new Path(tgtTable, regionName), fam);
                    if (!tgtFs.mkdirs(tgtFam)) {
                        throw new IOException("couldn't create " + tgtFam);
                    }
                    for (Pair fileWithState : (List)famEntry.getValue()) {
                        block20: {
                            file = (String)fileWithState.getFirst();
                            raw = (Boolean)fileWithState.getSecond();
                            idx = file.lastIndexOf("/");
                            filename = file;
                            if (idx > 0) {
                                filename = file.substring(idx + 1);
                            }
                            p = new Path(famDir, filename);
                            tgt = new Path(tgtFam, filename);
                            archive = new Path(archiveDir, filename);
                            IncrementalTableBackupProcedure.LOG.debug((Object)("bulk testing " + p + " " + fs.exists(p)));
                            if (fs.exists(p)) {
                                IncrementalTableBackupProcedure.LOG.debug((Object)("found bulk hfile " + file + " in " + famDir + " for " + tblName));
                                try {
                                    IncrementalTableBackupProcedure.LOG.debug((Object)("copying " + p + " to " + tgt));
                                    FileUtil.copy((FileSystem)fs, (Path)p, (FileSystem)tgtFs, (Path)tgt, (boolean)false, (Configuration)this.conf);
                                }
                                catch (FileNotFoundException e) {
                                    IncrementalTableBackupProcedure.LOG.debug((Object)("copying archive " + archive + " to " + tgt));
                                    try {
                                        FileUtil.copy((FileSystem)fs, (Path)archive, (FileSystem)tgtFs, (Path)tgt, (boolean)false, (Configuration)this.conf);
                                    }
                                    catch (FileNotFoundException fnfe) {
                                        if (raw) ** GOTO lbl75
                                        throw fnfe;
                                    }
                                }
                            } else {
                                IncrementalTableBackupProcedure.LOG.debug((Object)("copying archive " + archive + " to " + tgt));
                                try {
                                    FileUtil.copy((FileSystem)fs, (Path)archive, (FileSystem)tgtFs, (Path)tgt, (boolean)false, (Configuration)this.conf);
                                }
                                catch (FileNotFoundException fnfe) {
                                    if (raw) break block20;
                                    throw fnfe;
                                }
                            }
                        }
                        files.add(tgt);
                    }
                }
            }
        }
        this.backupManager.writeBulkLoadedFiles(sTableList, mapForSrc);
        this.backupManager.removeOrigBulkLoadedRows(sTableList, (List)pair.getSecond());
        return mapForSrc;
    }

    private void incrementalCopy(BackupInfo backupContext) throws Exception {
        LOG.info((Object)"Incremental copy is starting.");
        backupContext.setPhase(BackupInfo.BackupPhase.INCREMENTAL_COPY);
        List<String> incrBackupFileList = backupContext.getIncrBackupFileList();
        incrBackupFileList = this.filterMissingFiles(incrBackupFileList);
        String[] strArr = incrBackupFileList.toArray(new String[incrBackupFileList.size() + 1]);
        strArr[strArr.length - 1] = backupContext.getHLogTargetDir();
        BackupCopyService copyService = BackupRestoreServerFactory.getBackupCopyService(this.conf);
        int res = copyService.copy(backupContext, this.backupManager, this.conf, BackupCopyService.Type.INCREMENTAL, strArr);
        if (res != 0) {
            LOG.error((Object)("Copy incremental log files failed with return code: " + res + "."));
            throw new IOException("Failed of Hadoop Distributed Copy from " + incrBackupFileList + " to " + backupContext.getHLogTargetDir());
        }
        LOG.info((Object)("Incremental copy from " + incrBackupFileList + " to " + backupContext.getHLogTargetDir() + " finished."));
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, BackupProtos.IncrementalTableBackupState state) {
        if (this.conf == null) {
            this.conf = env.getMasterConfiguration();
        }
        if (this.backupManager == null) {
            try {
                this.backupManager = new BackupManager(env.getMasterConfiguration());
            }
            catch (IOException ioe) {
                this.setFailure("incremental backup", ioe);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case PREPARE_INCREMENTAL: {
                    FullTableBackupProcedure.beginBackup(this.backupManager, this.backupContext);
                    LOG.debug((Object)("For incremental backup, current table set is " + this.backupManager.getIncrementalBackupTableSet()));
                    try {
                        IncrementalBackupManager incrBackupManager = new IncrementalBackupManager(this.backupManager);
                        this.newTimestamps = incrBackupManager.getIncrBackupLogFileList(this.backupContext);
                    }
                    catch (Exception e) {
                        this.setFailure("Failure in incremental-backup: preparation phase " + this.backupId, e);
                        FullTableBackupProcedure.failBackup(env, this.backupContext, this.backupManager, e, "Unexpected Exception : ", BackupType.INCREMENTAL, this.conf);
                    }
                    this.setNextState(BackupProtos.IncrementalTableBackupState.INCREMENTAL_COPY);
                    break;
                }
                case INCREMENTAL_COPY: {
                    try {
                        BackupServerUtil.copyTableRegionInfo(this.backupContext, this.conf);
                        this.convertWALsAndCopy(this.backupContext, (Connection)env.getMasterServices().getConnection());
                        this.incrementalCopyHFiles(this.backupContext);
                        this.backupManager.recordWALFiles(this.backupContext.getIncrBackupFileList());
                    }
                    catch (Exception e) {
                        String msg = "Unexpected exception in incremental-backup: incremental copy " + this.backupId;
                        this.setFailure(msg, e);
                        FullTableBackupProcedure.failBackup(env, this.backupContext, this.backupManager, e, msg, BackupType.INCREMENTAL, this.conf);
                    }
                    this.setNextState(BackupProtos.IncrementalTableBackupState.INCR_BACKUP_COMPLETE);
                    break;
                }
                case INCR_BACKUP_COMPLETE: {
                    this.backupContext.setState(BackupInfo.BackupState.COMPLETE);
                    HashMap<TableName, HashMap<String, Long>> previousTimestampMap = this.backupManager.readLogTimestampMap();
                    this.backupContext.setIncrTimestampMap(previousTimestampMap);
                    this.backupManager.writeRegionServerLogTimestamp(this.backupContext.getTables(), this.newTimestamps);
                    HashMap<TableName, HashMap<String, Long>> newTableSetTimestampMap = this.backupManager.readLogTimestampMap();
                    Long newStartCode = BackupClientUtil.getMinValue(BackupServerUtil.getRSLogTimestampMins(newTableSetTimestampMap));
                    this.backupManager.writeBackupStartCode(newStartCode);
                    this.handleBulkLoad(this.backupContext.getTableNames());
                    FullTableBackupProcedure.completeBackup(env, this.backupContext, this.backupManager, BackupType.INCREMENTAL, this.conf);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            this.setFailure("snapshot-table", e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, BackupProtos.IncrementalTableBackupState state) throws IOException {
        FullTableBackupProcedure.cleanupTargetDir(this.backupContext, this.conf);
    }

    protected BackupProtos.IncrementalTableBackupState getState(int stateId) {
        return BackupProtos.IncrementalTableBackupState.valueOf((int)stateId);
    }

    protected int getStateId(BackupProtos.IncrementalTableBackupState state) {
        return state.getNumber();
    }

    protected BackupProtos.IncrementalTableBackupState getInitialState() {
        return BackupProtos.IncrementalTableBackupState.PREPARE_INCREMENTAL;
    }

    protected void setNextState(BackupProtos.IncrementalTableBackupState state) {
        if (this.aborted.get()) {
            this.setAbortFailure("snapshot-table", "abort requested");
        } else {
            super.setNextState((Object)state);
        }
    }

    public boolean abort(MasterProcedureEnv env) {
        this.aborted.set(true);
        return true;
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (targetRootDir=");
        sb.append(this.targetRootDir);
        sb.append("; backupId=").append(this.backupId);
        sb.append("; tables=");
        int len = this.tableList.size();
        for (int i = 0; i < len - 1; ++i) {
            sb.append(this.tableList.get(i)).append(",");
        }
        if (len >= 1) {
            sb.append(this.tableList.get(len - 1));
        }
        sb.append(")");
    }

    BackupProtos.BackupProcContext toBackupInfo() {
        BackupProtos.BackupProcContext.Builder ctxBuilder = BackupProtos.BackupProcContext.newBuilder();
        ctxBuilder.setCtx(this.backupContext.toProtosBackupInfo());
        if (this.newTimestamps != null && !this.newTimestamps.isEmpty()) {
            BackupProtos.ServerTimestamp.Builder tsBuilder = BackupProtos.ServerTimestamp.newBuilder();
            for (Map.Entry<String, Long> entry : this.newTimestamps.entrySet()) {
                tsBuilder.clear().setServer(entry.getKey()).setTimestamp(entry.getValue().longValue());
                ctxBuilder.addServerTimestamp(tsBuilder.build());
            }
        }
        return ctxBuilder.build();
    }

    public void serializeStateData(OutputStream stream) throws IOException {
        super.serializeStateData(stream);
        BackupProtos.BackupProcContext backupProcCtx = this.toBackupInfo();
        backupProcCtx.writeDelimitedTo(stream);
    }

    public void deserializeStateData(InputStream stream) throws IOException {
        super.deserializeStateData(stream);
        BackupProtos.BackupProcContext proto = BackupProtos.BackupProcContext.parseDelimitedFrom((InputStream)stream);
        this.backupContext = BackupInfo.fromProto((BackupProtos.BackupInfo)proto.getCtx());
        this.backupId = this.backupContext.getBackupId();
        this.targetRootDir = this.backupContext.getTargetRootDir();
        this.tableList = this.backupContext.getTableNames();
        List svrTimestamps = proto.getServerTimestampList();
        if (svrTimestamps != null && !svrTimestamps.isEmpty()) {
            this.newTimestamps = new HashMap();
            for (BackupProtos.ServerTimestamp ts : svrTimestamps) {
                this.newTimestamps.put(ts.getServer(), ts.getTimestamp());
            }
        }
    }

    @Override
    public TableName getTableName() {
        return TableName.BACKUP_TABLE_NAME;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.BACKUP;
    }

    protected boolean acquireLock(MasterProcedureEnv env) {
        if (!env.isInitialized() && !this.getTableName().isSystemTable()) {
            return false;
        }
        return env.getProcedureQueue().tryAcquireTableWrite(this.getTableName(), "incremental backup");
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureQueue().releaseTableWrite(this.getTableName());
    }

    private void incrementalCopyHFiles(BackupInfo backupContext) throws Exception {
        LOG.info((Object)"Incremental copy HFiles is starting.");
        backupContext.setPhase(BackupInfo.BackupPhase.INCREMENTAL_COPY);
        ArrayList<String> incrBackupFileList = new ArrayList<String>();
        incrBackupFileList.add(this.getBulkOutputDir().toString());
        String[] strArr = incrBackupFileList.toArray(new String[incrBackupFileList.size() + 1]);
        strArr[strArr.length - 1] = backupContext.getTargetRootDir();
        BackupCopyService copyService = BackupRestoreServerFactory.getBackupCopyService(this.conf);
        int res = copyService.copy(backupContext, this.backupManager, this.conf, BackupCopyService.Type.INCREMENTAL, strArr);
        if (res != 0) {
            LOG.error((Object)("Copy incremental HFile files failed with return code: " + res + "."));
            throw new IOException("Failed of Hadoop Distributed Copy from " + StringUtils.join((CharSequence)",", incrBackupFileList) + " to " + backupContext.getHLogTargetDir());
        }
        this.deleteBulkLoadDirectory();
        LOG.info((Object)("Incremental copy HFiles from " + StringUtils.join((CharSequence)",", incrBackupFileList) + " to " + backupContext.getTargetRootDir() + " finished."));
    }

    private void deleteBulkLoadDirectory() throws IOException {
        Path path = this.getBulkOutputDir();
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        boolean result = fs.delete(path, true);
        if (!result) {
            LOG.warn((Object)("Could not delete " + path));
        }
    }

    private void convertWALsAndCopy(BackupInfo backupContext, Connection conn) throws IOException {
        List<String> incrBackupFileList = backupContext.getIncrBackupFileList();
        incrBackupFileList = this.filterMissingFiles(incrBackupFileList);
        Set<TableName> tableSet = this.backupManager.getIncrementalBackupTableSet();
        for (TableName table : tableSet) {
            if (this.tableExists(table, conn)) {
                this.convertWALToHFiles(incrBackupFileList, table);
                continue;
            }
            LOG.warn((Object)("Table " + table + " does not exists. Skipping in WAL converter"));
        }
    }

    private boolean tableExists(TableName table, Connection conn) throws IOException {
        try (Admin admin = conn.getAdmin();){
            boolean bl = admin.tableExists(table);
            return bl;
        }
    }

    private void convertWALToHFiles(List<String> dirPaths, TableName tableName) throws IOException {
        WALPlayer player = new WALPlayer();
        String bulkOutputConfKey = "wal.bulk.output";
        String dirs = StringUtils.join((CharSequence)";", dirPaths);
        Path bulkOutputPath = this.getBulkOutputDirForTable(tableName);
        this.conf.set(bulkOutputConfKey, bulkOutputPath.toString());
        this.conf.set("wal.input.separator", ";");
        String[] playerArgs = new String[]{dirs, tableName.getNameAsString()};
        try {
            player.setConf(this.conf);
            player.run(playerArgs);
            this.conf.unset("wal.input.separator");
        }
        catch (Exception e) {
            throw new IOException("Can not convert from directory " + dirs + " (check Hadoop and HBase logs) ", e);
        }
    }

    private Path getBulkOutputDirForTable(TableName table) {
        Path tablePath = this.getBulkOutputDir();
        tablePath = new Path(tablePath, table.getNamespaceAsString());
        tablePath = new Path(tablePath, table.getQualifierAsString());
        return new Path(tablePath, "data");
    }

    private Path getBulkOutputDir() {
        String backupId = this.backupContext.getBackupId();
        Path path = new Path(this.backupContext.getTargetRootDir());
        path = new Path(path, ".tmp");
        path = new Path(path, backupId);
        return path;
    }
}

