/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.core.widget.DoubleClickInterface;

public class TreeItemAccelerator {
    public static final void addDoubleClick(final TreeItem treeItem, final DoubleClickInterface doubleClick) {
        final String[] path1 = ConstUI.getTreeStrings(treeItem);
        final Tree tree = treeItem.getParent();
        if (doubleClick != null) {
            final SelectionAdapter selectionAdapter = new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    TreeItem[] items = tree.getSelection();
                    for (int i = 0; i < items.length; ++i) {
                        String[] path2 = ConstUI.getTreeStrings(items[i]);
                        if (!TreeItemAccelerator.equalPaths(path1, path2)) continue;
                        doubleClick.action(treeItem);
                    }
                }
            };
            tree.addSelectionListener((SelectionListener)selectionAdapter);
            treeItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    tree.removeSelectionListener((SelectionListener)selectionAdapter);
                }
            });
        }
    }

    public static final boolean equalPaths(String[] path1, String[] path2) {
        if (path1 == null || path2 == null) {
            return false;
        }
        if (path1.length != path2.length) {
            return false;
        }
        for (int i = 0; i < path1.length; ++i) {
            if (path1[i].equals(path2[i])) continue;
            return false;
        }
        return true;
    }
}

