/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.GUIPositionInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.ui.spoon.ChangedWarningDialog;
import org.pentaho.di.ui.spoon.ChangedWarningInterface;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;

public abstract class AbstractGraph
extends Composite {
    protected Point offset;
    protected Point iconoffset;
    protected Point noteoffset;
    protected ScrollBar vert;
    protected ScrollBar hori;
    protected Canvas canvas;
    protected float magnification = 1.0f;
    protected Combo zoomLabel;
    protected XulDomContainer xulDomContainer;

    public AbstractGraph(Composite parent, int style) {
        super(parent, style);
    }

    protected abstract Point getOffset();

    protected Point getOffset(Point thumb, Point area) {
        Point p = new Point(0, 0);
        Point sel = new Point(this.hori.getSelection(), this.vert.getSelection());
        if (thumb.x == 0 || thumb.y == 0) {
            return p;
        }
        p.x = Math.round((float)(-sel.x * area.x / thumb.x) / this.magnification);
        p.y = Math.round((float)(-sel.y * area.y / thumb.y) / this.magnification);
        return p;
    }

    protected Point magnifyPoint(Point p) {
        return new Point(Math.round((float)p.x * this.magnification), Math.round((float)p.y * this.magnification));
    }

    protected Point getThumb(Point area, Point transMax) {
        Point resizedMax = this.magnifyPoint(transMax);
        Point thumb = new Point(0, 0);
        thumb.x = resizedMax.x <= area.x ? 100 : 100 * area.x / resizedMax.x;
        thumb.y = resizedMax.y <= area.y ? 100 : 100 * area.y / resizedMax.y;
        return thumb;
    }

    public int sign(int n) {
        return n < 0 ? -1 : (n > 0 ? 1 : 1);
    }

    protected Point getArea() {
        Rectangle rect = this.canvas.getClientArea();
        Point area = new Point(rect.width, rect.height);
        return area;
    }

    protected void setZoomLabel() {
        this.zoomLabel.setText(Integer.toString(Math.round(this.magnification * 100.0f)) + "%");
    }

    protected <T extends GUIPositionInterface> void doRightClickSelection(T clicked, List<T> selection) {
        if (selection.contains(clicked)) {
            return;
        }
        if (!selection.isEmpty()) {
            for (GUIPositionInterface selected : selection) {
                selected.setSelected(false);
            }
            selection.clear();
        }
        clicked.setSelected(true);
        selection.add(clicked);
        this.redraw();
    }

    public void redraw() {
        if (this.isDisposed() || this.canvas.isDisposed()) {
            return;
        }
        this.canvas.redraw();
        this.setZoomLabel();
    }

    public void zoomIn() {
        this.magnification += 0.1f;
        this.redraw();
    }

    public void zoomOut() {
        this.magnification -= 0.1f;
        this.redraw();
    }

    public void zoom100Percent() {
        this.magnification = 1.0f;
        this.redraw();
    }

    public Point screen2real(int x, int y) {
        this.offset = this.getOffset();
        Point real = this.offset != null ? new Point(Math.round((float)x / this.magnification - (float)this.offset.x), Math.round((float)y / this.magnification - (float)this.offset.y)) : new Point(x, y);
        return real;
    }

    public Point real2screen(int x, int y) {
        this.offset = this.getOffset();
        Point screen = new Point(x + this.offset.x, y + this.offset.y);
        return screen;
    }

    public boolean forceFocus() {
        return this.canvas.forceFocus();
    }

    public ChangedWarningInterface getChangedWarning() {
        return ChangedWarningDialog.getInstance();
    }

    public int showChangedWarning(String fileName) throws KettleException {
        ChangedWarningInterface changedWarning = this.getChangedWarning();
        if (changedWarning != null) {
            try {
                return changedWarning.show(fileName);
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
        }
        return 0;
    }

    public int showChangedWarning() throws KettleException {
        return this.showChangedWarning(null);
    }

    public void dispose() {
        super.dispose();
        List pops = this.xulDomContainer.getDocumentRoot().getElementsByTagName("menupopup");
        for (XulComponent pop : pops) {
            ((MenuManager)pop.getManagedObject()).dispose();
        }
    }
}

