/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.delegates;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.UndoInterface;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.undo.TransAction;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.special.JobEntrySpecial;
import org.pentaho.di.job.entries.sql.JobEntrySQL;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.job.dialog.JobExecutionConfigurationDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.TabMapEntry;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.di.ui.spoon.job.JobGraph;
import org.pentaho.di.ui.spoon.wizards.RipDatabaseWizardPage1;
import org.pentaho.di.ui.spoon.wizards.RipDatabaseWizardPage2;
import org.pentaho.di.ui.spoon.wizards.RipDatabaseWizardPage3;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.xul.swt.tab.TabItem;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SpoonJobDelegate
extends SpoonDelegate {
    private static Class<?> PKG = Spoon.class;
    private List<JobMeta> jobMap = new ArrayList<JobMeta>();

    public SpoonJobDelegate(Spoon spoon) {
        super(spoon);
    }

    public JobEntryCopy newJobEntry(JobMeta jobMeta, String type_desc, boolean openit) {
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginInterface jobPlugin = null;
        try {
            jobPlugin = PluginRegistry.getInstance().findPluginWithName(JobEntryPluginType.class, type_desc);
            if (jobPlugin == null && ("START".equals(type_desc) || "DUMMY".equals(type_desc))) {
                jobPlugin = registry.findPluginWithId(JobEntryPluginType.class, "SPECIAL");
            }
            if (jobPlugin != null) {
                String basename;
                String entry_name = basename = type_desc;
                int nr = 2;
                JobEntryCopy check = jobMeta.findJobEntry(entry_name, 0, true);
                while (check != null) {
                    entry_name = basename + " " + nr++;
                    check = jobMeta.findJobEntry(entry_name, 0, true);
                }
                JobEntryInterface jei = (JobEntryInterface)registry.loadClass(jobPlugin);
                jei.setPluginId(jobPlugin.getIds()[0]);
                jei.setName(entry_name);
                if (jei.isSpecial()) {
                    if ("START".equals(type_desc)) {
                        if (jobMeta.findStart() != null) {
                            JobGraph.showOnlyStartOnceMessage(this.spoon.getShell());
                            return null;
                        }
                        ((JobEntrySpecial)jei).setStart(true);
                        jei.setName("START");
                    }
                    if ("DUMMY".equals(type_desc)) {
                        ((JobEntrySpecial)jei).setDummy(true);
                    }
                }
                if (openit) {
                    JobEntryDialogInterface d = this.getJobEntryDialog(jei, jobMeta);
                    if (d != null && d.open() != null) {
                        JobEntryCopy jge = new JobEntryCopy();
                        jge.setEntry(jei);
                        jge.setLocation(50, 50);
                        jge.setNr(0);
                        jobMeta.addJobEntry(jge);
                        jobMeta.renameJobEntryIfNameCollides(jge);
                        this.spoon.addUndoNew((UndoInterface)jobMeta, new JobEntryCopy[]{jge}, new int[]{jobMeta.indexOfJobEntry(jge)});
                        this.spoon.refreshGraph();
                        this.spoon.refreshTree();
                        return jge;
                    }
                    return null;
                }
                JobEntryCopy jge = new JobEntryCopy();
                jge.setEntry(jei);
                jge.setLocation(50, 50);
                jge.setNr(0);
                jobMeta.addJobEntry(jge);
                this.spoon.addUndoNew((UndoInterface)jobMeta, new JobEntryCopy[]{jge}, new int[]{jobMeta.indexOfJobEntry(jge)});
                this.spoon.refreshGraph();
                this.spoon.refreshTree();
                return jge;
            }
            return null;
        }
        catch (Throwable e) {
            new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.UnexpectedErrorCreatingNewJobGraphEntry.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.UnexpectedErrorCreatingNewJobGraphEntry.Message", (String[])new String[0]), new Exception(e));
            return null;
        }
    }

    public JobEntryDialogInterface getJobEntryDialog(JobEntryInterface jobEntryInterface, JobMeta jobMeta) {
        PluginRegistry registry = PluginRegistry.getInstance();
        String dialogClassName = jobEntryInterface.getDialogClassName();
        try {
            Class dialogClass;
            Class[] paramClasses = new Class[]{this.spoon.getShell().getClass(), JobEntryInterface.class, Repository.class, JobMeta.class};
            Object[] paramArgs = new Object[]{this.spoon.getShell(), jobEntryInterface, this.spoon.getRepository(), jobMeta};
            try {
                PluginInterface plugin = registry.getPlugin(JobEntryPluginType.class, (Object)jobEntryInterface);
                dialogClass = (Class)PluginRegistry.getInstance().getClass(plugin, dialogClassName);
            }
            catch (Exception e) {
                dialogClass = Class.forName(dialogClassName, true, jobEntryInterface.getClass().getClassLoader());
            }
            Constructor dialogConstructor = dialogClass.getConstructor(paramClasses);
            JobEntryDialogInterface entryDialogInterface = (JobEntryDialogInterface)dialogConstructor.newInstance(paramArgs);
            entryDialogInterface.setMetaStore((IMetaStore)this.spoon.getMetaStore());
            return entryDialogInterface;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.spoon.getLog().logError(this.spoon.toString(), new Object[]{"Could not create dialog for " + dialogClassName, t});
            return null;
        }
    }

    public StepDialogInterface getStepEntryDialog(StepMetaInterface stepMeta, TransMeta transMeta, String stepName) {
        String dialogClassName = stepMeta.getDialogClassName();
        try {
            Class[] paramClasses = new Class[]{this.spoon.getShell().getClass(), Object.class, TransMeta.class, String.class};
            Object[] paramArgs = new Object[]{this.spoon.getShell(), stepMeta, transMeta, stepName};
            Class<?> dialogClass = stepMeta.getClass().getClassLoader().loadClass(dialogClassName);
            Constructor<?> dialogConstructor = dialogClass.getConstructor(paramClasses);
            return (StepDialogInterface)dialogConstructor.newInstance(paramArgs);
        }
        catch (Throwable t) {
            this.spoon.getLog().logError(this.spoon.toString(), new Object[]{"Could not create dialog for " + dialogClassName, t});
            return null;
        }
    }

    public void editJobEntry(JobMeta jobMeta, JobEntryCopy je) {
        block6: {
            try {
                JobEntrySpecial special;
                this.spoon.getLog().logBasic(this.spoon.toString(), new Object[]{BaseMessages.getString(PKG, (String)"Spoon.Log.EditJobEntry", (String[])new String[]{je.getName()})});
                JobEntryCopy before = (JobEntryCopy)je.clone_deep();
                JobEntryInterface jei = je.getEntry();
                if (jei.isSpecial() && (special = (JobEntrySpecial)jei).isDummy()) {
                    return;
                }
                JobEntryDialogInterface d = this.getJobEntryDialog(jei, jobMeta);
                if (d != null) {
                    if (d.open() != null) {
                        jobMeta.renameJobEntryIfNameCollides(je);
                        JobEntryCopy after = (JobEntryCopy)je.clone();
                        this.spoon.addUndoChange((UndoInterface)jobMeta, new JobEntryCopy[]{before}, new JobEntryCopy[]{after}, new int[]{jobMeta.indexOfJobEntry(je)});
                        this.spoon.refreshGraph();
                        this.spoon.refreshTree();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.spoon.getShell(), 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.JobEntryCanNotBeChanged.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.JobEntryCanNotBeChanged.Title", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                if (this.spoon.getShell().isDisposed()) break block6;
                new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.ErrorEditingJobEntry.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.ErrorEditingJobEntry.Message", (String[])new String[0]), e);
            }
        }
    }

    public void deleteJobEntryCopies(JobMeta job, JobEntryCopy[] jobEntries) {
        ArrayList<JobHopMeta> jobHops = new ArrayList<JobHopMeta>();
        int[] hopIndexes = new int[job.nrJobHops()];
        int hopIndex = 0;
        block0: for (int i = job.nrJobHops() - 1; i >= 0; --i) {
            JobHopMeta hi = job.getJobHop(i);
            for (int j = 0; j < jobEntries.length && hopIndex < hopIndexes.length; ++j) {
                if (!hi.getFromEntry().equals((Object)jobEntries[j]) && !hi.getToEntry().equals((Object)jobEntries[j])) continue;
                int idx = job.indexOfJobHop(hi);
                jobHops.add((JobHopMeta)hi.clone());
                hopIndexes[hopIndex] = idx;
                job.removeJobHop(idx);
                this.spoon.refreshTree();
                ++hopIndex;
                continue block0;
            }
        }
        if (!jobHops.isEmpty()) {
            Object[] hops = jobHops.toArray(new JobHopMeta[jobHops.size()]);
            this.spoon.addUndoDelete((UndoInterface)job, hops, hopIndexes);
        }
        int[] positions = new int[jobEntries.length];
        for (int i = 0; i < jobEntries.length; ++i) {
            int pos = job.indexOfJobEntry(jobEntries[i]);
            job.removeJobEntry(pos);
            positions[i] = pos;
        }
        this.spoon.addUndoDelete((UndoInterface)job, jobEntries, positions);
        this.spoon.refreshTree();
        this.spoon.refreshGraph();
    }

    public void deleteJobEntryCopies(JobMeta jobMeta, JobEntryCopy jobEntry) {
        for (int i = jobMeta.nrJobHops() - 1; i >= 0; --i) {
            JobHopMeta hi = jobMeta.getJobHop(i);
            if (!hi.getFromEntry().equals((Object)jobEntry) && !hi.getToEntry().equals((Object)jobEntry)) continue;
            int idx = jobMeta.indexOfJobHop(hi);
            this.spoon.addUndoDelete((UndoInterface)jobMeta, new JobHopMeta[]{(JobHopMeta)hi.clone()}, new int[]{idx});
            jobMeta.removeJobHop(idx);
            this.spoon.refreshTree();
        }
        int pos = jobMeta.indexOfJobEntry(jobEntry);
        jobMeta.removeJobEntry(pos);
        this.spoon.addUndoDelete((UndoInterface)jobMeta, new JobEntryCopy[]{jobEntry}, new int[]{pos});
        this.spoon.refreshTree();
        this.spoon.refreshGraph();
    }

    public void dupeJobEntry(JobMeta jobMeta, JobEntryCopy jobEntry) {
        if (jobEntry == null) {
            return;
        }
        if (jobEntry.isStart()) {
            MessageBox mb = new MessageBox(this.spoon.getShell(), 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.OnlyUseStartOnce.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.OnlyUseStartOnce.Title", (String[])new String[0]));
            mb.open();
            return;
        }
        JobEntryCopy dupejge = (JobEntryCopy)jobEntry.clone();
        dupejge.setNr(jobMeta.findUnusedNr(dupejge.getName()));
        if (dupejge.isDrawn()) {
            Point p = jobEntry.getLocation();
            dupejge.setLocation(p.x + 10, p.y + 10);
        }
        jobMeta.addJobEntry(dupejge);
        this.spoon.refreshGraph();
        this.spoon.refreshTree();
        this.spoon.setShellText();
    }

    public void copyJobEntries(JobMeta jobMeta, List<JobEntryCopy> jec) {
        if (jec == null || jec.size() == 0) {
            return;
        }
        String xml = XMLHandler.getXMLHeader();
        xml = xml + XMLHandler.openTag((String)"job-jobentries") + Const.CR;
        for (int i = 0; i < jec.size(); ++i) {
            xml = xml + jec.get(i).getXML();
        }
        xml = xml + "    " + XMLHandler.closeTag((String)"job-jobentries") + Const.CR;
        this.spoon.toClipboard(xml);
    }

    public void pasteXML(JobMeta jobMeta, String clipcontent, Point loc) {
        try {
            Point p;
            Document doc = XMLHandler.loadXMLString((String)clipcontent);
            jobMeta.unselectAll();
            Node entriesnode = XMLHandler.getSubNode((Node)doc, (String)"job-jobentries");
            int nr = XMLHandler.countNodes((Node)entriesnode, (String)"entry");
            this.spoon.getLog().logDebug(this.spoon.toString(), new Object[]{"I found " + nr + " job entries to paste on location: " + loc});
            ArrayList<JobEntryCopy> entryList = new ArrayList<JobEntryCopy>(nr);
            Point min = new Point(99999999, 99999999);
            for (int i = 0; i < nr; ++i) {
                Node entrynode = XMLHandler.getSubNodeByNr((Node)entriesnode, (String)"entry", (int)i);
                JobEntryCopy copy = new JobEntryCopy(entrynode, jobMeta.getDatabases(), jobMeta.getSlaveServers(), this.spoon.getRepository(), (IMetaStore)this.spoon.getMetaStore());
                if (copy.isStart() && jobMeta.findStart() != null) {
                    JobGraph.showOnlyStartOnceMessage(this.spoon.getShell());
                    continue;
                }
                String name = jobMeta.getAlternativeJobentryName(copy.getName());
                copy.setName(name);
                if (loc != null) {
                    p = copy.getLocation();
                    if (min.x > p.x) {
                        min.x = p.x;
                    }
                    if (min.y > p.y) {
                        min.y = p.y;
                    }
                }
                entryList.add(copy);
            }
            Object[] entries = entryList.toArray(new JobEntryCopy[0]);
            Point offset = new Point(loc.x - min.x, loc.y - min.y);
            int[] position = new int[entries.length];
            for (int i = 0; i < entries.length; ++i) {
                p = entries[i].getLocation();
                String name = entries[i].getName();
                entries[i].setLocation(p.x + offset.x, p.y + offset.y);
                entries[i].setName(jobMeta.getAlternativeJobentryName(name));
                jobMeta.addJobEntry((JobEntryCopy)entries[i]);
                position[i] = jobMeta.indexOfJobEntry((JobEntryCopy)entries[i]);
            }
            this.spoon.addUndoNew((UndoInterface)jobMeta, entries, position);
            if (jobMeta.hasChanged()) {
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.ErrorPasingJobEntries.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.ErrorPasingJobEntries.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void newJobHop(JobMeta jobMeta, JobEntryCopy fr, JobEntryCopy to) {
        JobHopMeta hi = new JobHopMeta(fr, to);
        jobMeta.addJobHop(hi);
        this.spoon.addUndoNew((UndoInterface)jobMeta, new JobHopMeta[]{hi}, new int[]{jobMeta.indexOfJobHop(hi)});
        this.spoon.refreshGraph();
        this.spoon.refreshTree();
    }

    public void ripDBWizard() {
        final List<DatabaseMeta> databases = this.spoon.getActiveDatabases();
        if (databases.size() == 0) {
            return;
        }
        final RipDatabaseWizardPage1 page1 = new RipDatabaseWizardPage1("1", databases);
        final RipDatabaseWizardPage2 page2 = new RipDatabaseWizardPage2("2");
        final RipDatabaseWizardPage3 page3 = new RipDatabaseWizardPage3("3", this.spoon.getRepository());
        Wizard wizard = new Wizard(){

            public boolean performFinish() {
                try {
                    JobMeta jobMeta = SpoonJobDelegate.this.ripDB(databases, page3.getJobname(), page3.getRepositoryDirectory(), page3.getDirectory(), page1.getSourceDatabase(), page1.getTargetDatabase(), page2.getSelection());
                    if (jobMeta == null) {
                        return false;
                    }
                    if (page3.getRepositoryDirectory() != null) {
                        SpoonJobDelegate.this.spoon.saveToRepository((EngineMetaInterface)jobMeta, false);
                    } else {
                        SpoonJobDelegate.this.spoon.saveToFile((EngineMetaInterface)jobMeta);
                    }
                    SpoonJobDelegate.this.addJobGraph(jobMeta);
                    return true;
                }
                catch (Exception e) {
                    new ErrorDialog(SpoonJobDelegate.this.spoon.getShell(), "Error", "An unexpected error occurred!", e);
                    return false;
                }
            }

            public boolean canFinish() {
                return page3.canFinish();
            }
        };
        wizard.addPage((IWizardPage)page1);
        wizard.addPage((IWizardPage)page2);
        wizard.addPage((IWizardPage)page3);
        WizardDialog wd = new WizardDialog(this.spoon.getShell(), (IWizard)wizard);
        WizardDialog.setDefaultImage((Image)GUIResource.getInstance().getImageWizard());
        wd.setMinimumPageSize(700, 400);
        wd.updateSize();
        wd.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobMeta ripDB(List<DatabaseMeta> databases, String jobname, final RepositoryDirectoryInterface repdir, final String directory, final DatabaseMeta sourceDbInfo, final DatabaseMeta targetDbInfo, final String[] tables) {
        final JobMeta jobMeta = new JobMeta();
        jobMeta.setDatabases(databases);
        jobMeta.setFilename(null);
        jobMeta.setName(jobname);
        if (this.spoon.getRepository() != null) {
            jobMeta.setRepositoryDirectory(repdir);
        } else {
            jobMeta.setFilename(Const.createFilename((String)directory, (String)jobname, (String)".kjb"));
        }
        this.spoon.refreshTree();
        this.spoon.refreshGraph();
        final Point location = new Point(50, 50);
        final JobEntryCopy start = JobMeta.createStartEntry();
        start.setLocation(new Point(location.x, location.y));
        start.setDrawn();
        jobMeta.addJobEntry(start);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask(BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Monitor.BuildingNewJob", (String[])new String[0]), tables.length);
                    monitor.worked(0);
                    JobEntryCopy previous = start;
                    for (int i = 0; i < tables.length && !monitor.isCanceled(); ++i) {
                        monitor.setTaskName(BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Monitor.ProcessingTable", (String[])new String[0]) + tables[i] + "]...");
                        String transname = BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Monitor.Transname1", (String[])new String[0]) + sourceDbInfo + "].[" + tables[i] + BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Monitor.Transname2", (String[])new String[0]) + targetDbInfo + "]";
                        TransMeta transMeta = new TransMeta();
                        if (repdir != null) {
                            transMeta.setRepositoryDirectory(repdir);
                        } else {
                            transMeta.setFilename(Const.createFilename((String)directory, (String)transname, (String)".ktr"));
                        }
                        transMeta.addDatabase(sourceDbInfo);
                        transMeta.addDatabase(targetDbInfo);
                        String note = BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Monitor.Note1", (String[])new String[0]) + tables[i] + BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Monitor.Note2", (String[])new String[0]) + sourceDbInfo + "]" + Const.CR;
                        note = note + BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Monitor.Note3", (String[])new String[0]) + tables[i] + BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Monitor.Note4", (String[])new String[0]) + targetDbInfo + "]";
                        NotePadMeta ni = new NotePadMeta(note, 150, 10, -1, -1);
                        transMeta.addNote(ni);
                        String fromstepname = BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Monitor.FromStep.Name", (String[])new String[0]) + tables[i] + "]";
                        TableInputMeta tii = new TableInputMeta();
                        tii.setDefault();
                        tii.setDatabaseMeta(sourceDbInfo);
                        tii.setSQL("SELECT * FROM " + tables[i]);
                        String fromstepid = PluginRegistry.getInstance().getPluginId(StepPluginType.class, (Object)tii);
                        StepMeta fromstep = new StepMeta(fromstepid, fromstepname, (StepMetaInterface)tii);
                        fromstep.setLocation(150, 100);
                        fromstep.setDraw(true);
                        fromstep.setDescription(BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Monitor.FromStep.Description", (String[])new String[0]) + tables[i] + BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Monitor.FromStep.Description2", (String[])new String[0]) + sourceDbInfo + "]");
                        transMeta.addStep(fromstep);
                        String tostepname = BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Monitor.ToStep.Name", (String[])new String[0]) + tables[i] + "]";
                        TableOutputMeta toi = new TableOutputMeta();
                        toi.setDatabaseMeta(targetDbInfo);
                        toi.setTableName(tables[i]);
                        toi.setCommitSize(100);
                        toi.setTruncateTable(true);
                        String tostepid = PluginRegistry.getInstance().getPluginId(StepPluginType.class, (Object)toi);
                        StepMeta tostep = new StepMeta(tostepid, tostepname, (StepMetaInterface)toi);
                        tostep.setLocation(500, 100);
                        tostep.setDraw(true);
                        tostep.setDescription(BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Monitor.ToStep.Description1", (String[])new String[0]) + tables[i] + BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Monitor.ToStep.Description2", (String[])new String[0]) + targetDbInfo + "]");
                        transMeta.addStep(tostep);
                        TransHopMeta hi = new TransHopMeta(fromstep, tostep);
                        transMeta.addTransHop(hi);
                        String tmpSql = tii.getSQL();
                        tii.setSQL(tii.getSQL() + sourceDbInfo.getLimitClause(1));
                        String sql = "";
                        try {
                            sql = transMeta.getSQLStatementsString();
                        }
                        catch (KettleStepException kse) {
                            throw new InvocationTargetException(kse, BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Exception.ErrorGettingSQLFromTransformation", (String[])new String[0]) + transMeta + "] : " + kse.getMessage());
                        }
                        tii.setSQL(tmpSql);
                        boolean ok = SpoonJobDelegate.this.spoon.getRepository() != null ? SpoonJobDelegate.this.spoon.saveToRepository((EngineMetaInterface)transMeta, false) : SpoonJobDelegate.this.spoon.saveToFile((EngineMetaInterface)transMeta);
                        if (!ok) {
                            throw new InvocationTargetException(new Exception(BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Exception.UnableToSaveTransformationToRepository", (String[])new String[0])), BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.Exception.UnableToSaveTransformationToRepository", (String[])new String[0]));
                        }
                        location.x = 250;
                        if (i > 0) {
                            location.y += 100;
                        }
                        if (!Utils.isEmpty((CharSequence)sql)) {
                            String jesqlname = BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.JobEntrySQL.Name", (String[])new String[0]) + tables[i] + "]";
                            JobEntrySQL jesql = new JobEntrySQL(jesqlname);
                            jesql.setDatabase(targetDbInfo);
                            jesql.setSQL(sql);
                            jesql.setDescription(BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.JobEntrySQL.Description", (String[])new String[0]) + targetDbInfo + "].[" + tables[i] + "]");
                            JobEntryCopy jecsql = new JobEntryCopy();
                            jecsql.setEntry((JobEntryInterface)jesql);
                            jecsql.setLocation(new Point(location.x, location.y));
                            jecsql.setDrawn();
                            jobMeta.addJobEntry(jecsql);
                            JobHopMeta jhi = new JobHopMeta(previous, jecsql);
                            jobMeta.addJobHop(jhi);
                            previous = jecsql;
                        }
                        String jetransname = BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.JobEntryTrans.Name", (String[])new String[0]) + tables[i] + "]";
                        JobEntryTrans jetrans = new JobEntryTrans(jetransname);
                        jetrans.setTransname(transMeta.getName());
                        if (SpoonJobDelegate.this.spoon.getRepository() != null) {
                            jetrans.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
                            jetrans.setDirectory(transMeta.getRepositoryDirectory().getPath());
                        } else {
                            jetrans.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
                            jetrans.setFileName(Const.createFilename((String)"${Internal.Job.Filename.Directory}", (String)transMeta.getName(), (String)".ktr"));
                        }
                        JobEntryCopy jectrans = new JobEntryCopy((JobEntryInterface)jetrans);
                        jectrans.setDescription(BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.JobEntryTrans.Description1", (String[])new String[0]) + Const.CR + BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.JobEntryTrans.Description2", (String[])new String[0]) + sourceDbInfo + "].[" + tables[i] + "]" + Const.CR + BaseMessages.getString((Class)PKG, (String)"Spoon.RipDB.JobEntryTrans.Description3", (String[])new String[0]) + targetDbInfo + "].[" + tables[i] + "]");
                        jectrans.setDrawn();
                        location.x += 400;
                        jectrans.setLocation(new Point(location.x, location.y));
                        jobMeta.addJobEntry(jectrans);
                        JobHopMeta jhi2 = new JobHopMeta(previous, jectrans);
                        jobMeta.addJobHop(jhi2);
                        previous = jectrans;
                        monitor.worked(1);
                    }
                    monitor.worked(100);
                    monitor.done();
                }
                catch (Exception e) {
                    new ErrorDialog(SpoonJobDelegate.this.spoon.getShell(), "Error", "An unexpected error occurred!", e);
                }
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.spoon.getShell());
            pmd.run(false, true, op);
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.RipDB.ErrorRippingTheDatabase.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.RipDB.ErrorRippingTheDatabase.Message", (String[])new String[0]), e);
            JobMeta jobMeta2 = null;
            return jobMeta2;
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.RipDB.ErrorRippingTheDatabase.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.RipDB.ErrorRippingTheDatabase.Message", (String[])new String[0]), e);
            JobMeta jobMeta3 = null;
            return jobMeta3;
        }
        finally {
            this.spoon.refreshGraph();
            this.spoon.refreshTree();
        }
        return jobMeta;
    }

    public boolean isDefaultJobName(String name) {
        if (!name.startsWith(Spoon.STRING_JOB)) {
            return false;
        }
        for (int i = Spoon.STRING_JOB.length() + 1; i < name.length(); ++i) {
            if (Character.isDigit(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public JobGraph findJobGraphOfJob(JobMeta jobMeta) {
        for (TabMapEntry mapEntry : this.spoon.delegates.tabs.getTabs()) {
            JobGraph jobGraph;
            if (!(mapEntry.getObject() instanceof JobGraph) || !(jobGraph = (JobGraph)mapEntry.getObject()).getMeta().equals(jobMeta)) continue;
            return jobGraph;
        }
        return null;
    }

    public boolean addJob(JobMeta jobMeta) {
        int index = this.getJobList().indexOf(jobMeta);
        if (index < 0) {
            this.getJobList().add(jobMeta);
            return true;
        }
        return false;
    }

    public void closeJob(JobMeta jobMeta) {
        TabMapEntry entry = this.getSpoon().delegates.tabs.findTabMapEntry(jobMeta);
        if (entry != null) {
            this.getSpoon().delegates.tabs.removeTab(entry);
        }
        int index = this.getJobList().indexOf(jobMeta);
        while (index >= 0) {
            this.getJobList().remove(index);
            index = this.getJobList().indexOf(jobMeta);
        }
        this.getSpoon().refreshTree();
        this.getSpoon().enableMenus();
    }

    protected Spoon getSpoon() {
        return this.spoon;
    }

    public void addJobGraph(JobMeta jobMeta) {
        boolean added = this.addJob(jobMeta);
        if (added) {
            boolean showLocation = false;
            boolean addTab = true;
            String tabName = this.spoon.delegates.tabs.makeTabName((EngineMetaInterface)jobMeta, showLocation);
            TabMapEntry tabEntry = this.spoon.delegates.tabs.findTabMapEntry(tabName, TabMapEntry.ObjectType.JOB_GRAPH);
            if (tabEntry != null) {
                showLocation = true;
                tabEntry.setShowingLocation(true);
                String newTabName = this.spoon.delegates.tabs.makeTabName(tabEntry.getObject().getMeta(), showLocation);
                tabEntry.getTabItem().setText(newTabName);
                tabName = this.spoon.delegates.tabs.makeTabName((EngineMetaInterface)jobMeta, showLocation);
                tabEntry = this.spoon.delegates.tabs.findTabMapEntry(tabName, TabMapEntry.ObjectType.JOB_GRAPH);
                if (tabEntry != null) {
                    addTab = false;
                }
            }
            if (addTab) {
                JobGraph jobGraph = new JobGraph((Composite)this.spoon.tabfolder.getSwtTabset(), this.spoon, jobMeta);
                PropsUI props = PropsUI.getInstance();
                TabItem tabItem = new TabItem(this.spoon.tabfolder, tabName, tabName, props.getSashWeights());
                String toolTipText = BaseMessages.getString(PKG, (String)"Spoon.TabJob.Tooltip", (String[])new String[]{this.spoon.delegates.tabs.makeTabName((EngineMetaInterface)jobMeta, showLocation)});
                if (!Utils.isEmpty((CharSequence)jobMeta.getFilename())) {
                    toolTipText = toolTipText + Const.CR + Const.CR + jobMeta.getFilename();
                }
                tabItem.setToolTipText(toolTipText);
                tabItem.setImage(GUIResource.getInstance().getImageJobGraph());
                tabItem.setControl((Control)jobGraph);
                if (jobMeta.getJobLogTable().getDatabaseMeta() != null && !Utils.isEmpty((CharSequence)jobMeta.getJobLogTable().getTableName())) {
                    jobGraph.addAllTabs();
                    jobGraph.extraViewTabFolder.setSelection(jobGraph.jobHistoryDelegate.getJobHistoryTab());
                }
                String versionLabel = jobMeta.getObjectRevision() == null ? null : jobMeta.getObjectRevision().getName();
                tabEntry = new TabMapEntry(tabItem, jobMeta.getFilename(), jobMeta.getName(), jobMeta.getRepositoryDirectory(), versionLabel, jobGraph, TabMapEntry.ObjectType.JOB_GRAPH);
                tabEntry.setShowingLocation(showLocation);
                this.spoon.delegates.tabs.addTab(tabEntry);
            }
            int idx = this.spoon.tabfolder.indexOf(tabEntry.getTabItem());
            this.spoon.tabfolder.setSelected(idx);
            this.spoon.setUndoMenu((UndoInterface)jobMeta);
            this.spoon.enableMenus();
        } else {
            TabMapEntry tabEntry = this.spoon.delegates.tabs.findTabMapEntry(jobMeta);
            if (tabEntry != null) {
                int idx = this.spoon.tabfolder.indexOf(tabEntry.getTabItem());
                this.spoon.tabfolder.setSelected(idx);
                this.spoon.tabfolder.setSelected(idx);
                this.spoon.setUndoMenu((UndoInterface)jobMeta);
                this.spoon.enableMenus();
            }
        }
    }

    public List<JobMeta> getJobList() {
        return this.jobMap;
    }

    public JobMeta getJob(String name) {
        TabMapEntry entry = this.spoon.delegates.tabs.findTabMapEntry(name, TabMapEntry.ObjectType.JOB_GRAPH);
        if (entry != null) {
            return (JobMeta)entry.getObject().getManagedObject();
        }
        for (JobMeta jobMeta : this.jobMap) {
            if (name == null || !name.equals(jobMeta.getName())) continue;
            return jobMeta;
        }
        return null;
    }

    public JobMeta[] getLoadedJobs() {
        return this.jobMap.toArray(new JobMeta[this.jobMap.size()]);
    }

    public void removeJob(String key) {
        this.jobMap.remove(key);
    }

    public void redoJobAction(JobMeta jobMeta, TransAction transAction) {
        switch (transAction.getType()) {
            case 17: {
                JobEntryCopy[] si = (JobEntryCopy[])transAction.getCurrent();
                int[] idx = transAction.getCurrentIndex();
                for (int i = 0; i < idx.length; ++i) {
                    jobMeta.addJobEntry(idx[i], si[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 8: {
                NotePadMeta[] ni = (NotePadMeta[])transAction.getCurrent();
                int[] idx = transAction.getCurrentIndex();
                for (int i = 0; i < idx.length; ++i) {
                    jobMeta.addNote(idx[i], ni[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 18: {
                JobHopMeta[] hi = (JobHopMeta[])transAction.getCurrent();
                int[] idx = transAction.getCurrentIndex();
                for (int i = 0; i < idx.length; ++i) {
                    jobMeta.addJobHop(idx[i], hi[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 19: {
                int[] idx = transAction.getCurrentIndex();
                for (int i = idx.length - 1; i >= 0; --i) {
                    jobMeta.removeJobEntry(idx[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 12: {
                int[] idx = transAction.getCurrentIndex();
                for (int i = idx.length - 1; i >= 0; --i) {
                    jobMeta.removeNote(idx[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 20: {
                int[] idx = transAction.getCurrentIndex();
                for (int i = idx.length - 1; i >= 0; --i) {
                    jobMeta.removeJobHop(idx[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 15: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    JobEntryCopy copy = (JobEntryCopy)((JobEntryCopy)transAction.getCurrent()[i]).clone_deep();
                    jobMeta.getJobEntry(transAction.getCurrentIndex()[i]).replaceMeta(copy);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 4: {
                NotePadMeta[] ni = (NotePadMeta[])transAction.getCurrent();
                int[] idx = transAction.getCurrentIndex();
                for (int i = 0; i < idx.length; ++i) {
                    jobMeta.removeNote(idx[i]);
                    jobMeta.addNote(idx[i], ni[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 16: {
                JobHopMeta[] hi = (JobHopMeta[])transAction.getCurrent();
                int[] idx = transAction.getCurrentIndex();
                for (int i = 0; i < idx.length; ++i) {
                    jobMeta.removeJobHop(idx[i]);
                    jobMeta.addJobHop(idx[i], hi[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 21: {
                int[] idx = transAction.getCurrentIndex();
                Point[] p = transAction.getCurrentLocation();
                for (int i = 0; i < p.length; ++i) {
                    JobEntryCopy entry = jobMeta.getJobEntry(idx[i]);
                    entry.setLocation(p[i]);
                }
                this.spoon.refreshGraph();
                break;
            }
            case 14: {
                int[] idx = transAction.getCurrentIndex();
                Point[] curr = transAction.getCurrentLocation();
                for (int i = 0; i < idx.length; ++i) {
                    NotePadMeta npi = jobMeta.getNote(idx[i]);
                    npi.setLocation(curr[i]);
                }
                this.spoon.refreshGraph();
                break;
            }
        }
    }

    public void undoJobAction(JobMeta jobMeta, TransAction transAction) {
        switch (transAction.getType()) {
            case 17: {
                int[] idx = transAction.getCurrentIndex();
                for (int i = idx.length - 1; i >= 0; --i) {
                    jobMeta.removeJobEntry(idx[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 8: {
                int[] idx = transAction.getCurrentIndex();
                for (int i = idx.length - 1; i >= 0; --i) {
                    jobMeta.removeNote(idx[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 18: {
                int[] idx = transAction.getCurrentIndex();
                for (int i = idx.length - 1; i >= 0; --i) {
                    jobMeta.removeJobHop(idx[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 19: {
                JobEntryCopy[] ce = (JobEntryCopy[])transAction.getCurrent();
                int[] idx = transAction.getCurrentIndex();
                for (int i = 0; i < ce.length; ++i) {
                    jobMeta.addJobEntry(idx[i], ce[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 12: {
                NotePadMeta[] ni = (NotePadMeta[])transAction.getCurrent();
                int[] idx = transAction.getCurrentIndex();
                for (int i = 0; i < idx.length; ++i) {
                    jobMeta.addNote(idx[i], ni[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 20: {
                JobHopMeta[] hi = (JobHopMeta[])transAction.getCurrent();
                int[] idx = transAction.getCurrentIndex();
                for (int i = 0; i < hi.length; ++i) {
                    jobMeta.addJobHop(idx[i], hi[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 15: {
                for (int i = 0; i < transAction.getPrevious().length; ++i) {
                    JobEntryCopy copy = (JobEntryCopy)((JobEntryCopy)transAction.getPrevious()[i]).clone();
                    jobMeta.getJobEntry(transAction.getCurrentIndex()[i]).replaceMeta(copy);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 4: {
                NotePadMeta[] prev = (NotePadMeta[])transAction.getPrevious();
                int[] idx = transAction.getCurrentIndex();
                for (int i = 0; i < idx.length; ++i) {
                    jobMeta.removeNote(idx[i]);
                    jobMeta.addNote(idx[i], prev[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 16: {
                JobHopMeta[] prevHops = (JobHopMeta[])transAction.getPrevious();
                int[] idx = transAction.getCurrentIndex();
                for (int i = 0; i < idx.length; ++i) {
                    jobMeta.removeJobHop(idx[i]);
                    jobMeta.addJobHop(idx[i], prevHops[i]);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 21: {
                int[] idx = transAction.getCurrentIndex();
                Point[] p = transAction.getPreviousLocation();
                for (int i = 0; i < p.length; ++i) {
                    JobEntryCopy entry = jobMeta.getJobEntry(idx[i]);
                    entry.setLocation(p[i]);
                }
                this.spoon.refreshGraph();
                break;
            }
            case 14: {
                int[] idx = transAction.getCurrentIndex();
                Point[] prevLoc = transAction.getPreviousLocation();
                for (int i = 0; i < idx.length; ++i) {
                    NotePadMeta npi = jobMeta.getNote(idx[i]);
                    npi.setLocation(prevLoc[i]);
                }
                this.spoon.refreshGraph();
                break;
            }
        }
    }

    public void executeJob(JobMeta jobMeta, boolean local, boolean remote, Date replayDate, boolean safe, String startCopyName, int startCopyNr) throws KettleException {
        if (jobMeta == null) {
            return;
        }
        JobExecutionConfiguration executionConfiguration = this.spoon.getJobExecutionConfiguration();
        Object[] data = this.spoon.variables.getData();
        String[] fields = this.spoon.variables.getRowMeta().getFieldNames();
        HashMap<String, String> variableMap = new HashMap<String, String>();
        for (int idx = 0; idx < fields.length; ++idx) {
            variableMap.put(fields[idx], data[idx].toString());
        }
        executionConfiguration.setVariables(variableMap);
        executionConfiguration.getUsedVariables(jobMeta);
        executionConfiguration.setReplayDate(replayDate);
        executionConfiguration.setRepository(this.spoon.rep);
        executionConfiguration.setSafeModeEnabled(safe);
        executionConfiguration.setStartCopyName(startCopyName);
        executionConfiguration.setStartCopyNr(startCopyNr);
        executionConfiguration.getUsedArguments(jobMeta, this.spoon.getArguments(), (IMetaStore)this.spoon.getMetaStore());
        executionConfiguration.setLogLevel(DefaultLogLevel.getLogLevel());
        JobExecutionConfigurationDialog dialog = new JobExecutionConfigurationDialog(this.spoon.getShell(), executionConfiguration, jobMeta);
        if (!jobMeta.isShowDialog() || dialog.open()) {
            JobGraph jobGraph = this.spoon.getActiveJobGraph();
            jobGraph.jobLogDelegate.addJobLog();
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.SpoonJobMetaExecutionStart.id, (Object)jobMeta);
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.SpoonJobExecutionConfiguration.id, (Object)executionConfiguration);
            try {
                ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.SpoonTransBeforeStart.id, (Object)new Object[]{executionConfiguration, jobMeta, jobMeta, this.spoon.getRepository()});
            }
            catch (KettleException e) {
                this.log.logError(e.getMessage(), new Object[]{jobMeta.getFilename()});
                return;
            }
            if (!executionConfiguration.isExecutingLocally() && !executionConfiguration.isExecutingRemotely() && jobMeta.hasChanged()) {
                jobGraph.showSaveFileMessage();
            }
            for (String varName : executionConfiguration.getVariables().keySet()) {
                String varValue = (String)executionConfiguration.getVariables().get(varName);
                jobMeta.setVariable(varName, varValue);
            }
            for (String paramName : executionConfiguration.getParams().keySet()) {
                String paramValue = (String)executionConfiguration.getParams().get(paramName);
                jobMeta.setParameterValue(paramName, paramValue);
            }
            if (executionConfiguration.isExecutingLocally()) {
                jobGraph.startJob(executionConfiguration);
            } else if (executionConfiguration.isExecutingRemotely()) {
                jobGraph.handleJobMetaChanges(jobMeta);
                jobMeta.activateParameters();
                if (executionConfiguration.getRemoteServer() != null) {
                    Job.sendToSlaveServer((JobMeta)jobMeta, (JobExecutionConfiguration)executionConfiguration, (Repository)this.spoon.rep, (IMetaStore)this.spoon.metaStore);
                    this.spoon.delegates.slaves.addSpoonSlave(executionConfiguration.getRemoteServer());
                } else {
                    MessageBox mb = new MessageBox(this.spoon.getShell(), 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.NoRemoteServerSpecified.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.NoRemoteServerSpecified.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        }
    }
}

