/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.dialog;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.ProgressMonitorAdapter;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.KettleRepositoryLostException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.dialog.TransDialog;
import org.pentaho.di.ui.trans.steps.missing.MissingTransDialog;

public class TransLoadProgressDialog {
    private static Class<?> PKG = TransDialog.class;
    private Shell shell;
    private Repository rep;
    private String transname;
    private RepositoryDirectoryInterface repdir;
    private TransMeta transInfo;
    private ObjectId objectId;
    private String versionLabel;

    public TransLoadProgressDialog(Shell shell, Repository rep, String transname, RepositoryDirectoryInterface repdir, String versionLabel) {
        this.shell = shell;
        this.rep = rep;
        this.transname = transname;
        this.repdir = repdir;
        this.versionLabel = versionLabel;
        this.transInfo = null;
    }

    public TransLoadProgressDialog(Shell shell, Repository rep, ObjectId objectId, String versionLabel) {
        this.shell = shell;
        this.rep = rep;
        this.objectId = objectId;
        this.versionLabel = versionLabel;
        this.transInfo = null;
    }

    public TransMeta open() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                Spoon spoon = Spoon.getInstance();
                try {
                    ExtensionPointHandler.callExtensionPoint((LogChannelInterface)spoon.getLog(), (String)KettleExtensionPoint.TransBeforeOpen.id, (Object)(TransLoadProgressDialog.this.objectId == null ? TransLoadProgressDialog.this.transname : TransLoadProgressDialog.this.objectId.toString()));
                    if (TransLoadProgressDialog.this.objectId != null) {
                        TransLoadProgressDialog.this.transInfo = TransLoadProgressDialog.this.rep.loadTransformation(TransLoadProgressDialog.this.objectId, TransLoadProgressDialog.this.versionLabel);
                    } else {
                        TransLoadProgressDialog.this.transInfo = TransLoadProgressDialog.this.rep.loadTransformation(TransLoadProgressDialog.this.transname, TransLoadProgressDialog.this.repdir, (ProgressMonitorListener)new ProgressMonitorAdapter(monitor), true, TransLoadProgressDialog.this.versionLabel);
                    }
                    ExtensionPointHandler.callExtensionPoint((LogChannelInterface)spoon.getLog(), (String)KettleExtensionPoint.TransAfterOpen.id, (Object)TransLoadProgressDialog.this.transInfo);
                    if (TransLoadProgressDialog.this.transInfo.hasMissingPlugins()) {
                        StepMeta stepMeta = TransLoadProgressDialog.this.transInfo.getStep(0);
                        MissingTransDialog missingTransDialog = new MissingTransDialog(TransLoadProgressDialog.this.shell, TransLoadProgressDialog.this.transInfo.getMissingTrans(), stepMeta.getStepMetaInterface(), TransLoadProgressDialog.this.transInfo, stepMeta.getName());
                        if (missingTransDialog.open() == null) {
                            TransLoadProgressDialog.this.transInfo = null;
                        }
                    }
                }
                catch (KettleException e) {
                    throw new InvocationTargetException(e, BaseMessages.getString((Class)PKG, (String)"TransLoadProgressDialog.Exception.ErrorLoadingTransformation", (String[])new String[0]));
                }
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(true, false, op);
        }
        catch (InvocationTargetException e) {
            KettleRepositoryLostException krle = KettleRepositoryLostException.lookupStackStrace((Throwable)e);
            if (krle != null) {
                throw krle;
            }
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransLoadProgressDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLoadProgressDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), e);
            this.transInfo = null;
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransLoadProgressDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLoadProgressDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), e);
            this.transInfo = null;
        }
        return this.transInfo;
    }
}

