/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ConditionalResolverSkewJoin;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public final class GenMRSkewJoinProcessor {
    private static String skewJoinPrefix = "hive_skew_join";
    private static String UNDERLINE = "_";
    private static String BIGKEYS = "bigkeys";
    private static String SMALLKEYS = "smallkeys";
    private static String RESULTS = "results";

    private GenMRSkewJoinProcessor() {
    }

    public static void processSkewJoin(JoinOperator joinOp, Task<? extends Serializable> currTask, ParseContext parseCtx) throws SemanticException {
        int i;
        if (!GenMRSkewJoinProcessor.skewJoinEnabled(parseCtx.getConf(), joinOp)) {
            return;
        }
        List<Task<Serializable>> children = currTask.getChildTasks();
        if (children != null && children.size() > 1) {
            throw new SemanticException("Should not happened");
        }
        Task<Serializable> child = children != null && children.size() == 1 ? children.get(0) : null;
        Path baseTmpDir = parseCtx.getContext().getMRTmpPath();
        JoinDesc joinDescriptor = (JoinDesc)joinOp.getConf();
        Map<Byte, List<ExprNodeDesc>> joinValues = joinDescriptor.getExprs();
        int numAliases = joinValues.size();
        HashMap<Byte, Path> bigKeysDirMap = new HashMap<Byte, Path>();
        HashMap<Byte, Map<Byte, Path>> smallKeysDirMap = new HashMap<Byte, Map<Byte, Path>>();
        HashMap<Byte, Path> skewJoinJobResultsDir = new HashMap<Byte, Path>();
        Byte[] tags = joinDescriptor.getTagOrder();
        for (int i2 = 0; i2 < numAliases; ++i2) {
            Byte alias = tags[i2];
            bigKeysDirMap.put(alias, GenMRSkewJoinProcessor.getBigKeysDir(baseTmpDir, alias));
            HashMap<Byte, Path> smallKeysMap = new HashMap<Byte, Path>();
            smallKeysDirMap.put(alias, smallKeysMap);
            for (Byte src2 : tags) {
                if (src2.equals(alias)) continue;
                smallKeysMap.put(src2, GenMRSkewJoinProcessor.getSmallKeysDir(baseTmpDir, alias, src2));
            }
            skewJoinJobResultsDir.put(alias, GenMRSkewJoinProcessor.getBigKeysSkewJoinResultDir(baseTmpDir, alias));
        }
        joinDescriptor.setHandleSkewJoin(true);
        joinDescriptor.setBigKeysDirMap(bigKeysDirMap);
        joinDescriptor.setSmallKeysDirMap(smallKeysDirMap);
        joinDescriptor.setSkewKeyDefinition(HiveConf.getIntVar(parseCtx.getConf(), HiveConf.ConfVars.HIVESKEWJOINKEY));
        HashMap<Path, Task<? extends Serializable>> bigKeysDirToTaskMap = new HashMap<Path, Task<? extends Serializable>>();
        ArrayList<MapredWork> listWorks = new ArrayList<MapredWork>();
        ArrayList<Task<? extends Serializable>> listTasks = new ArrayList<Task<? extends Serializable>>();
        MapredWork currPlan = (MapredWork)currTask.getWork();
        TableDesc keyTblDesc = (TableDesc)currPlan.getReduceWork().getKeyDesc().clone();
        List<String> joinKeys = Utilities.getColumnNames(keyTblDesc.getProperties());
        List<String> joinKeyTypes = Utilities.getColumnTypes(keyTblDesc.getProperties());
        HashMap<Byte, TableDesc> tableDescList = new HashMap<Byte, TableDesc>();
        HashMap<Byte, RowSchema> rowSchemaList = new HashMap<Byte, RowSchema>();
        HashMap<Byte, List<ExprNodeDesc>> newJoinValues = new HashMap<Byte, List<ExprNodeDesc>>();
        HashMap<Byte, List<ExprNodeDesc>> newJoinKeys = new HashMap<Byte, List<ExprNodeDesc>>();
        ArrayList<TableDesc> newJoinValueTblDesc = new ArrayList<TableDesc>();
        for (Byte tag : tags) {
            newJoinValueTblDesc.add(null);
        }
        for (i = 0; i < numAliases; ++i) {
            int k;
            Byte by = tags[i];
            List<ExprNodeDesc> valueCols = joinValues.get(by);
            String colNames = "";
            String colTypes = "";
            int columnSize = valueCols.size();
            ArrayList<ExprNodeColumnDesc> newValueExpr = new ArrayList<ExprNodeColumnDesc>();
            ArrayList<ExprNodeColumnDesc> newKeyExpr = new ArrayList<ExprNodeColumnDesc>();
            ArrayList<ColumnInfo> columnInfos = new ArrayList<ColumnInfo>();
            boolean first = true;
            for (k = 0; k < columnSize; ++k) {
                TypeInfo type = valueCols.get(k).getTypeInfo();
                String newColName = i + "_VALUE_" + k;
                ColumnInfo columnInfo = new ColumnInfo(newColName, type, by.toString(), false);
                columnInfos.add(columnInfo);
                newValueExpr.add(new ExprNodeColumnDesc(columnInfo));
                if (!first) {
                    colNames = colNames + ",";
                    colTypes = colTypes + ",";
                }
                first = false;
                colNames = colNames + newColName;
                colTypes = colTypes + valueCols.get(k).getTypeString();
            }
            for (k = 0; k < joinKeys.size(); ++k) {
                if (!first) {
                    colNames = colNames + ",";
                    colTypes = colTypes + ",";
                }
                first = false;
                colNames = colNames + joinKeys.get(k);
                colTypes = colTypes + joinKeyTypes.get(k);
                ColumnInfo columnInfo = new ColumnInfo(joinKeys.get(k), TypeInfoFactory.getPrimitiveTypeInfo(joinKeyTypes.get(k)), by.toString(), false);
                columnInfos.add(columnInfo);
                newKeyExpr.add(new ExprNodeColumnDesc(columnInfo));
            }
            newJoinValues.put(by, newValueExpr);
            newJoinKeys.put(by, newKeyExpr);
            tableDescList.put(by, Utilities.getTableDesc(colNames, colTypes));
            rowSchemaList.put(by, new RowSchema(columnInfos));
            String valueColNames = "";
            String valueColTypes = "";
            first = true;
            for (int k2 = 0; k2 < columnSize; ++k2) {
                String newColName = i + "_VALUE_" + k2;
                if (!first) {
                    valueColNames = valueColNames + ",";
                    valueColTypes = valueColTypes + ",";
                }
                valueColNames = valueColNames + newColName;
                valueColTypes = valueColTypes + valueCols.get(k2).getTypeString();
                first = false;
            }
            newJoinValueTblDesc.set(Byte.valueOf((byte)i).byteValue(), Utilities.getTableDesc(valueColNames, valueColTypes));
        }
        joinDescriptor.setSkewKeysValuesTables(tableDescList);
        joinDescriptor.setKeyTableDesc(keyTblDesc);
        for (i = 0; i < numAliases - 1; ++i) {
            Byte by = tags[i];
            MapWork newPlan = PlanUtils.getMapRedWork().getMapWork();
            boolean mapperCannotSpanPartns = parseCtx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_MAPPER_CANNOT_SPAN_MULTIPLE_PARTITIONS);
            newPlan.setMapperCannotSpanPartns(mapperCannotSpanPartns);
            MapredWork clonePlan = Utilities.clonePlan(currPlan);
            Operator[] parentOps = new TableScanOperator[tags.length];
            for (int k = 0; k < tags.length; ++k) {
                TableScanOperator ts = GenMapRedUtils.createTemporaryTableScanOperator((RowSchema)rowSchemaList.get((byte)k));
                ts.setTableDesc((TableDesc)tableDescList.get((byte)k));
                parentOps[k] = ts;
            }
            TableScanOperator tblScan_op = parentOps[i];
            ArrayList<String> aliases = new ArrayList<String>();
            String alias = by.toString().intern();
            aliases.add(alias);
            Path bigKeyDirPath = (Path)bigKeysDirMap.get(by);
            newPlan.getPathToAliases().put(bigKeyDirPath.toString().intern(), aliases);
            newPlan.getAliasToWork().put(alias, tblScan_op);
            PartitionDesc part = new PartitionDesc((TableDesc)tableDescList.get(by), null);
            newPlan.getPathToPartitionInfo().put(bigKeyDirPath.toString(), part);
            newPlan.getAliasToPartnInfo().put(alias, part);
            Operator<?> reducer = clonePlan.getReduceWork().getReducer();
            assert (reducer instanceof JoinOperator);
            JoinOperator cloneJoinOp = (JoinOperator)reducer;
            String dumpFilePrefix = "mapfile" + PlanUtils.getCountForMapJoinDumpFilePrefix();
            MapJoinDesc mapJoinDescriptor = new MapJoinDesc(newJoinKeys, keyTblDesc, newJoinValues, newJoinValueTblDesc, newJoinValueTblDesc, joinDescriptor.getOutputColumnNames(), i, joinDescriptor.getConds(), joinDescriptor.getFilters(), joinDescriptor.getNoOuterJoin(), dumpFilePrefix);
            mapJoinDescriptor.setTagOrder(tags);
            mapJoinDescriptor.setHandleSkewJoin(false);
            mapJoinDescriptor.setNullSafes(joinDescriptor.getNullSafes());
            MapredLocalWork localPlan = new MapredLocalWork(new LinkedHashMap<String, Operator<? extends OperatorDesc>>(), new LinkedHashMap<String, FetchWork>());
            Map smallTblDirs = (Map)smallKeysDirMap.get(by);
            for (int j = 0; j < numAliases; ++j) {
                if (j == i) continue;
                Byte small_alias = tags[j];
                Operator tblScan_op2 = parentOps[j];
                localPlan.getAliasToWork().put(small_alias.toString(), tblScan_op2);
                Path path = (Path)smallTblDirs.get(small_alias);
                localPlan.getAliasToFetchWork().put(small_alias.toString(), new FetchWork(path, (TableDesc)tableDescList.get(small_alias)));
            }
            newPlan.setMapRedLocalWork(localPlan);
            MapJoinOperator mapJoinOp = (MapJoinOperator)OperatorFactory.getAndMakeChild(mapJoinDescriptor, (RowSchema)null, parentOps);
            List<Operator<? extends OperatorDesc>> childOps = cloneJoinOp.getChildOperators();
            for (Operator<OperatorDesc> operator : childOps) {
                operator.replaceParent(cloneJoinOp, mapJoinOp);
            }
            mapJoinOp.setChildOperators(childOps);
            HiveConf jc = new HiveConf(parseCtx.getConf(), GenMRSkewJoinProcessor.class);
            newPlan.setNumMapTasks(HiveConf.getIntVar(jc, HiveConf.ConfVars.HIVESKEWJOINMAPJOINNUMMAPTASK));
            newPlan.setMinSplitSize(HiveConf.getLongVar(jc, HiveConf.ConfVars.HIVESKEWJOINMAPJOINMINSPLIT));
            newPlan.setInputformat(HiveInputFormat.class.getName());
            MapredWork mapredWork = new MapredWork();
            mapredWork.setMapWork(newPlan);
            Task<MapredWork> skewJoinMapJoinTask = TaskFactory.get(mapredWork, jc, new Task[0]);
            skewJoinMapJoinTask.setFetchSource(currTask.isFetchSource());
            bigKeysDirToTaskMap.put(bigKeyDirPath, skewJoinMapJoinTask);
            listWorks.add(skewJoinMapJoinTask.getWork());
            listTasks.add(skewJoinMapJoinTask);
        }
        if (children != null) {
            for (Task task : listTasks) {
                for (Task<Serializable> oldChild : children) {
                    task.addDependentTask(oldChild);
                }
            }
        }
        if (child != null) {
            currTask.removeDependentTask(child);
            listTasks.add(child);
        }
        ConditionalResolverSkewJoin.ConditionalResolverSkewJoinCtx context = new ConditionalResolverSkewJoin.ConditionalResolverSkewJoinCtx(bigKeysDirToTaskMap, child);
        ConditionalWork conditionalWork = new ConditionalWork(listWorks);
        ConditionalTask cndTsk = (ConditionalTask)TaskFactory.get(conditionalWork, parseCtx.getConf(), new Task[0]);
        cndTsk.setListTasks(listTasks);
        cndTsk.setResolver(new ConditionalResolverSkewJoin());
        cndTsk.setResolverCtx(context);
        currTask.setChildTasks(new ArrayList<Task<? extends Serializable>>());
        currTask.addDependentTask(cndTsk);
    }

    public static boolean skewJoinEnabled(HiveConf conf, JoinOperator joinOp) {
        if (conf != null && !conf.getBoolVar(HiveConf.ConfVars.HIVESKEWJOIN)) {
            return false;
        }
        if (!((JoinDesc)joinOp.getConf()).isNoOuterJoin()) {
            return false;
        }
        byte pos = 0;
        for (Byte tag : ((JoinDesc)joinOp.getConf()).getTagOrder()) {
            if (tag != pos) {
                return false;
            }
            pos = (byte)(pos + 1);
        }
        return true;
    }

    static Path getBigKeysDir(Path baseDir, Byte srcTbl) {
        return StringInternUtils.internUriStringsInPath(new Path(baseDir, skewJoinPrefix + UNDERLINE + BIGKEYS + UNDERLINE + srcTbl));
    }

    static Path getBigKeysSkewJoinResultDir(Path baseDir, Byte srcTbl) {
        return StringInternUtils.internUriStringsInPath(new Path(baseDir, skewJoinPrefix + UNDERLINE + BIGKEYS + UNDERLINE + RESULTS + UNDERLINE + srcTbl));
    }

    static Path getSmallKeysDir(Path baseDir, Byte srcTblBigTbl, Byte srcTblSmallTbl) {
        return StringInternUtils.internUriStringsInPath(new Path(baseDir, skewJoinPrefix + UNDERLINE + SMALLKEYS + UNDERLINE + srcTblBigTbl + UNDERLINE + srcTblSmallTbl));
    }
}

