/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.AbstractSnmpUtility;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableListener;

public class TableUtils
extends AbstractSnmpUtility {
    private static final LogAdapter logger = LogFactory.getLogger(TableUtils.class);
    public static final int ROWSTATUS_ACTIVE = 1;
    public static final int ROWSTATUS_NOTINSERVICE = 2;
    public static final int ROWSTATUS_NOTREADY = 3;
    public static final int ROWSTATUS_CREATEANDGO = 4;
    public static final int ROWSTATUS_CREATEANDWAIT = 5;
    public static final int ROWSTATUS_DESTROY = 6;
    private int maxNumOfRowsPerPDU = 10;
    private int maxNumColumnsPerPDU = 10;

    public TableUtils(Session session, PDUFactory pDUFactory) {
        super(session, pDUFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTable(Target target, OID[] oIDArray, OID oID, OID oID2) {
        if (oIDArray == null || oIDArray.length == 0) {
            throw new IllegalArgumentException("No column OIDs specified");
        }
        InternalTableListener internalTableListener = new InternalTableListener();
        TableRequest tableRequest = this.createTableRequest(target, oIDArray, internalTableListener, null, oID, oID2);
        InternalTableListener internalTableListener2 = internalTableListener;
        synchronized (internalTableListener2) {
            if (tableRequest.sendNextChunk()) {
                try {
                    internalTableListener.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return internalTableListener.getRows();
    }

    protected TableRequest createTableRequest(Target target, OID[] oIDArray, TableListener tableListener, Object object, OID oID, OID oID2) {
        return new TableRequest(target, oIDArray, tableListener, object, oID, oID2);
    }

    public void getTable(Target target, OID[] oIDArray, TableListener tableListener, Object object, OID oID, OID oID2) {
        if (oIDArray == null || oIDArray.length == 0) {
            throw new IllegalArgumentException("No column OIDs specified");
        }
        TableRequest tableRequest = new TableRequest(target, oIDArray, tableListener, object, oID, oID2);
        tableRequest.sendNextChunk();
    }

    public void getDenseTable(Target target, OID[] oIDArray, TableListener tableListener, Object object, OID oID, OID oID2) {
        if (oIDArray == null || oIDArray.length == 0) {
            throw new IllegalArgumentException("No column OIDs specified");
        }
        TableRequest tableRequest = new TableRequest(target, oIDArray, tableListener, object, oID, oID2);
        tableRequest.sendNextChunk();
    }

    public int getMaxNumRowsPerPDU() {
        return this.maxNumOfRowsPerPDU;
    }

    public void setMaxNumRowsPerPDU(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The number of rows per PDU must be > 0");
        }
        this.maxNumOfRowsPerPDU = n;
    }

    public int getMaxNumColumnsPerPDU() {
        return this.maxNumColumnsPerPDU;
    }

    public void setMaxNumColumnsPerPDU(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The number of columns per PDU must be > 0");
        }
        this.maxNumColumnsPerPDU = n;
    }

    public ResponseEvent createRow(Target target, OID oID, OID oID2, VariableBinding[] variableBindingArray) {
        PDU pDU = this.pduFactory.createPDU(target);
        OID oID3 = new OID(oID);
        oID3.append(oID2);
        VariableBinding variableBinding = new VariableBinding(oID3);
        if (variableBindingArray != null) {
            variableBinding.setVariable(new Integer32(4));
        } else {
            variableBinding.setVariable(new Integer32(5));
        }
        pDU.add(variableBinding);
        if (variableBindingArray != null) {
            for (int i = 0; i < variableBindingArray.length; ++i) {
                OID oID4 = new OID(variableBindingArray[i].getOid());
                oID4.append(oID2);
                variableBindingArray[i].setOid(oID4);
            }
            pDU.addAll(variableBindingArray);
        }
        pDU.setType(-93);
        try {
            ResponseEvent responseEvent = this.session.send(pDU, target);
            return responseEvent;
        }
        catch (IOException iOException) {
            logger.error(iOException);
            return null;
        }
    }

    public ResponseEvent destroyRow(Target target, OID oID, OID oID2) {
        PDU pDU = this.pduFactory.createPDU(target);
        OID oID3 = new OID(oID);
        oID3.append(oID2);
        VariableBinding variableBinding = new VariableBinding(oID3);
        variableBinding.setVariable(new Integer32(6));
        pDU.add(variableBinding);
        pDU.setType(-93);
        try {
            ResponseEvent responseEvent = this.session.send(pDU, target);
            return responseEvent;
        }
        catch (IOException iOException) {
            logger.error(iOException);
            return null;
        }
    }

    class InternalTableListener
    implements TableListener {
        private List rows = new LinkedList();

        InternalTableListener() {
        }

        public boolean next(TableEvent tableEvent) {
            this.rows.add(tableEvent);
            return true;
        }

        public synchronized void finished(TableEvent tableEvent) {
            if (tableEvent.getStatus() != 0 || tableEvent.getIndex() != null) {
                this.rows.add(tableEvent);
            }
            this.notify();
        }

        public List getRows() {
            return this.rows;
        }
    }

    class Row
    extends Vector {
        private static final long serialVersionUID = -2297277440117636627L;
        private OID index;

        public Row(OID oID) {
            this.index = oID;
        }

        public OID getRowIndex() {
            return this.index;
        }

        public int getNumComplete() {
            return super.size();
        }

        public boolean setNumComplete(int n) {
            int n2 = n - this.getNumComplete();
            for (int i = 0; i < n2; ++i) {
                super.add(null);
            }
            return n2 >= 0;
        }
    }

    class DenseTableRequest
    extends TableRequest {
        protected DenseTableRequest(Target target, OID[] oIDArray, TableListener tableListener, Object object, OID oID, OID oID2) {
            super(target, oIDArray, tableListener, object, oID, oID2);
        }

        public synchronized void onResponse(ResponseEvent responseEvent) {
            TableUtils.this.session.cancel(responseEvent.getRequest(), this);
            if (this.finished) {
                return;
            }
            if (this.checkResponse(responseEvent)) {
                int n = (Integer)responseEvent.getUserObject();
                PDU pDU = responseEvent.getRequest();
                PDU pDU2 = responseEvent.getResponse();
                int n2 = pDU.size();
                int n3 = pDU2.size() / n2;
                OID oID = null;
                for (int i = 0; i < n3; ++i) {
                    Row row = null;
                    for (int j = 0; j < pDU.size(); ++j) {
                        OID oID2;
                        OID oID3;
                        int n4 = n + j;
                        VariableBinding variableBinding = pDU2.get(i * n2 + j);
                        if (variableBinding.isException() || !(oID3 = variableBinding.getOid()).startsWith(oID2 = this.columnOIDs[n4])) continue;
                        OID oID4 = new OID(oID3.getValue(), oID2.size(), oID3.size() - oID2.size());
                        if (this.upperBoundIndex != null && oID4.compareTo(this.upperBoundIndex) > 0) continue;
                        if (oID == null || oID4.compareTo(oID) < 0) {
                            oID = oID4;
                        }
                        if (row == null) {
                            row = new Row(oID4);
                        }
                        row.setNumComplete(n4);
                        if (n4 < row.getNumComplete()) {
                            row.set(n4, variableBinding);
                        } else {
                            row.add(variableBinding);
                        }
                        this.lastReceived.set(n4, variableBinding.getOid());
                    }
                    if (row == null || this.listener.next(new TableEvent(this, this.userObject, row.getRowIndex(), row.toArray(new VariableBinding[0])))) continue;
                    this.finished = true;
                    this.listener.finished(new TableEvent(this, this.userObject));
                    return;
                }
                if (!this.sendNextChunk()) {
                    this.finished = true;
                    this.listener.finished(new TableEvent(this, this.userObject));
                }
            }
        }
    }

    public class TableRequest
    implements ResponseListener {
        Target target;
        OID[] columnOIDs;
        TableListener listener;
        Object userObject;
        OID lowerBoundIndex;
        OID upperBoundIndex;
        private int sent = 0;
        private boolean anyMatch = false;
        private Vector lastSent = null;
        private LinkedList rowCache = new LinkedList();
        protected Vector lastReceived;
        volatile boolean finished = false;

        public TableRequest(Target target, OID[] oIDArray, TableListener tableListener, Object object, OID oID, OID oID2) {
            this.target = target;
            this.columnOIDs = oIDArray;
            this.listener = tableListener;
            this.userObject = object;
            this.lastReceived = new Vector<OID>(Arrays.asList(oIDArray));
            this.upperBoundIndex = oID2;
            this.lowerBoundIndex = oID;
            if (oID != null) {
                for (int i = 0; i < this.lastReceived.size(); ++i) {
                    OID oID3 = new OID((OID)this.lastReceived.get(i));
                    oID3.append(oID);
                    this.lastReceived.set(i, oID3);
                }
            }
        }

        public boolean sendNextChunk() {
            if (this.sent >= this.lastReceived.size()) {
                return false;
            }
            PDU pDU = TableUtils.this.pduFactory.createPDU(this.target);
            if (this.target.getVersion() == 0) {
                pDU.setType(-95);
            } else {
                pDU.setType(-91);
            }
            int n = Math.min(this.lastReceived.size() - this.sent, TableUtils.this.maxNumColumnsPerPDU);
            if (pDU.getType() == -91) {
                if (TableUtils.this.maxNumOfRowsPerPDU > 0) {
                    pDU.setMaxRepetitions(TableUtils.this.maxNumOfRowsPerPDU);
                    pDU.setNonRepeaters(0);
                } else {
                    pDU.setNonRepeaters(n);
                    pDU.setMaxRepetitions(0);
                }
            }
            this.lastSent = new Vector(n + 1);
            for (int i = this.sent; i < this.sent + n; ++i) {
                OID oID = (OID)this.lastReceived.get(i);
                VariableBinding variableBinding = new VariableBinding(oID);
                pDU.add(variableBinding);
                if (pDU.getBERLength() > this.target.getMaxSizeRequestPDU()) {
                    pDU.trim();
                    break;
                }
                this.lastSent.add(this.lastReceived.get(i));
            }
            try {
                Integer n2 = new Integer(this.sent);
                this.sent += pDU.size();
                this.sendRequest(pDU, this.target, n2);
            }
            catch (Exception exception) {
                logger.error(exception);
                if (logger.isDebugEnabled()) {
                    exception.printStackTrace();
                }
                this.listener.finished(new TableEvent((Object)this, this.userObject, exception));
                return false;
            }
            return true;
        }

        protected void sendRequest(PDU pDU, Target target, Integer n) throws IOException {
            TableUtils.this.session.send(pDU, target, n, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(ResponseEvent responseEvent) {
            TableUtils.this.session.cancel(responseEvent.getRequest(), this);
            if (this.finished) {
                return;
            }
            TableRequest tableRequest = this;
            synchronized (tableRequest) {
                if (this.checkResponse(responseEvent)) {
                    boolean bl = false;
                    int n = (Integer)responseEvent.getUserObject();
                    PDU pDU = responseEvent.getRequest();
                    PDU pDU2 = responseEvent.getResponse();
                    int n2 = pDU.size();
                    int n3 = pDU2.size() / n2;
                    OID oID = null;
                    for (int i = 0; i < n3; ++i) {
                        Row row = null;
                        bl = false;
                        for (int j = 0; j < pDU.size(); ++j) {
                            Row row2;
                            ListIterator<Row> listIterator;
                            OID oID2;
                            OID oID3;
                            int n4 = n + j;
                            VariableBinding variableBinding = pDU2.get(i * n2 + j);
                            if (variableBinding.isException() || !(oID3 = variableBinding.getOid()).startsWith(oID2 = this.columnOIDs[n4])) continue;
                            OID oID4 = new OID(oID3.getValue(), oID2.size(), oID3.size() - oID2.size());
                            if (this.upperBoundIndex != null && oID4.compareTo(this.upperBoundIndex) > 0) continue;
                            if (oID == null || oID4.compareTo(oID) < 0) {
                                oID = oID4;
                            }
                            bl = true;
                            if (row == null || !row.getRowIndex().equals(oID4)) {
                                row = null;
                                listIterator = this.rowCache.listIterator(this.rowCache.size());
                                while (listIterator.hasPrevious()) {
                                    row2 = (Row)listIterator.previous();
                                    int n5 = oID4.compareTo(row2.getRowIndex());
                                    if (n5 == 0) {
                                        row = row2;
                                        break;
                                    }
                                    if (n5 <= 0) continue;
                                    break;
                                }
                            }
                            if (row == null) {
                                row = new Row(oID4);
                                if (this.rowCache.size() == 0) {
                                    this.rowCache.add(row);
                                } else if (((Row)this.rowCache.getFirst()).getRowIndex().compareTo(oID4) >= 0) {
                                    this.rowCache.addFirst(row);
                                } else {
                                    listIterator = this.rowCache.listIterator(this.rowCache.size());
                                    while (listIterator.hasPrevious()) {
                                        row2 = (Row)listIterator.previous();
                                        if (oID4.compareTo(row2.index) < 0) continue;
                                        listIterator.set(row);
                                        listIterator.add(row2);
                                        break;
                                    }
                                }
                            }
                            if (!(row.setNumComplete(n4) && row.size() <= n4 || row.get(n4) == null)) {
                                this.finished = true;
                                this.listener.finished(new TableEvent((Object)this, this.userObject, -2));
                                return;
                            }
                            row.setNumComplete(n4);
                            if (n4 < row.getNumComplete()) {
                                row.set(n4, variableBinding);
                            } else {
                                row.add(variableBinding);
                            }
                            this.lastReceived.set(n4, variableBinding.getOid());
                        }
                    }
                    this.anyMatch |= bl;
                    while (this.rowCache.size() > 0 && ((Row)this.rowCache.getFirst()).getNumComplete() == this.columnOIDs.length && (oID == null || ((Row)this.rowCache.getFirst()).getRowIndex().compareTo(oID) < 0)) {
                        if (this.listener.next(this.getTableEvent())) continue;
                        this.finished = true;
                        this.listener.finished(new TableEvent(this, this.userObject));
                        return;
                    }
                    if (!this.sendNextChunk()) {
                        if (this.anyMatch) {
                            this.sent = 0;
                            this.anyMatch = false;
                            this.sendNextChunk();
                        } else {
                            this.emptyCache();
                            this.finished = true;
                            this.listener.finished(new TableEvent(this, this.userObject));
                        }
                    }
                }
            }
        }

        protected boolean checkResponse(ResponseEvent responseEvent) {
            if (responseEvent.getError() != null) {
                this.finished = true;
                this.emptyCache();
                this.listener.finished(new TableEvent((Object)this, this.userObject, responseEvent.getError()));
            } else if (responseEvent.getResponse() == null) {
                this.finished = true;
                this.emptyCache();
                this.listener.finished(new TableEvent((Object)this, this.userObject, -1));
            } else if (responseEvent.getResponse().getType() == -88) {
                this.finished = true;
                this.emptyCache();
                this.listener.finished(new TableEvent((Object)this, this.userObject, responseEvent.getResponse()));
            } else if (responseEvent.getResponse().getErrorStatus() != 0) {
                this.finished = true;
                this.emptyCache();
                this.listener.finished(new TableEvent((Object)this, this.userObject, responseEvent.getResponse().getErrorStatus()));
            } else {
                return true;
            }
            return false;
        }

        private void emptyCache() {
            while (this.rowCache.size() > 0 && this.listener.next(this.getTableEvent())) {
            }
        }

        private TableEvent getTableEvent() {
            Row row = (Row)this.rowCache.removeFirst();
            row.setNumComplete(this.columnOIDs.length);
            Object[] objectArray = new VariableBinding[row.size()];
            row.copyInto(objectArray);
            return new TableEvent(this, this.userObject, row.getRowIndex(), (VariableBinding[])objectArray);
        }

        public Row getRow(OID oID) {
            ListIterator listIterator = this.rowCache.listIterator(this.rowCache.size() + 1);
            while (listIterator.hasPrevious()) {
                Row row = (Row)listIterator.previous();
                if (!oID.equals(row.getRowIndex())) continue;
                return row;
            }
            return null;
        }
    }
}

