/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import com.pentaho.di.services.PentahoDiPlugin;
import com.pentaho.pdi.ws.IRepositorySyncWebService;
import com.pentaho.pdi.ws.RepositorySyncException;
import com.sun.xml.ws.client.ClientTransportException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang.BooleanUtils;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleSecurityException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.ExecutorUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.IRepositoryService;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.repository.RepositorySecurityProvider;
import org.pentaho.di.repository.pur.AbsSecurityManager;
import org.pentaho.di.repository.pur.AbsSecurityProvider;
import org.pentaho.di.repository.pur.IRepositoryConnector;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.repository.pur.PurRepositoryMeta;
import org.pentaho.di.repository.pur.PurRepositorySecurityManager;
import org.pentaho.di.repository.pur.PurRepositorySecurityProvider;
import org.pentaho.di.repository.pur.RepositoryConnectResult;
import org.pentaho.di.repository.pur.RepositoryServiceRegistry;
import org.pentaho.di.repository.pur.RootRef;
import org.pentaho.di.repository.pur.ServiceManager;
import org.pentaho.di.repository.pur.UnifiedRepositoryConnectionAclService;
import org.pentaho.di.repository.pur.UnifiedRepositoryLockService;
import org.pentaho.di.repository.pur.UnifiedRepositoryRevisionService;
import org.pentaho.di.repository.pur.UnifiedRepositoryTrashService;
import org.pentaho.di.repository.pur.WebServiceManager;
import org.pentaho.di.repository.pur.model.EEUserInfo;
import org.pentaho.di.ui.repository.pur.services.IAbsSecurityManager;
import org.pentaho.di.ui.repository.pur.services.IAbsSecurityProvider;
import org.pentaho.di.ui.repository.pur.services.IAclService;
import org.pentaho.di.ui.repository.pur.services.IConnectionAclService;
import org.pentaho.di.ui.repository.pur.services.ILockService;
import org.pentaho.di.ui.repository.pur.services.IRevisionService;
import org.pentaho.di.ui.repository.pur.services.IRoleSupportSecurityManager;
import org.pentaho.di.ui.repository.pur.services.ITrashService;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.webservices.jaxws.IUnifiedRepositoryJaxwsWebService;
import org.pentaho.platform.repository2.unified.webservices.jaxws.UnifiedRepositoryToWebServiceAdapter;

public class PurRepositoryConnector
implements IRepositoryConnector {
    private static final String SINGLE_DI_SERVER_INSTANCE = "singleDiServerInstance";
    private static final String REMOTE_DI_SERVER_INSTANCE = "remoteDiServerInstance";
    private static Class<?> PKG = PurRepository.class;
    private final LogChannelInterface log = new LogChannel((Object)this.getClass().getSimpleName());
    private final PurRepository purRepository;
    private final PurRepositoryMeta repositoryMeta;
    private final RootRef rootRef;
    private ServiceManager serviceManager;

    public PurRepositoryConnector(PurRepository purRepository, PurRepositoryMeta repositoryMeta, RootRef rootRef) {
        if (purRepository != null & purRepository.getLog() != null) {
            this.log.setLogLevel(purRepository.getLog().getLogLevel());
        }
        this.purRepository = purRepository;
        this.repositoryMeta = repositoryMeta;
        this.rootRef = rootRef;
    }

    private boolean allowedActionsContains(AbsSecurityProvider provider, String action) throws KettleException {
        List<String> allowedActions = provider.getAllowedActions("org.pentaho");
        for (String actionName : allowedActions) {
            if (action == null || !action.equals(actionName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized RepositoryConnectResult connect(final String username, String password) throws KettleException, KettleSecurityException {
        if (this.serviceManager != null) {
            this.disconnect();
        }
        this.serviceManager = new WebServiceManager(this.repositoryMeta.getRepositoryLocation().getUrl(), username);
        RepositoryServiceRegistry purRepositoryServiceRegistry = new RepositoryServiceRegistry();
        EEUserInfo user1 = new EEUserInfo();
        final String decryptedPassword = Encr.decryptPasswordOptionallyEncrypted((String)password);
        final RepositoryConnectResult result = new RepositoryConnectResult(purRepositoryServiceRegistry);
        try {
            user1.setLogin(username);
            user1.setPassword(decryptedPassword);
            user1.setName(username);
            result.setUser(user1);
            if (PentahoSystem.getApplicationContext() != null && PentahoSessionHolder.getSession() != null && PentahoSessionHolder.getSession().isAuthenticated() && PurRepositoryConnector.inProcess()) {
                result.setUnifiedRepository((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
                if (result.getUnifiedRepository() != null) {
                    if (this.log.isDebug()) {
                        this.log.logDebug("begin connectInProcess()");
                    }
                    String name = PentahoSessionHolder.getSession().getName();
                    user1 = new EEUserInfo();
                    user1.setLogin(name);
                    user1.setName(name);
                    user1.setPassword(decryptedPassword);
                    result.setUser(user1);
                    result.setSuccess(true);
                    if (this.log.isDebug()) {
                        this.log.logDebug("connected in process as '" + name + "' pur repository = " + result.getUnifiedRepository());
                    }
                    return result;
                }
            }
            ExecutorService executor = ExecutorUtil.getExecutor();
            Future<Boolean> authorizationWebserviceFuture = executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    if (PurRepositoryConnector.this.log.isBasic()) {
                        PurRepositoryConnector.this.log.logBasic(BaseMessages.getString((Class)PKG, (String)"PurRepositoryConnector.CreateServiceProvider.Start", (String[])new String[0]));
                    }
                    result.setSecurityProvider(new AbsSecurityProvider(PurRepositoryConnector.this.purRepository, PurRepositoryConnector.this.repositoryMeta, result.getUser(), PurRepositoryConnector.this.serviceManager));
                    if (PurRepositoryConnector.this.log.isBasic()) {
                        PurRepositoryConnector.this.log.logBasic(BaseMessages.getString((Class)PKG, (String)"PurRepositoryConnector.CreateServiceProvider.End", (String[])new String[0]));
                    }
                    if (PurRepositoryConnector.this.allowedActionsContains((AbsSecurityProvider)result.getSecurityProvider(), "org.pentaho.security.administerSecurity")) {
                        result.setSecurityManager(new AbsSecurityManager(PurRepositoryConnector.this.purRepository, PurRepositoryConnector.this.repositoryMeta, result.getUser(), PurRepositoryConnector.this.serviceManager));
                        ((PurRepositorySecurityProvider)result.getSecurityProvider()).setUserRoleDelegate(((PurRepositorySecurityManager)result.getSecurityManager()).getUserRoleDelegate());
                        return true;
                    }
                    return false;
                }
            });
            Future<WebServiceException> repoWebServiceFuture = executor.submit(new Callable<WebServiceException>(){

                @Override
                public WebServiceException call() throws Exception {
                    try {
                        IUnifiedRepositoryJaxwsWebService repoWebService = null;
                        if (PurRepositoryConnector.this.log.isBasic()) {
                            PurRepositoryConnector.this.log.logBasic(BaseMessages.getString((Class)PKG, (String)"PurRepositoryConnector.CreateRepositoryWebService.Start", (String[])new String[0]));
                        }
                        repoWebService = PurRepositoryConnector.this.serviceManager.createService(username, decryptedPassword, IUnifiedRepositoryJaxwsWebService.class);
                        if (PurRepositoryConnector.this.log.isBasic()) {
                            PurRepositoryConnector.this.log.logBasic(BaseMessages.getString((Class)PKG, (String)"PurRepositoryConnector.CreateRepositoryWebService.End", (String[])new String[0]));
                        }
                        if (PurRepositoryConnector.this.log.isBasic()) {
                            PurRepositoryConnector.this.log.logBasic(BaseMessages.getString((Class)PKG, (String)"PurRepositoryConnector.CreateUnifiedRepositoryToWebServiceAdapter.Start", (String[])new String[0]));
                        }
                        result.setUnifiedRepository((IUnifiedRepository)new UnifiedRepositoryToWebServiceAdapter(repoWebService));
                    }
                    catch (WebServiceException wse) {
                        return wse;
                    }
                    return null;
                }
            });
            Future<Exception> syncWebserviceFuture = executor.submit(new Callable<Exception>(){

                @Override
                public Exception call() throws Exception {
                    try {
                        if (PurRepositoryConnector.this.log.isBasic()) {
                            PurRepositoryConnector.this.log.logBasic(BaseMessages.getString((Class)PKG, (String)"PurRepositoryConnector.CreateRepositorySyncWebService.Start", (String[])new String[0]));
                        }
                        IRepositorySyncWebService syncWebService = PurRepositoryConnector.this.serviceManager.createService(username, decryptedPassword, IRepositorySyncWebService.class);
                        if (PurRepositoryConnector.this.log.isBasic()) {
                            PurRepositoryConnector.this.log.logBasic(BaseMessages.getString((Class)PKG, (String)"PurRepositoryConnector.CreateRepositorySyncWebService.Sync", (String[])new String[0]));
                        }
                        syncWebService.sync(PurRepositoryConnector.this.repositoryMeta.getName(), PurRepositoryConnector.this.repositoryMeta.getRepositoryLocation().getUrl());
                    }
                    catch (RepositorySyncException e) {
                        PurRepositoryConnector.this.log.logError(e.getMessage(), (Throwable)e);
                        result.setConnectMessage(e.getMessage());
                        return null;
                    }
                    catch (ClientTransportException e) {
                        return e;
                    }
                    catch (WebServiceException e) {
                        PurRepositoryConnector.this.log.logError(e.getMessage(), (Throwable)e);
                        return new Exception(BaseMessages.getString((Class)PKG, (String)"PurRepository.BAServerLogin.Message", (String[])new String[0]), e);
                    }
                    return null;
                }
            });
            WebServiceException repoException = repoWebServiceFuture.get();
            if (repoException != null) {
                this.log.logError(repoException.getMessage());
                throw new Exception(BaseMessages.getString(PKG, (String)"PurRepository.FailedLogin.Message", (String[])new String[0]), repoException);
            }
            Exception syncException = syncWebserviceFuture.get();
            if (syncException != null) {
                throw syncException;
            }
            Boolean isAdmin = authorizationWebserviceFuture.get();
            result.getUser().setAdmin(isAdmin);
            if (this.log.isBasic()) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"PurRepositoryConnector.RegisterSecurityProvider.Start", (String[])new String[0]));
            }
            purRepositoryServiceRegistry.registerService(RepositorySecurityProvider.class, (IRepositoryService)result.getSecurityProvider());
            purRepositoryServiceRegistry.registerService(IAbsSecurityProvider.class, (IRepositoryService)result.getSecurityProvider());
            if (isAdmin.booleanValue()) {
                purRepositoryServiceRegistry.registerService(RepositorySecurityManager.class, (IRepositoryService)result.getSecurityManager());
                purRepositoryServiceRegistry.registerService(IRoleSupportSecurityManager.class, (IRepositoryService)result.getSecurityManager());
                purRepositoryServiceRegistry.registerService(IAbsSecurityManager.class, (IRepositoryService)result.getSecurityManager());
            }
            purRepositoryServiceRegistry.registerService(PentahoDiPlugin.PurRepositoryPluginApiRevision.class, this.serviceManager.createService(username, decryptedPassword, PentahoDiPlugin.PurRepositoryPluginApiRevision.class));
            purRepositoryServiceRegistry.registerService(IRevisionService.class, new UnifiedRepositoryRevisionService(result.getUnifiedRepository(), this.rootRef));
            purRepositoryServiceRegistry.registerService(IAclService.class, new UnifiedRepositoryConnectionAclService(result.getUnifiedRepository()));
            purRepositoryServiceRegistry.registerService(IConnectionAclService.class, new UnifiedRepositoryConnectionAclService(result.getUnifiedRepository()));
            purRepositoryServiceRegistry.registerService(ITrashService.class, new UnifiedRepositoryTrashService(result.getUnifiedRepository(), this.rootRef));
            purRepositoryServiceRegistry.registerService(ILockService.class, new UnifiedRepositoryLockService(result.getUnifiedRepository()));
            if (this.log.isBasic()) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"PurRepositoryConnector.RepositoryServicesRegistered.End", (String[])new String[0]));
            }
            result.setSuccess(true);
        }
        catch (NullPointerException npe) {
            result.setSuccess(false);
            throw new KettleException(BaseMessages.getString(PKG, (String)"PurRepository.LoginException.Message", (String[])new String[0]));
        }
        catch (Throwable e) {
            result.setSuccess(false);
            this.serviceManager.close();
            throw new KettleException(e);
        }
        return result;
    }

    @Override
    public synchronized void disconnect() {
        if (this.serviceManager != null) {
            this.serviceManager.close();
        }
        this.serviceManager = null;
    }

    @Override
    public LogChannelInterface getLog() {
        return this.log;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public static boolean inProcess() {
        boolean inProcess = false;
        boolean remoteDiServer = BooleanUtils.toBoolean((String)PentahoSystem.getSystemSetting((String)REMOTE_DI_SERVER_INSTANCE, (String)"false"));
        if ("true".equals(PentahoSystem.getSystemSetting((String)SINGLE_DI_SERVER_INSTANCE, (String)"true"))) {
            inProcess = true;
        } else if (!remoteDiServer && PentahoSystem.getApplicationContext().getFullyQualifiedServerURL() != null) {
            inProcess = true;
        }
        return inProcess;
    }
}

