/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.vfs;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.pentaho.di.core.osgi.api.VfsEmbeddedFileSystemCloser;

public class ConcurrentFileSystemManager
extends StandardFileSystemManager {
    private static final String CONFIG_RESOURCE = "providers.xml";
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public ConcurrentFileSystemManager() {
        this.setConfiguration(StandardFileSystemManager.class.getResource(CONFIG_RESOURCE));
    }

    public void addProvider(String[] urlSchemes, FileProvider provider) throws FileSystemException {
        this.lock.writeLock().lock();
        try {
            super.addProvider(urlSchemes, provider);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String[] getSchemes() {
        this.lock.readLock().lock();
        try {
            String[] stringArray = super.getSchemes();
            return stringArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean hasProvider(String scheme) {
        this.lock.readLock().lock();
        try {
            boolean bl = super.hasProvider(scheme);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject resolveFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.lock.readLock().lock();
        try {
            FileObject fileObject = super.resolveFile(baseFile, uri, fileSystemOptions);
            return fileObject;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileName resolveName(FileName base, String name, NameScope scope) throws FileSystemException {
        this.lock.readLock().lock();
        try {
            FileName fileName = super.resolveName(base, name, scope);
            return fileName;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public FileName resolveURI(String uri) throws FileSystemException {
        this.lock.readLock().lock();
        try {
            FileName fileName = super.resolveURI(uri);
            return fileName;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject createFileSystem(String scheme, FileObject file) throws FileSystemException {
        this.lock.readLock().lock();
        try {
            FileObject fileObject = super.createFileSystem(scheme, file);
            return fileObject;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void _closeFileSystem(FileSystem filesystem) {
        this.lock.readLock().lock();
        try {
            super._closeFileSystem(filesystem);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Capability> getProviderCapabilities(String scheme) throws FileSystemException {
        this.lock.readLock().lock();
        try {
            Collection collection = super.getProviderCapabilities(scheme);
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public FileSystemConfigBuilder getFileSystemConfigBuilder(String scheme) throws FileSystemException {
        this.lock.readLock().lock();
        try {
            FileSystemConfigBuilder fileSystemConfigBuilder = super.getFileSystemConfigBuilder(scheme);
            return fileSystemConfigBuilder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void close() {
        this.lock.writeLock().lock();
        try {
            super.close();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void freeUnusedResources() {
        this.lock.readLock().lock();
        try {
            super.freeUnusedResources();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeEmbeddedFileSystem(String embeddedMetastoreKey) {
        this.lock.readLock().lock();
        try {
            Field field = null;
            try {
                field = ((Object)((Object)this)).getClass().getSuperclass().getSuperclass().getDeclaredField("providers");
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            Map providers = (Map)field.get((Object)this);
            FileProvider provider = (FileProvider)providers.get("hc");
            if (provider != null) {
                ((VfsEmbeddedFileSystemCloser)provider).closeFileSystem(embeddedMetastoreKey);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

