/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.vfs;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.operations.FileOperations;
import org.apache.commons.vfs2.provider.sftp.SftpFileObject;
import org.pentaho.di.core.vfs.SftpFileSystemWindows;

public class SftpFileObjectWithWindowsSupport
implements FileObject {
    private static final String FULL_ACCESS = "(F)";
    private static final String MODIFY_ACCESS = "(M)";
    private static final String READ_AND_EXECUTE_ACCESS = "(RX)";
    private static final String READ_ACCESS = "(R)";
    private static final String WRITE_ACCESS = "(W)";
    private static final String WRITE_DATA_ADD_FILES_ACCESS = "WD";
    private static final String READ_DATA_ADD_FILES_ACCESS = "RD";
    private SftpFileObject sftpFileObject;
    private SftpFileSystemWindows sftpFileSystemWindows;
    private String path;

    public SftpFileObjectWithWindowsSupport(SftpFileObject sftpFileObject, SftpFileSystemWindows sftpFileSystemWindows) throws FileSystemException {
        this.sftpFileObject = sftpFileObject;
        this.path = sftpFileObject.getName().getPath();
        this.sftpFileSystemWindows = sftpFileSystemWindows;
    }

    public boolean isReadable() throws FileSystemException {
        try {
            if (!this.sftpFileSystemWindows.isRemoteHostWindows()) {
                return this.sftpFileObject.isReadable();
            }
            return this.exists() && this.doIsReadable();
        }
        catch (Exception var) {
            throw new FileSystemException("vfs.provider/check-is-readable.error", (Object)this.sftpFileObject.getName(), (Throwable)var);
        }
    }

    private boolean doIsReadable() throws Exception {
        List<String> userGroups = this.sftpFileSystemWindows.getUserGroups();
        Map<String, String> filePermissions = this.sftpFileSystemWindows.getFilePermission(this.path);
        for (String group : userGroups) {
            boolean readable;
            String acl = filePermissions.get(group);
            if (acl == null || !(readable = acl.contains(FULL_ACCESS) || acl.contains(MODIFY_ACCESS) || acl.contains(READ_AND_EXECUTE_ACCESS) || acl.contains(READ_ACCESS) || acl.contains(WRITE_ACCESS) || acl.contains(WRITE_DATA_ADD_FILES_ACCESS) || acl.contains(READ_DATA_ADD_FILES_ACCESS))) continue;
            return true;
        }
        return false;
    }

    public boolean isWriteable() throws FileSystemException {
        try {
            if (!this.sftpFileSystemWindows.isRemoteHostWindows()) {
                return this.sftpFileObject.isWriteable();
            }
            return this.exists() && this.doIsWriteable();
        }
        catch (Exception var) {
            throw new FileSystemException("vfs.provider/check-is-writeable.error", (Object)this.sftpFileObject.getName(), (Throwable)var);
        }
    }

    protected boolean doIsWriteable() throws Exception {
        List<String> userGroups = this.sftpFileSystemWindows.getUserGroups();
        Map<String, String> filePermissions = this.sftpFileSystemWindows.getFilePermission(this.path);
        for (String group : userGroups) {
            boolean writeable;
            String acl = filePermissions.get(group);
            if (acl == null || !(writeable = acl.contains(FULL_ACCESS) || acl.contains(MODIFY_ACCESS) || acl.contains(WRITE_ACCESS) || acl.contains(WRITE_DATA_ADD_FILES_ACCESS))) continue;
            return true;
        }
        return false;
    }

    public boolean canRenameTo(FileObject fileObject) {
        return this.sftpFileObject.canRenameTo(fileObject);
    }

    public void close() throws FileSystemException {
        this.sftpFileObject.close();
    }

    public void copyFrom(FileObject fileObject, FileSelector fileSelector) throws FileSystemException {
        this.sftpFileObject.copyFrom(fileObject, fileSelector);
    }

    public void createFile() throws FileSystemException {
        this.sftpFileObject.createFile();
    }

    public void createFolder() throws FileSystemException {
        this.sftpFileObject.createFolder();
    }

    public boolean delete() throws FileSystemException {
        return this.sftpFileObject.delete();
    }

    public int delete(FileSelector fileSelector) throws FileSystemException {
        return this.sftpFileObject.delete(fileSelector);
    }

    public int deleteAll() throws FileSystemException {
        return this.sftpFileObject.deleteAll();
    }

    public boolean exists() throws FileSystemException {
        return this.sftpFileObject.exists();
    }

    public FileObject[] findFiles(FileSelector fileSelector) throws FileSystemException {
        return this.sftpFileObject.findFiles(fileSelector);
    }

    public void findFiles(FileSelector fileSelector, boolean b, List<FileObject> list) throws FileSystemException {
        this.sftpFileObject.findFiles(fileSelector, b, list);
    }

    public FileObject getChild(String s) throws FileSystemException {
        return this.sftpFileObject.getChild(s);
    }

    public FileObject[] getChildren() throws FileSystemException {
        return this.sftpFileObject.getChildren();
    }

    public FileContent getContent() throws FileSystemException {
        return this.sftpFileObject.getContent();
    }

    public FileOperations getFileOperations() throws FileSystemException {
        return this.sftpFileObject.getFileOperations();
    }

    public FileSystem getFileSystem() {
        return this.sftpFileSystemWindows;
    }

    public FileName getName() {
        return this.sftpFileObject.getName();
    }

    public FileObject getParent() throws FileSystemException {
        return this.sftpFileObject.getParent();
    }

    public String getPublicURIString() {
        return this.sftpFileObject.getPublicURIString();
    }

    public FileType getType() throws FileSystemException {
        return this.sftpFileObject.getType();
    }

    public URL getURL() throws FileSystemException {
        return this.sftpFileObject.getURL();
    }

    public boolean isAttached() {
        return this.sftpFileObject.isAttached();
    }

    public boolean isContentOpen() {
        return this.sftpFileObject.isContentOpen();
    }

    public boolean isExecutable() throws FileSystemException {
        return this.sftpFileObject.isExecutable();
    }

    public boolean isFile() throws FileSystemException {
        return this.sftpFileObject.isFile();
    }

    public boolean isFolder() throws FileSystemException {
        return this.sftpFileObject.isFolder();
    }

    public boolean isHidden() throws FileSystemException {
        return this.sftpFileObject.isHidden();
    }

    public void moveTo(FileObject fileObject) throws FileSystemException {
        this.sftpFileObject.moveTo(fileObject);
    }

    public void refresh() throws FileSystemException {
        this.sftpFileObject.refresh();
    }

    public FileObject resolveFile(String s) throws FileSystemException {
        return this.sftpFileObject.resolveFile(s);
    }

    public FileObject resolveFile(String s, NameScope nameScope) throws FileSystemException {
        return this.sftpFileObject.resolveFile(s, nameScope);
    }

    public boolean setExecutable(boolean b, boolean b1) throws FileSystemException {
        return this.sftpFileObject.setExecutable(b, b1);
    }

    public boolean setReadable(boolean b, boolean b1) throws FileSystemException {
        return this.sftpFileObject.setReadable(b, b1);
    }

    public boolean setWritable(boolean b, boolean b1) throws FileSystemException {
        return this.sftpFileObject.setWritable(b, b1);
    }

    public int compareTo(FileObject o) {
        return this.sftpFileObject.compareTo(o);
    }

    public Iterator<FileObject> iterator() {
        return this.sftpFileObject.iterator();
    }
}

