/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.tez.dag.api.TezException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezSessionPoolManager {
    private static final Logger LOG = LoggerFactory.getLogger(TezSessionPoolManager.class);
    private static final Random rdm = new Random();
    private BlockingQueue<TezSessionPoolSession> defaultQueuePool;
    private PriorityBlockingQueue<TezSessionPoolSession> expirationQueue;
    private BlockingQueue<TezSessionPoolSession> restartQueue;
    private Thread expirationThread;
    private Thread restartThread;
    private Semaphore llapQueue;
    private HiveConf initConf = null;
    private int numConcurrentLlapQueries = -1;
    private long sessionLifetimeMs = 0L;
    private long sessionLifetimeJitterMs = 0L;
    private CustomQueueAllowed customQueueAllowed = CustomQueueAllowed.TRUE;
    private List<HiveConf.ConfVars> restrictedHiveConf = new ArrayList<HiveConf.ConfVars>();
    private List<String> restrictedNonHiveConf = new ArrayList<String>();
    private Queue<TezSessionPoolSession> initialSessions = new ConcurrentLinkedQueue<TezSessionPoolSession>();
    private volatile boolean hasInitialSessions = false;
    private static TezSessionPoolManager sessionPool = null;
    private static final List<TezSessionPoolSession> openSessions = new LinkedList<TezSessionPoolSession>();

    public static TezSessionPoolManager getInstance() throws Exception {
        if (sessionPool == null) {
            sessionPool = new TezSessionPoolManager();
        }
        return sessionPool;
    }

    protected TezSessionPoolManager() {
    }

    private void startInitialSession(TezSessionPoolSession sessionState) throws Exception {
        HiveConf newConf = new HiveConf(this.initConf);
        boolean isUsable = sessionState.tryUse();
        if (!isUsable) {
            throw new IOException(sessionState + " is not usable at pool startup");
        }
        newConf.set("tez.queue.name", sessionState.getQueueName());
        sessionState.open(newConf);
        if (sessionState.returnAfterUse()) {
            this.defaultQueuePool.put(sessionState);
        }
    }

    public void startPool() throws Exception {
        if (this.initialSessions.isEmpty()) {
            return;
        }
        int threadCount = Math.min(this.initialSessions.size(), HiveConf.getIntVar(this.initConf, HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSION_MAX_INIT_THREADS));
        Preconditions.checkArgument(threadCount > 0);
        if (threadCount == 1) {
            TezSessionPoolSession session;
            while ((session = this.initialSessions.poll()) != null) {
                this.startInitialSession(session);
            }
        } else {
            int i;
            final SessionState parentSessionState = SessionState.get();
            final AtomicReference<Object> firstError = new AtomicReference<Object>(null);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TezSessionPoolSession session;
                    if (parentSessionState != null) {
                        SessionState.setCurrentSessionState(parentSessionState);
                    }
                    while ((session = (TezSessionPoolSession)TezSessionPoolManager.this.initialSessions.poll()) != null) {
                        try {
                            TezSessionPoolManager.this.startInitialSession(session);
                        }
                        catch (Exception e) {
                            if (firstError.compareAndSet(null, e)) continue;
                            LOG.error("Failed to start session; ignoring due to previous error", (Throwable)e);
                        }
                    }
                }
            };
            Thread[] threads = new Thread[threadCount - 1];
            for (i = 0; i < threads.length; ++i) {
                threads[i] = new Thread(runnable, "Tez session init " + i);
                threads[i].start();
            }
            runnable.run();
            for (i = 0; i < threads.length; ++i) {
                threads[i].join();
            }
            Exception ex = firstError.get();
            if (ex != null) {
                throw ex;
            }
        }
        if (this.expirationThread != null) {
            this.expirationThread.start();
            this.restartThread.start();
        }
    }

    public void setupPool(HiveConf conf) throws InterruptedException {
        String[] defaultQueueList = HiveConf.getTrimmedStringsVar(conf, HiveConf.ConfVars.HIVE_SERVER2_TEZ_DEFAULT_QUEUES);
        int emptyNames = 0;
        for (String queueName : defaultQueueList) {
            if (!queueName.isEmpty()) continue;
            ++emptyNames;
        }
        int numSessions = conf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSIONS_PER_DEFAULT_QUEUE);
        int numSessionsTotal = numSessions * (defaultQueueList.length - emptyNames);
        if (numSessionsTotal > 0) {
            this.defaultQueuePool = new ArrayBlockingQueue<TezSessionPoolSession>(numSessionsTotal);
        }
        this.numConcurrentLlapQueries = conf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_LLAP_CONCURRENT_QUERIES);
        this.llapQueue = new Semaphore(this.numConcurrentLlapQueries, true);
        this.initConf = conf;
        String queueAllowedStr = HiveConf.getVar(this.initConf, HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSION_CUSTOM_QUEUE_ALLOWED);
        try {
            this.customQueueAllowed = CustomQueueAllowed.valueOf(queueAllowedStr.toUpperCase());
        }
        catch (Exception ex) {
            throw new RuntimeException("Invalid value '" + queueAllowedStr + "' for " + HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSION_CUSTOM_QUEUE_ALLOWED.varname);
        }
        String[] restrictedConfigs = HiveConf.getTrimmedStringsVar(this.initConf, HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSION_RESTRICTED_CONFIGS);
        if (restrictedConfigs != null && restrictedConfigs.length > 0) {
            HashMap<String, HiveConf.ConfVars> confVars = HiveConf.getOrCreateReverseMap();
            for (String confName : restrictedConfigs) {
                if (confName == null || confName.isEmpty()) continue;
                HiveConf.ConfVars cv = confVars.get(confName = confName.toLowerCase());
                if (cv != null) {
                    this.restrictedHiveConf.add(cv);
                    continue;
                }
                LOG.warn("A restricted config " + confName + " is not recognized as a Hive setting.");
                this.restrictedNonHiveConf.add(confName);
            }
        }
        this.sessionLifetimeMs = conf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSION_LIFETIME, TimeUnit.MILLISECONDS);
        if (this.sessionLifetimeMs != 0L) {
            this.sessionLifetimeJitterMs = conf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSION_LIFETIME_JITTER, TimeUnit.MILLISECONDS);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session expiration is enabled; session lifetime is " + this.sessionLifetimeMs + " + [0, " + this.sessionLifetimeJitterMs + ") ms");
            }
            this.expirationQueue = new PriorityBlockingQueue<TezSessionPoolSession>(11, new Comparator<TezSessionPoolSession>(){

                @Override
                public int compare(TezSessionPoolSession o1, TezSessionPoolSession o2) {
                    assert (o1.expirationNs != null && o2.expirationNs != null);
                    return o1.expirationNs.compareTo(o2.expirationNs);
                }
            });
            this.restartQueue = new LinkedBlockingQueue<TezSessionPoolSession>();
        }
        boolean bl = this.hasInitialSessions = numSessionsTotal > 0;
        if (this.sessionLifetimeMs != 0L) {
            this.expirationThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    TezSessionPoolManager.this.runExpirationThread();
                }
            }, "TezSessionPool-expiration");
            this.restartThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    TezSessionPoolManager.this.runRestartThread();
                }
            }, "TezSessionPool-cleanup");
        }
        for (int i = 0; i < numSessions; ++i) {
            for (String queueName : defaultQueueList) {
                if (queueName.isEmpty()) continue;
                this.initialSessions.add(this.createAndInitSession(queueName, true));
            }
        }
    }

    private TezSessionPoolSession createAndInitSession(String queue, boolean isDefault) {
        TezSessionPoolSession sessionState = this.createSession(TezSessionState.makeSessionId());
        if (queue != null) {
            sessionState.setQueueName(queue);
        }
        if (isDefault) {
            sessionState.setDefault();
        }
        LOG.info("Created new tez session for queue: " + queue + " with session id: " + sessionState.getSessionId());
        return sessionState;
    }

    private TezSessionState getSession(HiveConf conf, boolean doOpen) throws Exception {
        String serverValue;
        String userValue;
        boolean hasQueue;
        String queueName = conf.get("tez.queue.name");
        boolean bl = hasQueue = queueName != null && !queueName.isEmpty();
        if (hasQueue) {
            switch (this.customQueueAllowed) {
                case FALSE: {
                    throw new HiveException("Specifying tez.queue.name is not allowed");
                }
                case IGNORE: {
                    LOG.warn("User has specified " + queueName + " queue; ignoring the setting");
                    queueName = null;
                    hasQueue = false;
                    conf.unset("tez.queue.name");
                }
            }
        }
        for (HiveConf.ConfVars confVars : this.restrictedHiveConf) {
            userValue = HiveConf.getVarWithoutType(conf, confVars);
            serverValue = HiveConf.getVarWithoutType(this.initConf, confVars);
            this.validateRestrictedConfigValues(confVars.varname, userValue, serverValue);
        }
        for (String string : this.restrictedNonHiveConf) {
            userValue = conf.get(string);
            serverValue = this.initConf.get(string);
            this.validateRestrictedConfigValues(string, userValue, serverValue);
        }
        boolean nonDefaultUser = conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        if (nonDefaultUser || !this.hasInitialSessions || hasQueue) {
            LOG.info("QueueName: {} nonDefaultUser: {} defaultQueuePool: {} hasInitialSessions: {}", new Object[]{queueName, nonDefaultUser, this.defaultQueuePool, this.hasInitialSessions});
            return this.getNewSessionState(conf, queueName, doOpen);
        }
        LOG.info("Choosing a session from the defaultQueuePool");
        TezSessionPoolSession tezSessionPoolSession;
        while (!(tezSessionPoolSession = this.defaultQueuePool.take()).tryUse()) {
            LOG.info("Couldn't use a session [" + tezSessionPoolSession + "]; attempting another one");
        }
        return tezSessionPoolSession;
    }

    private void validateRestrictedConfigValues(String var, String userValue, String serverValue) throws HiveException {
        if (userValue == null != (serverValue == null) || userValue != null && !userValue.equals(serverValue)) {
            String logValue = this.initConf.isHiddenConfig(var) ? "(hidden)" : serverValue;
            throw new HiveException(var + " is restricted from being set; server is configured" + " to use " + logValue + ", but the query configuration specifies " + userValue);
        }
    }

    private TezSessionState getNewSessionState(HiveConf conf, String queueName, boolean doOpen) throws Exception {
        TezSessionPoolSession retTezSessionState = this.createAndInitSession(queueName, false);
        if (queueName != null) {
            conf.set("tez.queue.name", queueName);
        }
        if (doOpen) {
            retTezSessionState.open(conf);
            LOG.info("Started a new session for queue: " + queueName + " session id: " + retTezSessionState.getSessionId());
        }
        return retTezSessionState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnSession(TezSessionState tezSessionState, boolean llap) throws Exception {
        boolean isInterrupted = Thread.interrupted();
        try {
            if (isInterrupted) {
                LOG.info("returnSession invoked with interrupt status set");
            }
            if (llap && this.numConcurrentLlapQueries > 0) {
                this.llapQueue.release();
            }
            if (tezSessionState.isDefault() && tezSessionState instanceof TezSessionPoolSession) {
                TezSessionPoolSession poolSession;
                LOG.info("The session " + tezSessionState.getSessionId() + " belongs to the pool. Put it back in");
                SessionState sessionState = SessionState.get();
                if (sessionState != null) {
                    sessionState.setTezSession(null);
                }
                if ((poolSession = (TezSessionPoolSession)tezSessionState).returnAfterUse()) {
                    this.defaultQueuePool.put(poolSession);
                }
            }
        }
        finally {
            if (isInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void closeIfNotDefault(TezSessionState tezSessionState, boolean keepTmpDir) throws Exception {
        LOG.info("Closing tez session if not default: " + tezSessionState);
        if (!tezSessionState.isDefault()) {
            tezSessionState.close(keepTmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (sessionPool == null || !this.hasInitialSessions) {
            return;
        }
        ArrayList<TezSessionPoolSession> sessionsToClose = null;
        List<TezSessionPoolSession> list = openSessions;
        synchronized (list) {
            sessionsToClose = new ArrayList<TezSessionPoolSession>(openSessions);
        }
        for (TezSessionState tezSessionState : sessionsToClose) {
            if (!tezSessionState.isDefault()) continue;
            tezSessionState.close(false);
        }
        if (this.expirationThread != null) {
            this.expirationThread.interrupt();
        }
        if (this.restartThread != null) {
            this.restartThread.interrupt();
        }
    }

    public void destroySession(TezSessionState tezSessionState) throws Exception {
        LOG.warn("We are closing a " + (tezSessionState.isDefault() ? "default" : "non-default") + " session because of retry failure.");
        tezSessionState.close(false);
    }

    protected TezSessionPoolSession createSession(String sessionId) {
        return new TezSessionPoolSession(sessionId, this);
    }

    private static boolean canWorkWithSameSession(TezSessionState session, HiveConf conf) throws HiveException {
        if (session == null || conf == null || !session.isOpen()) {
            return false;
        }
        try {
            UserGroupInformation ugi = Utils.getUGI();
            String userName = ugi.getShortUserName();
            LOG.info("The current user: " + userName + ", session user: " + session.getUser());
            if (!userName.equals(session.getUser())) {
                LOG.info("Different users incoming: " + userName + " existing: " + session.getUser());
                return false;
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        boolean doAsEnabled = conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        if (doAsEnabled != session.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS)) {
            return false;
        }
        if (!session.isDefault()) {
            String queueName = session.getQueueName();
            String confQueueName = conf.get("tez.queue.name");
            LOG.info("Current queue name is " + queueName + " incoming queue name is " + confQueueName);
            return queueName == null ? confQueueName == null : queueName.equals(confQueueName);
        }
        throw new HiveException("The pool session " + session + " should have been returned to the pool");
    }

    public TezSessionState getSession(TezSessionState session, HiveConf conf, boolean doOpen, boolean llap) throws Exception {
        if (llap && this.numConcurrentLlapQueries > 0) {
            this.llapQueue.acquire();
        }
        if (TezSessionPoolManager.canWorkWithSameSession(session, conf)) {
            return session;
        }
        if (session != null) {
            TezSessionPoolManager.closeIfNotDefault(session, false);
        }
        return this.getSession(conf, doOpen);
    }

    public void reopenSession(TezSessionState sessionState, HiveConf conf, String[] additionalFiles, boolean keepTmpDir) throws Exception {
        HiveConf sessionConf = sessionState.getConf();
        if (sessionConf != null && sessionConf.get("tez.queue.name") != null) {
            conf.set("tez.queue.name", sessionConf.get("tez.queue.name"));
        } else if (sessionState.getQueueName() != null) {
            conf.set("tez.queue.name", sessionState.getQueueName());
        }
        sessionState.close(keepTmpDir);
        sessionState.open(conf, additionalFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeNonDefaultSessions(boolean keepTmpDir) throws Exception {
        ArrayList<TezSessionPoolSession> sessionsToClose = null;
        List<TezSessionPoolSession> list = openSessions;
        synchronized (list) {
            sessionsToClose = new ArrayList<TezSessionPoolSession>(openSessions);
        }
        for (TezSessionPoolSession sessionState : sessionsToClose) {
            System.err.println("Shutting down tez session.");
            TezSessionPoolManager.closeIfNotDefault(sessionState, keepTmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndReopenPoolSession(TezSessionPoolSession oldSession) throws Exception {
        String queueName = oldSession.getQueueName();
        if (queueName == null) {
            LOG.warn("Pool session has a null queue: " + oldSession);
        }
        HiveConf conf = oldSession.getConf();
        Path scratchDir = oldSession.getTezScratchDir();
        boolean isDefault = oldSession.isDefault();
        Set<String> additionalFiles = oldSession.getAdditionalFilesNotFromConf();
        try {
            oldSession.close(false);
            this.defaultQueuePool.remove(oldSession);
        }
        finally {
            TezSessionPoolSession newSession = this.createAndInitSession(queueName, isDefault);
            conf.set("tez.queue.name", queueName);
            newSession.open(conf, additionalFiles, scratchDir);
            this.defaultQueuePool.put(newSession);
        }
    }

    private void runRestartThread() {
        block5: while (true) {
            try {
                while (true) {
                    TezSessionPoolSession next = this.restartQueue.take();
                    LOG.info("Restarting the expired session [" + next + "]");
                    try {
                        this.closeAndReopenPoolSession(next);
                        continue block5;
                    }
                    catch (InterruptedException ie) {
                        throw ie;
                    }
                    catch (Exception e) {
                        LOG.error("Failed to close or restart a session, ignoring", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                LOG.info("Restart thread is exiting due to an interruption");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runExpirationThread() {
        try {
            while (true) {
                TezSessionPoolSession nextToExpire;
                block18: {
                    nextToExpire = null;
                    while (true) {
                        block17: {
                            nextToExpire = this.expirationQueue.take();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Seeing if we can expire [" + nextToExpire + "]");
                            }
                            try {
                                if (!nextToExpire.tryExpire(false)) {
                                }
                                break block17;
                            }
                            catch (Exception e) {
                                LOG.error("Failed to expire session " + nextToExpire + "; ignoring", (Throwable)e);
                                nextToExpire = null;
                            }
                            if (nextToExpire != null) {
                                break;
                            }
                            break block18;
                        }
                        LOG.info("Tez session [" + nextToExpire + "] has expired");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[" + nextToExpire + "] is not ready to expire; adding it back");
                    }
                }
                PriorityBlockingQueue<TezSessionPoolSession> priorityBlockingQueue = this.expirationQueue;
                synchronized (priorityBlockingQueue) {
                    if (nextToExpire != null) {
                        this.expirationQueue.add(nextToExpire);
                    }
                    if ((nextToExpire = this.expirationQueue.peek()) != null) {
                        long timeToWaitMs = 10L + (nextToExpire.expirationNs - System.nanoTime()) / 1000000L;
                        timeToWaitMs = Math.max(1L, timeToWaitMs);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Waiting for ~" + timeToWaitMs + "ms to expire [" + nextToExpire + "]");
                        }
                        this.expirationQueue.wait(timeToWaitMs);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Expiration queue is empty");
                    }
                }
            }
        }
        catch (InterruptedException e) {
            LOG.info("Expiration thread is exiting due to an interruption");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToExpirationQueue(TezSessionPoolSession session) {
        PriorityBlockingQueue<TezSessionPoolSession> priorityBlockingQueue = this.expirationQueue;
        synchronized (priorityBlockingQueue) {
            this.expirationQueue.add(session);
            this.expirationQueue.notifyAll();
        }
    }

    @VisibleForTesting
    static class TezSessionPoolSession
    extends TezSessionState {
        private static final int STATE_NONE = 0;
        private static final int STATE_IN_USE = 1;
        private static final int STATE_EXPIRED = 2;
        private final AtomicInteger sessionState = new AtomicInteger(0);
        private Long expirationNs;
        private final TezSessionPoolManager parent;

        public TezSessionPoolSession(String sessionId, TezSessionPoolManager parent) {
            super(sessionId);
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(boolean keepTmpDir) throws Exception {
            try {
                super.close(keepTmpDir);
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closed a pool session [" + this + "]");
                }
                List list = openSessions;
                synchronized (list) {
                    openSessions.remove(this);
                }
                if (this.parent.expirationQueue != null) {
                    this.parent.expirationQueue.remove(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void openInternal(HiveConf conf, Collection<String> additionalFiles, boolean isAsync, SessionState.LogHelper console, Path scratchDir) throws IOException, LoginException, URISyntaxException, TezException {
            super.openInternal(conf, additionalFiles, isAsync, console, scratchDir);
            List list = openSessions;
            synchronized (list) {
                openSessions.add(this);
            }
            if (this.parent.expirationQueue != null) {
                long jitterModMs = (long)((float)this.parent.sessionLifetimeJitterMs * rdm.nextFloat());
                this.expirationNs = System.nanoTime() + (this.parent.sessionLifetimeMs + jitterModMs) * 1000000L;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding a pool session [" + this + "] to expiration queue");
                }
                this.parent.addToExpirationQueue(this);
            }
        }

        @Override
        public String toString() {
            if (this.expirationNs == null) {
                return super.toString();
            }
            long expiresInMs = (this.expirationNs - System.nanoTime()) / 1000000L;
            return super.toString() + ", expires in " + expiresInMs + "ms";
        }

        public boolean tryUse() throws Exception {
            int finalState;
            do {
                int oldValue;
                if ((oldValue = this.sessionState.get()) == 1) {
                    throw new AssertionError((Object)(this + " is already in use"));
                }
                if (oldValue != 2) continue;
                return false;
            } while (!this.sessionState.compareAndSet(0, finalState = this.shouldExpire() ? 2 : 1));
            if (finalState == 1) {
                return true;
            }
            this.closeAndRestartExpiredSession(true);
            return false;
        }

        public boolean returnAfterUse() throws Exception {
            int finalState;
            int n = finalState = this.shouldExpire() ? 2 : 0;
            if (!this.sessionState.compareAndSet(1, finalState)) {
                throw new AssertionError((Object)("Unexpected state change; currently " + this.sessionState.get()));
            }
            if (finalState == 0) {
                return true;
            }
            this.closeAndRestartExpiredSession(true);
            return false;
        }

        public boolean tryExpire(boolean isAsync) throws Exception {
            if (this.expirationNs == null) {
                return true;
            }
            if (!this.shouldExpire()) {
                return false;
            }
            do {
                if (this.sessionState.get() == 0) continue;
                return true;
            } while (!this.sessionState.compareAndSet(0, 2));
            this.closeAndRestartExpiredSession(isAsync);
            return true;
        }

        private void closeAndRestartExpiredSession(boolean async) throws Exception {
            if (async) {
                this.parent.restartQueue.add(this);
            } else {
                this.parent.closeAndReopenPoolSession(this);
            }
        }

        private boolean shouldExpire() {
            return this.expirationNs != null && System.nanoTime() - this.expirationNs >= 0L;
        }
    }

    private static enum CustomQueueAllowed {
        TRUE,
        FALSE,
        IGNORE;

    }
}

