/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;

public class AvroConverter {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String DEFAULT_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";

    protected static Object convertFromSourceToTargetDataType(int sourceValueMetaInterface, int targetValueMetaInterface, Object value) {
        if (value == null) {
            return null;
        }
        switch (sourceValueMetaInterface) {
            case 10: {
                return AvroConverter.convertFromInetMetaInterface(targetValueMetaInterface, value);
            }
            case 2: {
                return AvroConverter.convertFromStringMetaInterface(targetValueMetaInterface, value);
            }
            case 5: {
                return AvroConverter.convertFromIntegerMetaInterface(targetValueMetaInterface, value);
            }
            case 1: {
                return AvroConverter.convertFromNumberMetaInterface(targetValueMetaInterface, value);
            }
            case 6: {
                return AvroConverter.convertFromBigNumberMetaInterface(targetValueMetaInterface, value);
            }
            case 9: {
                return AvroConverter.convertFromTimestampMetaInterface(targetValueMetaInterface, value);
            }
            case 3: {
                return AvroConverter.convertFromDateMetaInterface(targetValueMetaInterface, value);
            }
            case 4: {
                return AvroConverter.convertFromBooleanMetaInterface(targetValueMetaInterface, value);
            }
            case 8: {
                return AvroConverter.convertFromBinaryMetaInterface(targetValueMetaInterface, value);
            }
        }
        return value;
    }

    protected static Object convertFromStringMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        SimpleDateFormat datePattern = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        SimpleDateFormat timePattern = new SimpleDateFormat(DEFAULT_TIME_FORMAT);
        if (value == null) {
            return value;
        }
        if (!(value instanceof String)) {
            return AvroConverter.handleConversionError("Error.  Expecting value of type string.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    if (value == null) break;
                    try {
                        returnVal = InetAddress.getByName(value.toString());
                    }
                    catch (UnknownHostException e) {
                        returnVal = null;
                    }
                    break;
                }
                case 2: {
                    returnVal = value;
                    break;
                }
                case 5: {
                    returnVal = Long.parseLong((String)value);
                    break;
                }
                case 1: {
                    returnVal = Double.parseDouble((String)value);
                    break;
                }
                case 6: {
                    Double doubleValue = Double.parseDouble((String)value);
                    returnVal = new BigDecimal(doubleValue);
                    break;
                }
                case 9: {
                    returnVal = new Timestamp(timePattern.parse((String)value).getTime());
                    break;
                }
                case 3: {
                    returnVal = datePattern.parse((String)value);
                    break;
                }
                case 4: {
                    returnVal = Boolean.parseBoolean((String)value);
                    break;
                }
                case 8: {
                    returnVal = ((String)value).getBytes();
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError("Error trying to convert from String to a different data type.  value = '" + value + "'.  Error:  " + e.getClass() + ":  " + e.getMessage(), e);
        }
        return returnVal;
    }

    protected static Object convertFromDateMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof Integer)) {
            return AvroConverter.handleConversionError("Error.  Expecting value of type Integer.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            LocalDate localDate = LocalDate.ofEpochDay(0L).plusDays(((Integer)value).intValue());
            Date dateValue = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
            switch (targetValueMetaInterface) {
                case 10: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Date to Inet.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 2: {
                    SimpleDateFormat datePattern = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
                    returnVal = datePattern.format(dateValue);
                    break;
                }
                case 5: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Date to Integer.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 1: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Date to Number.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 6: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Date to BigNumber.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 9: {
                    returnVal = new Timestamp(dateValue.getTime());
                    break;
                }
                case 3: {
                    returnVal = dateValue;
                    break;
                }
                case 4: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Date to Boolean.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 8: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Date to Binary.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError("Error trying to convert from Date to a different data type.  value = '" + value + "'.  Error:  " + e.getClass() + ":  " + e.getMessage(), e);
        }
        return returnVal;
    }

    protected static Object convertFromNumberMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof Double)) {
            return AvroConverter.handleConversionError("Error.  Expecting value of type Double.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Number to Inet.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 2: {
                    break;
                }
                case 5: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Number to Integer.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 1: {
                    returnVal = value;
                    break;
                }
                case 6: {
                    returnVal = new BigDecimal((Double)value);
                    break;
                }
                case 9: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Number to Timestamp.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 3: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Number to Date.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 4: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Number to Boolean.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 8: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Number to Binary.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError("Error trying to convert from Number to a different data type.  value = '" + value + "'.  Error:  " + e.getClass() + ":  " + e.getMessage(), e);
        }
        return returnVal;
    }

    protected static Object convertFromBooleanMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof Boolean)) {
            return AvroConverter.handleConversionError("Error.  Expecting value of type string.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Boolean to Inet.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 2: {
                    returnVal = Boolean.toString((Boolean)value);
                    break;
                }
                case 5: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Boolean to Integer.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 1: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Boolean to Number.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 6: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Boolean to BigNumber.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 9: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Boolean to Timestamp.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 3: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Boolean to Date.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 4: {
                    returnVal = value;
                    break;
                }
                case 8: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Boolean to Binary.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError("Error trying to convert from String to a different data type.  value = '" + value + "'.  Error:  " + e.getClass() + ":  " + e.getMessage(), e);
        }
        return returnVal;
    }

    protected static Object convertFromIntegerMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof Long)) {
            return AvroConverter.handleConversionError("Error.  Expecting value of type Long.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Integer to Inet.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 2: {
                    returnVal = Long.toString((Long)value);
                    break;
                }
                case 5: {
                    returnVal = (Long)value;
                    break;
                }
                case 1: {
                    returnVal = ((Long)value).doubleValue();
                    break;
                }
                case 6: {
                    returnVal = new BigDecimal(((Long)value).doubleValue());
                    break;
                }
                case 9: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Integer to Timestamp.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 3: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Integer to Date.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 4: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Integer to Boolean.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 8: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Integer to Binary.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError("Error trying to convert from Integer to a different data type.  value = '" + value + "'.  Error:  " + e.getClass() + ":  " + e.getMessage(), e);
        }
        return returnVal;
    }

    protected static Object convertFromBigNumberMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof Double)) {
            return AvroConverter.handleConversionError("Error.  Expecting value of type Double.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from BigNumber to Inet.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 2: {
                    returnVal = ((Double)value).toString();
                    break;
                }
                case 5: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from BigNumber to Integer.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 1: {
                    returnVal = (Double)value;
                    break;
                }
                case 6: {
                    returnVal = new BigDecimal((Double)value);
                    break;
                }
                case 9: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from BigNumber to Timestamp.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 3: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from BigNumber to Date.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 4: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from BigNumber to Boolean.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 8: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from BigNumber to Binary.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError("Error trying to convert from BigNumber to a different data type.  value = '" + value + "'.  Error:  " + e.getClass() + ":  " + e.getMessage(), e);
        }
        return returnVal;
    }

    protected static Object convertFromTimestampMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof Long)) {
            return AvroConverter.handleConversionError("Error.  Expecting value of type string.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Timnestamp to Inet.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 2: {
                    Date dateValue = new Date((Long)value);
                    SimpleDateFormat timestampPattern = new SimpleDateFormat(DEFAULT_TIME_FORMAT);
                    returnVal = timestampPattern.format(dateValue);
                    break;
                }
                case 5: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Timnestamp to Integer.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 1: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Timnestamp to Number.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 6: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Timnestamp to BigNumber.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 9: {
                    returnVal = new Timestamp((Long)value);
                    break;
                }
                case 3: {
                    returnVal = new Date((Long)value);
                    break;
                }
                case 4: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Timnestamp to Boolean.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 8: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Timnestamp to Binary.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError("Error trying to convert from String to a different data type.  value = '" + value + "'.  Error:  " + e.getClass() + ":  " + e.getMessage(), e);
        }
        return returnVal;
    }

    protected static Object convertFromInetMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof String)) {
            return AvroConverter.handleConversionError("Error.  Expecting value of type string.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    try {
                        returnVal = InetAddress.getByName(value.toString());
                    }
                    catch (UnknownHostException e) {
                        returnVal = null;
                    }
                    break;
                }
                case 2: {
                    try {
                        returnVal = InetAddress.getByName((String)value).toString();
                    }
                    catch (UnknownHostException e) {
                        returnVal = null;
                    }
                    break;
                }
                case 5: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Inet to Integer.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 1: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Inet to Number.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 6: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Inet to BigNumber.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 9: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Inet to Timestamp.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 3: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Inet to Date.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 4: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Inet to Boolean.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 8: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Inet to Binary.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError("Error trying to convert from String to a different data type.  value = '" + value + "'.  Error:  " + e.getClass() + ":  " + e.getMessage(), e);
        }
        return returnVal;
    }

    protected static Object convertFromBinaryMetaInterface(int targetValueMetaInterface, Object value) {
        Object returnVal = value;
        if (value == null) {
            return value;
        }
        if (!(value instanceof ByteBuffer) && !(value instanceof byte[])) {
            return AvroConverter.handleConversionError("Error.  Expecting value of type ByteBuffer.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            switch (targetValueMetaInterface) {
                case 10: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Binary to Inet.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 2: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Binary to String.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 5: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Binary to Integer.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 1: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Binary to Number.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 6: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Binary to BigNumber.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 9: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Binary to Timestamp.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 3: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Binary to Date.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 4: {
                    return AvroConverter.handleConversionError("Error.  Can not convert from Binary to Boolean.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
                }
                case 8: {
                    if (value instanceof byte[]) {
                        return value;
                    }
                    returnVal = ((ByteBuffer)value).array();
                }
            }
        }
        catch (Exception e) {
            return AvroConverter.handleConversionError("Error trying to convert from String to a different data type.  value = '" + value + "'.  Error:  " + e.getClass() + ":  " + e.getMessage(), e);
        }
        return returnVal;
    }

    protected static Object handleConversionError(String errorMessage) {
        return AvroConverter.handleConversionError(errorMessage, null);
    }

    protected static Object handleConversionError(String errorMessage, Exception e) {
        return null;
    }
}

