/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.util.SerializableStepMeta;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.file.BaseFileInputAdditionalField;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputUtils;
import org.pentaho.di.trans.steps.fileinput.text.TextFileLine;

public class FileInputContentFunction
extends ConfigurableFunction<Iterator<String>, Iterator<Row>>
implements FlatMapFunction<Iterator<String>, Row> {
    private transient StepMeta stepMeta;
    private transient MetricsAccumulator metricsAccumulator;

    public FileInputContentFunction() {
    }

    public FileInputContentFunction(StepMeta step, MetricsAccumulator metricsAccumulator) {
        this.stepMeta = step;
        this.metricsAccumulator = metricsAccumulator;
    }

    public Iterator<Row> call(final Iterator<String> stringIterator) throws Exception {
        final TextFileInputMeta fileMeta = (TextFileInputMeta)Util.getTypedStepMeta((StepMeta)this.stepMeta, TextFileInputMeta.class);
        final RowMetaInterface rowMetaInterface = this.stepMeta.getParentTransMeta().getStepFields(this.stepMeta);
        final RowMetaInterface convertRowMeta = rowMetaInterface.cloneToType(2);
        final LogChannelInterface logChannelInterface = KettleLogStore.getLogChannelInterfaceFactory().create((Object)fileMeta);
        final Date theDate = new Date();
        final BaseFileInputAdditionalField additionalOutputFields = new BaseFileInputAdditionalField();
        final List<String> fieldNames = Arrays.asList(rowMetaInterface.getFieldNames());
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return stringIterator.hasNext();
            }

            @Override
            public Row next() {
                FileInputContentFunction.this.metricsAccumulator.addRowOut();
                String s = (String)stringIterator.next();
                TextFileLine line = new TextFileLine(s, 0L, null);
                Object[] row = new Object[]{};
                try {
                    row = TextFileInputUtils.convertLineToRow((LogChannelInterface)logChannelInterface, (TextFileLine)line, (TextFileInputMeta)fileMeta, (Object[])new Object[0], (int)0, (RowMetaInterface)rowMetaInterface, (RowMetaInterface)convertRowMeta, (String)fileMeta.getFileName()[0], (long)0L, (String)fileMeta.content.separator, (String)fileMeta.content.enclosure, (String)fileMeta.content.escapeCharacter, null, (BaseFileInputAdditionalField)additionalOutputFields, (String)fileMeta.content.filenameField, (String)"", (boolean)false, (Date)theDate, (String)"", (String)"", (String)"", (Long)0L);
                }
                catch (KettleException e) {
                    FileInputContentFunction.this.getLogChannel().logError("Failed to convert input line for row: '" + s + "'", (Throwable)e);
                }
                return new KettleRow(fieldNames, row);
            }
        };
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)"FileInputContentFunction-stepMeta", (Object)new SerializableStepMeta(this.stepMeta), (Object)"FileInputContentFunction-metricsAccumulator", (Object)this.metricsAccumulator);
    }

    public void setConfig(String key, Serializable value) {
        switch (key) {
            case "FileInputContentFunction-stepMeta": {
                this.stepMeta = ((SerializableStepMeta)value).getStepMeta();
                break;
            }
            case "FileInputContentFunction-metricsAccumulator": {
                this.metricsAccumulator = (MetricsAccumulator)value;
            }
        }
    }
}

