/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.logger.FunctionLogger;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.util.SerializableStepMeta;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutput;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputData;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;

public class FileOutputContentFunction
extends ConfigurableFunction<Iterator<Row>, Iterator<String>>
implements FlatMapFunction<Iterator<Row>, String> {
    private transient StepMeta stepMeta;
    private transient MetricsAccumulator metricsAccumulator;
    private transient FunctionLogger transLogger;
    private transient FunctionLogger operationLogger;

    public FileOutputContentFunction() {
    }

    public FileOutputContentFunction(StepMeta stepMeta, MetricsAccumulator metricsAccumulator, FunctionLogger transLogger, FunctionLogger operationLogger) {
        this.stepMeta = stepMeta;
        this.metricsAccumulator = metricsAccumulator;
        this.transLogger = transLogger;
        this.operationLogger = operationLogger;
    }

    public Iterator<String> call(Iterator<Row> rowIterator) throws Exception {
        Util.setLogAccumulators((String)this.stepMeta.getName(), (FunctionLogger)this.transLogger, (FunctionLogger)this.operationLogger);
        TextFileOutput step = (TextFileOutput)Util.getTypedStep((StepMeta)this.stepMeta, TextFileOutput.class);
        TextFileOutputMeta textFileOutputMeta = (TextFileOutputMeta)step.getStepMeta().getStepMetaInterface();
        textFileOutputMeta.setDoNotOpenNewFileInit(true);
        TextFileOutputData textFileOutputData = (TextFileOutputData)textFileOutputMeta.getStepData();
        textFileOutputData.outputRowMeta = Util.getRowMeta((TransMeta)this.stepMeta.getParentTransMeta(), (String)this.stepMeta.getName()).clone();
        textFileOutputData.fieldnrs = Ints.toArray((Collection)Arrays.stream(textFileOutputMeta.getOutputFields()).map(TextFileField::getName).map(arg_0 -> ((RowMetaInterface)textFileOutputData.outputRowMeta).indexOfValue(arg_0)).collect(Collectors.toList()));
        step.init((StepMetaInterface)textFileOutputMeta, (StepDataInterface)textFileOutputData);
        ArrayList outputRows = new ArrayList();
        rowIterator.forEachRemaining(row -> {
            this.metricsAccumulator.addRowIn();
            try (ByteArrayOutputStream writer = new ByteArrayOutputStream();){
                textFileOutputData.writer = writer;
                step.writeRowToFile(textFileOutputData.outputRowMeta, row.getObjects());
                this.metricsAccumulator.addRowOut();
                outputRows.add(((Object)writer).toString());
            }
            catch (Exception ex) {
                this.getLogChannel().logError("Error processing " + ex.getMessage());
            }
        });
        return outputRows.iterator();
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)"FileOutputContentFunction-stepMeta", (Object)new SerializableStepMeta(this.stepMeta), (Object)"FileOutputContentFunction-metricsAccumulator", (Object)this.metricsAccumulator, (Object)"FileOutputContentFunction-transLogger", (Object)this.transLogger, (Object)"FileOutputContentFunction-operationLogger", (Object)this.operationLogger);
    }

    public void setConfig(String key, Serializable value) {
        switch (key) {
            case "FileOutputContentFunction-stepMeta": {
                this.stepMeta = ((SerializableStepMeta)value).getStepMeta();
                break;
            }
            case "FileOutputContentFunction-metricsAccumulator": {
                this.metricsAccumulator = (MetricsAccumulator)value;
                break;
            }
            case "FileOutputContentFunction-transLogger": {
                this.transLogger = (FunctionLogger)value;
                break;
            }
            case "FileOutputContentFunction-operationLogger": {
                this.operationLogger = (FunctionLogger)value;
            }
        }
    }
}

