/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.pentaho.big.data.kettle.plugins.formats.avro.AvroFormatInputOutputField;
import org.pentaho.big.data.kettle.plugins.formats.avro.output.AvroOutputMetaBase;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.util.SerializableStepMeta;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.step.StepMeta;

public class KettleToSparkAvroRowFunction
extends ConfigurableFunction<org.pentaho.di.engine.api.model.Row, Row>
implements Function<org.pentaho.di.engine.api.model.Row, Row> {
    private StepMeta stepMeta;
    private transient MetricsAccumulator metricsAccumulator;
    String[] fieldFormat;
    int[] outputToRowSubscripts;

    public KettleToSparkAvroRowFunction(RowMetaInterface rowMeta, StepMeta stepMeta, MetricsAccumulator metricsAccumulator) {
        List outputFields = ((AvroOutputMetaBase)stepMeta.getStepMetaInterface()).getOutputFields();
        int size = outputFields.size();
        this.fieldFormat = new String[size];
        this.outputToRowSubscripts = new int[size];
        String[] fieldNames = rowMeta.getFieldNames();
        int outputFieldNumber = 0;
        for (AvroFormatInputOutputField outputField : outputFields) {
            for (int i = 0; i < fieldNames.length; ++i) {
                if (!fieldNames[i].equals(outputField.getName())) continue;
                ValueMetaInterface vmi = rowMeta.getValueMeta(i);
                this.outputToRowSubscripts[outputFieldNumber] = i;
                this.fieldFormat[outputFieldNumber] = vmi.getConversionMask();
            }
            ++outputFieldNumber;
        }
        this.metricsAccumulator = metricsAccumulator;
        this.stepMeta = stepMeta;
    }

    public KettleToSparkAvroRowFunction() {
    }

    public Row call(org.pentaho.di.engine.api.model.Row row) throws Exception {
        this.metricsAccumulator.addRowIn();
        Object[] objects = row.getObjects();
        AvroOutputMetaBase avroOutputMetaBase = (AvroOutputMetaBase)Util.getTypedStepMeta((StepMeta)this.stepMeta, AvroOutputMetaBase.class);
        List outputFields = avroOutputMetaBase.getOutputFields();
        Object[] outputObjects = new Object[outputFields.size()];
        block15: for (int i = 0; i < outputFields.size(); ++i) {
            int rowSubscript = this.outputToRowSubscripts[i];
            outputObjects[i] = objects[rowSubscript];
            AvroFormatInputOutputField outputField = (AvroFormatInputOutputField)outputFields.get(i);
            String defaultValue = outputField.getIfNullValue();
            switch (outputField.getType()) {
                case 1: {
                    if (!this.useDefaultValue(outputField, objects[rowSubscript])) continue block15;
                    outputObjects[i] = Double.parseDouble(defaultValue);
                    continue block15;
                }
                case 2: {
                    if (!this.useDefaultValue(outputField, objects[rowSubscript])) continue block15;
                    outputObjects[i] = defaultValue;
                    continue block15;
                }
                case 3: {
                    if (this.useDefaultValue(outputField, objects[rowSubscript])) {
                        int avroDate;
                        SimpleDateFormat dateFormat = new SimpleDateFormat(this.fieldFormat[i]);
                        try {
                            Date defaultDate = dateFormat.parse(defaultValue);
                            if (defaultDate == null) continue block15;
                            LocalDate rowDate = defaultDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                            avroDate = Math.toIntExact(ChronoUnit.DAYS.between(LocalDate.ofEpochDay(0L), rowDate));
                            outputObjects[i] = avroDate;
                        }
                        catch (ParseException pe) {
                            avroDate = -1;
                        }
                        continue block15;
                    }
                    Date dateFromRow = (Date)objects[rowSubscript];
                    if (dateFromRow == null) continue block15;
                    LocalDate rowDate = dateFromRow.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    int avroDate = Math.toIntExact(ChronoUnit.DAYS.between(LocalDate.ofEpochDay(0L), rowDate));
                    outputObjects[i] = avroDate;
                    continue block15;
                }
                case 4: {
                    if (!this.useDefaultValue(outputField, objects[rowSubscript])) continue block15;
                    outputObjects[i] = Boolean.parseBoolean(defaultValue);
                    continue block15;
                }
                case 5: {
                    if (!this.useDefaultValue(outputField, objects[rowSubscript])) continue block15;
                    outputObjects[i] = Long.parseLong(defaultValue);
                    continue block15;
                }
                case 6: {
                    if (this.useDefaultValue(outputField, objects[rowSubscript])) {
                        BigDecimal defaultBigDecimal = new BigDecimal(defaultValue);
                        outputObjects[i] = defaultBigDecimal.doubleValue();
                        continue block15;
                    }
                    if (objects[rowSubscript] == null) continue block15;
                    outputObjects[i] = ((BigDecimal)objects[rowSubscript]).doubleValue();
                    continue block15;
                }
                case 8: {
                    if (!this.useDefaultValue(outputField, objects[rowSubscript])) continue block15;
                    outputObjects[i] = defaultValue.getBytes();
                    continue block15;
                }
                case 9: {
                    Date defaultTimeStamp;
                    if (!this.useDefaultValue(outputField, objects[rowSubscript])) continue block15;
                    SimpleDateFormat dateFormat = new SimpleDateFormat(this.fieldFormat[i]);
                    try {
                        defaultTimeStamp = dateFormat.parse(defaultValue);
                    }
                    catch (ParseException pe) {
                        defaultTimeStamp = null;
                    }
                    if (defaultTimeStamp == null) continue block15;
                    outputObjects[i] = new Timestamp(defaultTimeStamp.getTime());
                    continue block15;
                }
                case 10: {
                    if (this.useDefaultValue(outputField, objects[rowSubscript])) {
                        outputObjects[i] = String.valueOf(defaultValue);
                        continue block15;
                    }
                    if (objects[rowSubscript] == null) continue block15;
                    outputObjects[i] = objects[rowSubscript].toString();
                }
            }
        }
        this.metricsAccumulator.addRowOut();
        return RowFactory.create((Object[])outputObjects);
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)"AVRO_OUTPUT_STEP_META", (Object)new SerializableStepMeta(this.stepMeta), (Object)"FIELD_FORMAT", (Object)this.fieldFormat, (Object)"OUTPUT_TO_ROW_SUBSCRIPTS", (Object)this.outputToRowSubscripts, (Object)"AVRO_OUTPUT_METRICS_ACCUMULATOR", (Object)this.metricsAccumulator);
    }

    public void setConfig(String key, Serializable value) {
        if (key.equals("AVRO_OUTPUT_STEP_META")) {
            this.stepMeta = ((SerializableStepMeta)value).getStepMeta();
        } else if (key.equals("FIELD_FORMAT")) {
            this.fieldFormat = (String[])value;
        } else if (key.equals("OUTPUT_TO_ROW_SUBSCRIPTS")) {
            this.outputToRowSubscripts = (int[])value;
        } else if (key.equals("AVRO_OUTPUT_METRICS_ACCUMULATOR")) {
            this.metricsAccumulator = (MetricsAccumulator)value;
        }
    }

    private boolean useDefaultValue(AvroFormatInputOutputField outputField, Object value) {
        if (outputField != null && outputField.getNullString() != null && outputField.getNullString().equals("No")) {
            return outputField.getIfNullValue() != null && outputField.getIfNullValue().length() > 0 && value == null;
        }
        return false;
    }
}

