/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;

public class KettleToSparkParquetRowFunction
extends ConfigurableFunction<org.pentaho.di.engine.api.model.Row, Row>
implements Function<org.pentaho.di.engine.api.model.Row, Row> {
    private static final long serialVersionUID = 1249005474535308786L;
    private int[] dateFields;
    private int[] inetFields;
    private int[] decimalFields;
    private transient MetricsAccumulator metricsAccumulator;

    public KettleToSparkParquetRowFunction(RowMetaInterface rowMeta, MetricsAccumulator metricsAccumulator) {
        List valueMetaList = rowMeta.getValueMetaList();
        this.dateFields = KettleToSparkParquetRowFunction.getFieldsPosition(3, valueMetaList);
        this.inetFields = KettleToSparkParquetRowFunction.getFieldsPosition(10, valueMetaList);
        this.decimalFields = KettleToSparkParquetRowFunction.getFieldsPosition(6, valueMetaList);
        this.metricsAccumulator = metricsAccumulator;
    }

    private static int[] getFieldsPosition(int filedType, List<ValueMetaInterface> valueMetaList) {
        return IntStream.range(0, valueMetaList.size()).filter(i -> ((ValueMetaInterface)valueMetaList.get(i)).getType() == filedType).toArray();
    }

    public KettleToSparkParquetRowFunction() {
    }

    public Row call(org.pentaho.di.engine.api.model.Row row) throws Exception {
        this.metricsAccumulator.addRowIn();
        Object[] objects = row.getObjects();
        for (int dateIndex : this.dateFields) {
            if (objects[dateIndex] == null) continue;
            objects[dateIndex] = new Timestamp(((Date)objects[dateIndex]).getTime());
        }
        for (int inetIndex : this.inetFields) {
            objects[inetIndex] = objects[inetIndex] == null ? null : ((InetAddress)objects[inetIndex]).getAddress();
        }
        for (int i : this.decimalFields) {
            if (objects[i] == null) continue;
            objects[i] = ((BigDecimal)objects[i]).doubleValue();
        }
        this.metricsAccumulator.addRowOut();
        return RowFactory.create((Object[])objects);
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)(((Object)((Object)this)).getClass().getName() + "_DATEFIELDS"), (Object)this.dateFields, (Object)(((Object)((Object)this)).getClass().getName() + "_INETFIELDS"), (Object)this.inetFields, (Object)(((Object)((Object)this)).getClass().getName() + "_DECIMALFIELDS"), (Object)this.decimalFields, (Object)(((Object)((Object)this)).getClass().getName() + "_METRICSACCUMULATOR"), (Object)this.metricsAccumulator);
    }

    public void setConfig(String key, Serializable value) {
        if (Objects.equals(key, ((Object)((Object)this)).getClass().getName() + "_DATEFIELDS")) {
            this.dateFields = (int[])value;
        } else if (Objects.equals(key, ((Object)((Object)this)).getClass().getName() + "_INETFIELDS")) {
            this.inetFields = (int[])value;
        } else if (Objects.equals(key, ((Object)((Object)this)).getClass().getName() + "_DECIMALFIELDS")) {
            this.decimalFields = (int[])value;
        } else if (Objects.equals(key, ((Object)((Object)this)).getClass().getName() + "_METRICSACCUMULATOR")) {
            this.metricsAccumulator = (MetricsAccumulator)value;
        }
    }
}

