/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.spark.api.java.Optional;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import scala.Tuple2;

public class MergeJoinFunctions {

    public static class FullOuterJoinToRddFunction
    extends BaseToRddFunction<Tuple2<List<Object>, Tuple2<Optional<Row>, Optional<Row>>>, Row>
    implements Function<Tuple2<List<Object>, Tuple2<Optional<Row>, Optional<Row>>>, Row> {
        public FullOuterJoinToRddFunction(String rowMetaXML, int row1Size, int row2Size, MetricsAccumulator metricsAccumulator) {
            super(rowMetaXML, row1Size, row2Size, metricsAccumulator);
        }

        public FullOuterJoinToRddFunction() {
        }

        public Row call(Tuple2<List<Object>, Tuple2<Optional<Row>, Optional<Row>>> tuple) throws Exception {
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])(((Optional)((Tuple2)tuple._2)._1).isPresent() ? ((Row)((Optional)((Tuple2)tuple._2)._1).get()).getObjects() : new Object[this.row1Size]), (int)this.getRowMeta().size());
            Object[] values = RowDataUtil.addRowData((Object[])outputRowData, (int)this.row1Size, (Object[])(((Optional)((Tuple2)tuple._2)._2).isPresent() ? ((Row)((Optional)((Tuple2)tuple._2)._2).get()).getObjects() : new Object[this.row2Size]));
            this.metricsAccumulator.addRowOut();
            return new KettleRow(this.getRowMeta(), values);
        }
    }

    public static class RightOuterJoinToRddFunction
    extends BaseToRddFunction<Tuple2<List<Object>, Tuple2<Optional<Row>, Row>>, Row>
    implements Function<Tuple2<List<Object>, Tuple2<Optional<Row>, Row>>, Row> {
        public RightOuterJoinToRddFunction(String rowMetaXML, int row1Size, int row2Size, MetricsAccumulator metricsAccumulator) {
            super(rowMetaXML, row1Size, row2Size, metricsAccumulator);
        }

        public RightOuterJoinToRddFunction() {
        }

        public Row call(Tuple2<List<Object>, Tuple2<Optional<Row>, Row>> tuple) throws Exception {
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])(((Optional)((Tuple2)tuple._2)._1).isPresent() ? ((Row)((Optional)((Tuple2)tuple._2)._1).get()).getObjects() : new Object[this.row1Size]), (int)this.getRowMeta().size());
            Object[] values = RowDataUtil.addRowData((Object[])outputRowData, (int)this.row1Size, (Object[])((Row)((Tuple2)tuple._2)._2).getObjects());
            this.metricsAccumulator.addRowOut();
            return new KettleRow(this.getRowMeta(), values);
        }
    }

    public static class LeftOuterJoinToRddFunction
    extends BaseToRddFunction<Tuple2<List<Object>, Tuple2<Row, Optional<Row>>>, Row>
    implements Function<Tuple2<List<Object>, Tuple2<Row, Optional<Row>>>, Row> {
        public LeftOuterJoinToRddFunction(String rowMetaXML, int row1Size, int row2Size, MetricsAccumulator metricsAccumulator) {
            super(rowMetaXML, row1Size, row2Size, metricsAccumulator);
        }

        public LeftOuterJoinToRddFunction() {
        }

        public Row call(Tuple2<List<Object>, Tuple2<Row, Optional<Row>>> tuple) throws Exception {
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])((Row)((Tuple2)tuple._2)._1).getObjects(), (int)this.getRowMeta().size());
            Object[] values = RowDataUtil.addRowData((Object[])outputRowData, (int)this.row1Size, (Object[])(((Optional)((Tuple2)tuple._2)._2).isPresent() ? ((Row)((Optional)((Tuple2)tuple._2)._2).get()).getObjects() : new Object[this.row2Size]));
            this.metricsAccumulator.addRowOut();
            return new KettleRow(this.getRowMeta(), values);
        }
    }

    public static class InnerJoinToRddFunction
    extends BaseToRddFunction<Tuple2<List<Object>, Tuple2<Row, Row>>, Row>
    implements Function<Tuple2<List<Object>, Tuple2<Row, Row>>, Row> {
        public InnerJoinToRddFunction(String rowMetaXML, int row1Size, int row2Size, MetricsAccumulator metricsAccumulator) {
            super(rowMetaXML, row1Size, row2Size, metricsAccumulator);
        }

        public InnerJoinToRddFunction() {
        }

        public Row call(Tuple2<List<Object>, Tuple2<Row, Row>> tuple) throws Exception {
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])((Row)((Tuple2)tuple._2)._1).getObjects(), (int)this.getRowMeta().size());
            Object[] values = RowDataUtil.addRowData((Object[])outputRowData, (int)this.row1Size, (Object[])((Row)((Tuple2)tuple._2)._2).getObjects());
            this.metricsAccumulator.addRowOut();
            return new KettleRow(this.getRowMeta(), values);
        }
    }

    public static abstract class BaseToRddFunction<T, R>
    extends ConfigurableFunction<T, R> {
        private transient RowMetaInterface rowMeta;
        protected int row1Size;
        protected int row2Size;
        protected transient MetricsAccumulator metricsAccumulator;
        private static final String XML_KEY = "RowMetaInterface-xml";
        private static final String ROW1_SIZE_KEY = "RowMetaInterface-row1Size";
        private static final String ROW2_SIZE_KEY = "RowMetaInterface-row2Size";
        private static final String METRIC_ACCUMULATOR = "RowMetaInterface-metricsAccumulator";

        public BaseToRddFunction(String rowMetaXML, int row1Size, int row2Size, MetricsAccumulator metricsAccumulator) {
            this.rowMeta = this.deserializeRowMeta(rowMetaXML);
            this.row1Size = row1Size;
            this.row2Size = row2Size;
            this.metricsAccumulator = metricsAccumulator;
        }

        public BaseToRddFunction() {
        }

        protected RowMetaInterface getRowMeta() {
            return this.rowMeta;
        }

        public Map<String, Serializable> getConfig() {
            try {
                return ImmutableMap.of((Object)XML_KEY, (Object)this.rowMeta.getMetaXML(), (Object)ROW1_SIZE_KEY, (Object)this.row1Size, (Object)ROW2_SIZE_KEY, (Object)this.row2Size, (Object)METRIC_ACCUMULATOR, (Object)this.metricsAccumulator);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void setConfig(String key, Serializable value) {
            switch (key) {
                case "RowMetaInterface-xml": {
                    this.rowMeta = this.deserializeRowMeta((String)((Object)value));
                    break;
                }
                case "RowMetaInterface-row1Size": {
                    this.row1Size = (Integer)value;
                    break;
                }
                case "RowMetaInterface-row2Size": {
                    this.row2Size = (Integer)value;
                    break;
                }
                case "RowMetaInterface-metricsAccumulator": {
                    this.metricsAccumulator = (MetricsAccumulator)value;
                }
            }
        }

        private RowMetaInterface deserializeRowMeta(String value) {
            try {
                Document doc = XMLHandler.loadXMLString((String)value);
                Node rowMetaNode = XMLHandler.getSubNode((Node)doc, (String)"row-meta");
                return new RowMeta(rowMetaNode);
            }
            catch (KettleException ke) {
                throw new RuntimeException(ke);
            }
        }
    }

    public static class ToPairRddFunction
    extends ConfigurableFunction<Row, Tuple2<List<Object>, Row>>
    implements PairFunction<Row, List<Object>, Row>,
    Serializable {
        private int[] keyIndexes;
        private MetricsAccumulator metricsAccumulator;
        private String ACCUM_KEY = "ACCUMULATOR";

        public ToPairRddFunction(String[] fields, String[] keyFields, MetricsAccumulator metricsAccumulator) {
            this.keyIndexes = Stream.of(keyFields).mapToInt(key -> Arrays.asList(fields).indexOf(key)).toArray();
            this.metricsAccumulator = metricsAccumulator;
        }

        public ToPairRddFunction() {
        }

        public Tuple2<List<Object>, Row> call(Row row) throws Exception {
            this.metricsAccumulator.addRowIn();
            List keys = IntStream.of(this.keyIndexes).mapToObj(i -> row.getObjects()[i]).collect(Collectors.toList());
            return new Tuple2(keys, (Object)row);
        }

        public Map<String, Serializable> getConfig() {
            return ImmutableMap.of((Object)ToPairRddFunction.class.getName(), (Object)this.keyIndexes, (Object)this.ACCUM_KEY, (Object)this.metricsAccumulator);
        }

        public void setConfig(String key, Serializable value) {
            if (Objects.equals(key, ToPairRddFunction.class.getName())) {
                this.keyIndexes = (int[])value;
            } else if (Objects.equals(key, this.ACCUM_KEY)) {
                this.metricsAccumulator = (MetricsAccumulator)value;
            }
        }
    }
}

