/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputOutputField;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroInputMetaBase;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.functions.AvroConverter;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.util.SerializableStepMeta;
import org.pentaho.di.trans.step.StepMeta;

public class SparkToKettleAvroRowFunction
extends ConfigurableFunction<Iterator<Row>, Iterator<org.pentaho.di.engine.api.model.Row>>
implements FlatMapFunction<Iterator<Row>, org.pentaho.di.engine.api.model.Row> {
    private static final long serialVersionUID = -8387294136003736814L;
    private transient StepMeta stepMeta;
    private transient MetricsAccumulator metricsAccumulator;
    private transient Map<String, Integer> fieldNameMap = new HashMap<String, Integer>();
    private transient int inputFieldsSize;
    public static final String FIELDNAME_DELIMITER = "_delimiter_";

    public SparkToKettleAvroRowFunction() {
    }

    public SparkToKettleAvroRowFunction(StepMeta stepMeta, MetricsAccumulator metricsAccumulator) {
        this.stepMeta = stepMeta;
        this.metricsAccumulator = metricsAccumulator;
        this.postStepMetaProcessing();
    }

    public Iterator<org.pentaho.di.engine.api.model.Row> call(final Iterator<Row> rowIterator) throws Exception {
        final RowMetaInterface rowMeta = this.stepMeta.getParentTransMeta().getStepFields(this.stepMeta);
        return new Iterator<org.pentaho.di.engine.api.model.Row>(){

            @Override
            public boolean hasNext() {
                return rowIterator.hasNext();
            }

            @Override
            public org.pentaho.di.engine.api.model.Row next() {
                SparkToKettleAvroRowFunction.this.metricsAccumulator.addRowIn();
                SparkToKettleAvroRowFunction.this.metricsAccumulator.addRowOut();
                return SparkToKettleAvroRowFunction.this.toKettleRow((Row)rowIterator.next(), rowMeta);
            }
        };
    }

    private org.pentaho.di.engine.api.model.Row toKettleRow(Row row, RowMetaInterface rowMeta) {
        assert (row.size() == rowMeta.size());
        StructField[] fields = row.schema().fields();
        Object[] values = new Object[this.inputFieldsSize];
        for (int index = 0; index < row.size(); ++index) {
            Integer rowMetaIndex = this.getRowMetaIndex(fields[index]);
            if (rowMetaIndex == null) continue;
            values[rowMetaIndex.intValue()] = this.getVal(row.get(index), fields[index].dataType(), this.getSourceType(rowMetaIndex), rowMeta.getValueMeta(rowMetaIndex.intValue()));
        }
        return new KettleRow(rowMeta, values);
    }

    private Integer getRowMetaIndex(StructField field) {
        String fieldName = field.name();
        int position = fieldName.indexOf(FIELDNAME_DELIMITER);
        if (position != -1) {
            fieldName = fieldName.substring(0, position);
        }
        Integer stepFieldSubscript = this.fieldNameMap.get(fieldName);
        return stepFieldSubscript;
    }

    private Integer getSourceType(Integer rowMetaIndex) {
        if (rowMetaIndex == null) {
            return null;
        }
        return ((FormatInputOutputField)((AvroInputMetaBase)this.stepMeta.getStepMetaInterface()).getInpuFields().get(rowMetaIndex)).getSourceType();
    }

    private Object getVal(Object value, DataType sparkSqlType, int sourceType, ValueMetaInterface finalType) {
        return AvroConverter.convertFromSourceToTargetDataType(sourceType, finalType.getType(), value);
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)SerializableStepMeta.class.getName(), (Object)new SerializableStepMeta(this.stepMeta), (Object)(((Object)((Object)this)).getClass().getName() + "-metricsAccumulator"), (Object)this.metricsAccumulator);
    }

    public void setConfig(String key, Serializable value) {
        if (Objects.equals(key, SerializableStepMeta.class.getName())) {
            SerializableStepMeta delegate = (SerializableStepMeta)value;
            this.stepMeta = delegate.getStepMeta();
            this.postStepMetaProcessing();
        } else if (Objects.equals(key, ((Object)((Object)this)).getClass().getName() + "-metricsAccumulator")) {
            this.metricsAccumulator = (MetricsAccumulator)value;
        }
    }

    private void postStepMetaProcessing() {
        List inputFields = ((AvroInputMetaBase)this.stepMeta.getStepMetaInterface()).getInpuFields();
        this.inputFieldsSize = inputFields.size();
        for (int i = 0; i < this.inputFieldsSize; ++i) {
            FormatInputOutputField inputField = (FormatInputOutputField)inputFields.get(i);
            this.fieldNameMap.put(inputField.getPath(), i);
        }
    }
}

