/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.util.SerializableStepMeta;
import org.pentaho.di.trans.step.StepMeta;

public class SparkToKettleRowFunction
extends ConfigurableFunction<Iterator<Row>, Iterator<org.pentaho.di.engine.api.model.Row>>
implements FlatMapFunction<Iterator<Row>, org.pentaho.di.engine.api.model.Row> {
    private static final long serialVersionUID = -8387294136003736814L;
    private transient StepMeta stepMeta;
    private transient MetricsAccumulator metricsAccumulator;

    public SparkToKettleRowFunction() {
    }

    public SparkToKettleRowFunction(StepMeta stepMeta, MetricsAccumulator metricsAccumulator) {
        this.stepMeta = stepMeta;
        this.metricsAccumulator = metricsAccumulator;
    }

    public Iterator<org.pentaho.di.engine.api.model.Row> call(final Iterator<Row> rowIterator) throws Exception {
        final RowMetaInterface rowMeta = this.stepMeta.getParentTransMeta().getStepFields(this.stepMeta);
        return new Iterator<org.pentaho.di.engine.api.model.Row>(){

            @Override
            public boolean hasNext() {
                return rowIterator.hasNext();
            }

            @Override
            public org.pentaho.di.engine.api.model.Row next() {
                SparkToKettleRowFunction.this.metricsAccumulator.addRowIn();
                SparkToKettleRowFunction.this.metricsAccumulator.addRowOut();
                return SparkToKettleRowFunction.this.toKettleRow((Row)rowIterator.next(), rowMeta);
            }
        };
    }

    private org.pentaho.di.engine.api.model.Row toKettleRow(Row row, RowMetaInterface rowMeta) {
        assert (row.size() == rowMeta.size());
        StructField[] fields = row.schema().fields();
        return new KettleRow(rowMeta, IntStream.range(0, row.size()).mapToObj(index -> this.getVal(row.get(index), fields[index].dataType(), rowMeta.getValueMeta(index))).collect(Collectors.toList()).toArray());
    }

    private Object getVal(Object value, DataType sparkSqlType, ValueMetaInterface valueMeta) {
        Object toRet = value;
        if (this.isDate(valueMeta.getType())) {
            toRet = this.handleDate(sparkSqlType, value, valueMeta);
        } else if (valueMeta.getType() == 10) {
            toRet = this.handleAddress(sparkSqlType, value, valueMeta);
        }
        return toRet;
    }

    private java.util.Date handleDate(DataType sparkSqlType, Object value, ValueMetaInterface valueMeta) {
        if (sparkSqlType == DataTypes.DateType) {
            return new java.util.Date(((Date)value).getTime());
        }
        if (sparkSqlType == DataTypes.TimestampType) {
            return (Timestamp)value;
        }
        if (sparkSqlType == DataTypes.StringType) {
            return this.parseDate((String)value, valueMeta);
        }
        throw new RuntimeException(String.format("Unexpected Spark SQL type (%s) corresponding to Kettle type (%s)", sparkSqlType, valueMeta));
    }

    private InetAddress handleAddress(DataType sparkSqlType, Object value, ValueMetaInterface valueMeta) {
        try {
            if (sparkSqlType == DataTypes.BinaryType) {
                return value == null ? null : InetAddress.getByAddress((byte[])value);
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e.getMessage());
        }
        throw new RuntimeException(String.format("Unexpected Spark SQL type (%s) corresponding to Kettle type (%s)", sparkSqlType, valueMeta));
    }

    private boolean isDate(int kettleType) {
        return kettleType == 3 || kettleType == 9;
    }

    private java.util.Date parseDate(String value, ValueMetaInterface valueMeta) {
        try {
            return valueMeta.getDateFormat().parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)SerializableStepMeta.class.getName(), (Object)new SerializableStepMeta(this.stepMeta), (Object)(((Object)((Object)this)).getClass().getName() + "-metricsAccumulator"), (Object)this.metricsAccumulator);
    }

    public void setConfig(String key, Serializable value) {
        if (Objects.equals(key, SerializableStepMeta.class.getName())) {
            SerializableStepMeta delegate = (SerializableStepMeta)value;
            this.stepMeta = delegate.getStepMeta();
        } else if (Objects.equals(key, ((Object)((Object)this)).getClass().getName() + "-metricsAccumulator")) {
            this.metricsAccumulator = (MetricsAccumulator)value;
        }
    }
}

