/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.spark.broadcast.Broadcast;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.spi.KettleStepFunction;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.streamlookup.StreamLookupData;

public class StreamLookupFunction
extends KettleStepFunction {
    private static final String INFO_STREAM_KEY = "StreamLookupFunction-infoStream";
    private Broadcast<List<Row>> infoStream;

    public StreamLookupFunction() {
    }

    public StreamLookupFunction(StepMeta stepMeta, Broadcast<List<Row>> infoStream, MetricsAccumulator metricsAccumulator) {
        super(stepMeta);
        this.infoStream = infoStream;
        this.setMetricsAccumulator(metricsAccumulator);
    }

    protected BaseStep createStep() {
        BaseStep step = Util.getTypedStep((StepMeta)this.stepMeta, BaseStep.class);
        step.init(step.getStepMetaInterface(), step.getStepDataInterface());
        step.getTrans().setRunning(true);
        this.prepInfoStream(step);
        return step;
    }

    private void prepInfoStream(BaseStep step) {
        String infoStreamName = ((StreamInterface)step.getStepMetaInterface().getStepIOMeta().getInfoStreams().get(0)).getStepMeta().getName();
        RowSet rowSetLookup = step.getTrans().rowsets.stream().filter(rowset -> infoStreamName.equals(rowset.getOriginStepName())).findFirst().get();
        try {
            RowMetaInterface rowMeta = Util.getRowMeta((TransMeta)step.getTransMeta(), (String)infoStreamName);
            ((List)this.infoStream.getValue()).forEach(row -> {
                this.metricsAccumulator.addRowIn();
                rowSetLookup.putRow(rowMeta, row.getObjects());
            });
            rowSetLookup.setDone();
            if (((StreamLookupData)step.getStepDataInterface()).readLookupValues && !step.processRow(step.getStepMetaInterface(), step.getStepDataInterface())) {
                throw new RuntimeException("Unable to read data from lookup-stream");
            }
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.builder().putAll(super.getConfig()).put((Object)INFO_STREAM_KEY, this.infoStream).build();
    }

    public void setConfig(String key, Serializable value) {
        super.setConfig(key, value);
        if (Objects.equals(key, INFO_STREAM_KEY)) {
            this.infoStream = (Broadcast)value;
        }
    }
}

