/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroInputMetaBase;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.functions.FileInputContentFunction;
import org.pentaho.di.engine.spark.impl.functions.SparkToKettleAvroRowFunction;
import org.pentaho.di.engine.spark.spi.RegisteredFunction;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;

public class AvroInputSparkOperation
implements SparkOperation {
    private final TransMeta transMeta;
    private final JavaSparkContext sparkContext;
    private final Operation operation;
    private final AvroInputMetaBase fileMeta;
    private MetricsAccumulator metricsAccumulator;

    public AvroInputSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        this(operation, stepMeta, sparkContext);
    }

    AvroInputSparkOperation(Operation operation, StepMeta stepMeta, JavaSparkContext sparkContext) {
        this.transMeta = stepMeta.getParentTransMeta();
        this.fileMeta = (AvroInputMetaBase)Util.getTypedStepMeta((StepMeta)stepMeta, AvroInputMetaBase.class);
        this.operation = operation;
        this.sparkContext = sparkContext;
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(AvroInputSparkOperation::new, new Supplier[]{FileInputContentFunction::new, SparkToKettleAvroRowFunction::new});
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public String getId() {
        return this.operation.getId();
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        this.metricsAccumulator = subscriber.getMetricsAccumulator();
        Supplier<JavaRDD> readAction = this::loadDefaultAction;
        subscriber.setOutput(CompletableFuture.supplyAsync(readAction, arg_0 -> ((SparkOperation.Subscriber)subscriber).registerDriverAction(arg_0)));
    }

    private JavaRDD<Row> loadDefaultAction() {
        SparkSession sparkSession = Util.getSparkSession();
        String filename = this.transMeta.environmentSubstitute(this.fileMeta.getFilename());
        Dataset rowDataset = sparkSession.read().format("com.databricks.spark.avro").load(filename);
        this.metricsAccumulator.setCountRowIn(false);
        SparkToKettleAvroRowFunction rowFunction = new SparkToKettleAvroRowFunction(this.transMeta.findStep(this.getId()), this.metricsAccumulator);
        RegisteredFunction registeredFunction = rowFunction.asRegisteredFunction(this.fileMeta.getParentStepMeta().getStepID());
        return rowDataset.toJavaRDD().mapPartitions(registeredFunction.toFlatMap());
    }
}

