/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.pentaho.big.data.kettle.plugins.formats.avro.output.AvroOutputMetaBase;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.events.FinalOperationEvent;
import org.pentaho.di.engine.spark.impl.events.OperationErrorEvent;
import org.pentaho.di.engine.spark.impl.functions.KettleToSparkAvroRowFunction;
import org.pentaho.di.engine.spark.impl.logger.FunctionLogger;
import org.pentaho.di.engine.spark.impl.ops.AvroSchemaUtils;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;

public class AvroOutputSparkOperation
implements SparkOperation {
    private final String AVRO_COMPRESSION_CODEC = "spark.sql.avro.compression.codec";
    private final TransMeta transMeta;
    private final AvroOutputMetaBase avroOutputMetaBase;
    private final AvroOutputMetaBase outputMeta;
    private final Operation operation;
    private final JavaSparkContext sparkContext;
    private final RowMetaInterface rowMeta;
    private final AtomicReference<Object[]> nextRow = new AtomicReference();
    private final Consumer<JavaRDD<org.pentaho.di.engine.api.model.Row>> DEFAULT_FILE_ACTION = this::saveDefaultAction;
    private Map<String, Consumer<JavaRDD<org.pentaho.di.engine.api.model.Row>>> fileActionMap = ImmutableMap.of((Object)"hdfs", this.DEFAULT_FILE_ACTION);
    private int totalRows = 0;
    private final boolean isFinalOperation;
    private MetricsAccumulator metricsAccumulator = MetricsAccumulator.empty();
    private FunctionLogger transLogger = FunctionLogger.empty();
    private FunctionLogger operationLogger = FunctionLogger.empty();

    public AvroOutputSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        this.transMeta = stepMeta.getParentTransMeta();
        this.avroOutputMetaBase = (AvroOutputMetaBase)Util.getTypedStepMeta((StepMeta)stepMeta, AvroOutputMetaBase.class);
        this.outputMeta = (AvroOutputMetaBase)stepMeta.getStepMetaInterface();
        this.operation = operation;
        this.sparkContext = sparkContext;
        this.isFinalOperation = operation.getHopsOut() == null || operation.getHopsOut().isEmpty();
        this.rowMeta = Util.getRowMeta((TransMeta)Util.getTransMeta((Transformation)transformation), (String)operation.getId());
    }

    @VisibleForTesting
    AvroOutputSparkOperation(Operation operation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext, Map<String, Consumer<JavaRDD<org.pentaho.di.engine.api.model.Row>>> fileActionMap) {
        this(operation, null, stepMeta, sparkContext, executionContext);
        this.fileActionMap = fileActionMap;
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(AvroOutputSparkOperation::new, new Supplier[]{KettleToSparkAvroRowFunction::new});
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public String getId() {
        return this.operation.getId();
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        Set expectedOutputs = subscriber.getExpectedOutputs();
        this.metricsAccumulator = subscriber.getMetricsAccumulator();
        this.transLogger = Util.getTransformationLogger((SparkOperation.Subscriber)subscriber);
        this.operationLogger = Util.getOperationLogger((SparkOperation.Subscriber)subscriber);
        JavaRDD rdd = subscriber.getInput().map(input -> expectedOutputs.isEmpty() ? input : input.cache()).orElseGet(() -> ((JavaSparkContext)this.sparkContext).emptyRDD());
        expectedOutputs.forEach(output -> subscriber.addOutput(output, rdd));
        subscriber.registerDriverAction(() -> this.saveDefaultAction((JavaRDD<org.pentaho.di.engine.api.model.Row>)rdd));
    }

    @VisibleForTesting
    protected void saveDefaultAction(JavaRDD<org.pentaho.di.engine.api.model.Row> rdd) {
        try {
            StructType schema = AvroSchemaUtils.createSchemaFromMeta(this.outputMeta.getOutputFields());
            Dataset<Row> rowDataset = this.convert(this.avroOutputMetaBase, schema, rdd, Util.getRowMeta((TransMeta)this.transMeta, (String)this.getId()), this.avroOutputMetaBase.getParentStepMeta().getStepID());
            switch (AvroOutputMetaBase.CompressionType.valueOf((String)this.avroOutputMetaBase.getCompressionType().toUpperCase())) {
                case SNAPPY: {
                    rowDataset.sqlContext().setConf("spark.sql.avro.compression.codec", "snappy");
                    break;
                }
                case DEFLATE: {
                    rowDataset.sqlContext().setConf("spark.sql.avro.compression.codec", "deflate");
                    break;
                }
                default: {
                    rowDataset.sqlContext().setConf("spark.sql.avro.compression.codec", "uncompressed");
                }
            }
            String filename = this.transMeta.environmentSubstitute(this.avroOutputMetaBase.getFilename());
            DataFrameWriter writer = rowDataset.write().format("com.databricks.spark.avro").mode(SaveMode.Overwrite);
            if (this.avroOutputMetaBase.getNamespace() != null) {
                writer.option("recordNamespace", this.avroOutputMetaBase.getNamespace());
            }
            if (this.avroOutputMetaBase.getRecordName() != null) {
                writer.option("recordName", this.avroOutputMetaBase.getRecordName());
            }
            writer.save(filename);
            if (this.isFinalOperation) {
                FinalOperationEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getId());
            }
        }
        catch (Exception e) {
            OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.operation.getId(), (Throwable)e);
        }
    }

    private Dataset<Row> convert(AvroOutputMetaBase avroOutputMetaBase, StructType schema, JavaRDD<org.pentaho.di.engine.api.model.Row> input, RowMetaInterface rowMeta, String stepID) {
        SparkSession spark = Util.getSparkSession();
        JavaRDD sparkRDD = input.map((Function)new KettleToSparkAvroRowFunction(rowMeta, avroOutputMetaBase.getParentStepMeta(), this.metricsAccumulator).asRegisteredFunction(stepID));
        return spark.createDataFrame(sparkRDD, schema);
    }
}

