/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import java.util.List;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import org.pentaho.big.data.kettle.plugins.formats.avro.AvroFormatInputOutputField;

public class AvroSchemaUtils {
    public static StructType createSchemaFromMeta(List<AvroFormatInputOutputField> fields) {
        StructType schema = new StructType();
        for (AvroFormatInputOutputField f : fields) {
            boolean isNullable = f.getNullString() != null && f.getNullString().equalsIgnoreCase("YES");
            FieldName fieldName = new FieldName(f.getPath(), f.getType(), Boolean.parseBoolean(f.getNullString()));
            String path = fieldName.toString();
            if (isNullable) {
                schema = schema.add(path, AvroSchemaUtils.dataType(f.getType()), isNullable);
                continue;
            }
            schema = schema.add(path, AvroSchemaUtils.dataType(f.getType()), Boolean.parseBoolean(f.getNullString()), Metadata.fromJson((String)(" { \"DEFAULT\" : \"" + f.getIfNullValue() + "\" }")));
        }
        return schema;
    }

    private static DataType dataType(int pentahoValueMetaType) {
        switch (pentahoValueMetaType) {
            case 1: {
                return DataTypes.DoubleType;
            }
            case 2: 
            case 10: {
                return DataTypes.StringType;
            }
            case 4: {
                return DataTypes.BooleanType;
            }
            case 5: {
                return DataTypes.LongType;
            }
            case 6: {
                return DataTypes.DoubleType;
            }
            case 9: {
                return DataTypes.TimestampType;
            }
            case 3: {
                return DataTypes.IntegerType;
            }
            case 7: 
            case 8: {
                return DataTypes.BinaryType;
            }
        }
        throw new RuntimeException("Undefined type: " + pentahoValueMetaType);
    }

    public static class FieldName {
        public final String name;
        public final int type;
        public final boolean allowNull;
        public static final String FIELDNAME_DELIMITER = "_delimiter_";

        public FieldName(String name, int type, boolean allowNull) {
            this.name = name;
            this.type = type;
            this.allowNull = allowNull;
        }

        public String toString() {
            StringBuilder o = new StringBuilder(256);
            o.append(this.c(this.name));
            o.append(FIELDNAME_DELIMITER);
            o.append(Integer.toString(this.type));
            o.append(FIELDNAME_DELIMITER);
            o.append(Boolean.toString(this.allowNull));
            return o.toString();
        }

        String c(String s) {
            if (s == null) {
                return "";
            }
            if (s.contains(FIELDNAME_DELIMITER)) {
                throw new RuntimeException("Wrong value: " + s);
            }
            return s;
        }
    }
}

