/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.JavaSparkContext;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.file.BaseFileInputMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileInputResolver {
    private static final Logger LOG = LoggerFactory.getLogger(FileInputResolver.class);
    private final Supplier<FileSystem> fileSystemSupplier;
    private final String path;
    private final String includeRegex;
    private final String excludeRegex;
    private final boolean required;
    private final boolean subdirs;
    private final boolean refersToDir;

    private FileInputResolver(String path, String includeRegex, String excludeRegex, boolean required, boolean subdirs, JavaSparkContext context) {
        this.path = path;
        this.refersToDir = subdirs || !Strings.isNullOrEmpty((String)includeRegex) || !Strings.isNullOrEmpty((String)excludeRegex);
        this.includeRegex = Strings.isNullOrEmpty((String)includeRegex) ? ".*" : includeRegex;
        this.excludeRegex = excludeRegex;
        this.required = required;
        this.subdirs = subdirs;
        this.fileSystemSupplier = Suppliers.memoize(() -> {
            try {
                String scheme = URI.create(path).getScheme();
                if (scheme == null || scheme.equals("file")) {
                    return FileSystem.getLocal((Configuration)context.hadoopConfiguration());
                }
                return FileSystem.get((Configuration)context.hadoopConfiguration());
            }
            catch (IOException e) {
                LOG.error("Couldn't initialize filesystem for " + path, (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    static List<String> getFiles(VariableSpace space, BaseFileInputMeta fileMeta, JavaSparkContext context) {
        Preconditions.checkNotNull((Object)space);
        Preconditions.checkNotNull((Object)fileMeta);
        Preconditions.checkNotNull((Object)context);
        List<FileInputResolver> files = FileInputResolver.getFileInputResolvers(space, fileMeta, context);
        List<String> resultingFileList = files.stream().flatMap(input -> input.listStatus().stream().filter(status -> !status.isDirectory()).filter(input::shouldInclude).map(input::statusPath)).collect(Collectors.toList());
        LOG.info(String.format("Files for step '%s' resolved to:  %s", FileInputResolver.getStepName(fileMeta), Arrays.toString(resultingFileList.toArray())));
        return resultingFileList;
    }

    private static String getStepName(BaseFileInputMeta fileMeta) {
        StepMeta parentStepMeta = fileMeta.getParentStepMeta();
        return parentStepMeta != null ? parentStepMeta.getName() : "[unknown]";
    }

    private static List<FileInputResolver> getFileInputResolvers(VariableSpace space, BaseFileInputMeta fileMeta, JavaSparkContext fs) {
        return IntStream.range(0, fileMeta.inputFiles.fileName.length).mapToObj(i -> new FileInputResolver(space.environmentSubstitute(fileMeta.inputFiles.fileName[i]), space.environmentSubstitute(fileMeta.inputFiles.fileMask[i]), space.environmentSubstitute(fileMeta.inputFiles.excludeFileMask[i]), "Y".equals(fileMeta.inputFiles.fileRequired[i]), fileMeta.inputFiles.includeSubFolderBoolean()[i], fs)).collect(Collectors.toList());
    }

    private String statusPath(FileStatus status) {
        URI uri = status.getPath().toUri();
        return String.format("%s:%s", uri.getScheme(), uri.getSchemeSpecificPart());
    }

    private boolean shouldInclude(FileStatus status) {
        boolean matchesInclude = !Strings.isNullOrEmpty((String)this.includeRegex) && Pattern.matches(this.includeRegex, status.getPath().getName());
        boolean matchesExclude = !Strings.isNullOrEmpty((String)this.excludeRegex) && Pattern.matches(this.excludeRegex, status.getPath().getName());
        return !this.refersToDir || matchesInclude && !matchesExclude;
    }

    private List<FileStatus> listStatus() {
        try {
            FileSystem fileSystem = (FileSystem)this.fileSystemSupplier.get();
            LOG.debug("listStatus() " + this.getDecodedPathString());
            List<FileStatus> fileStatuses = Arrays.asList(fileSystem.listStatus(new Path(this.getDecodedPathString())));
            List children = Collections.emptyList();
            if (this.subdirs) {
                children = fileStatuses.stream().filter(FileStatus::isDirectory).flatMap(file -> this.recurseDirs(fileSystem, (FileStatus)file).stream()).collect(Collectors.toList());
            }
            return ImmutableList.builder().addAll(fileStatuses).addAll(children).build();
        }
        catch (FileNotFoundException fnf) {
            if (this.required) {
                throw new RuntimeException("Required File was not found", fnf);
            }
            return Collections.emptyList();
        }
        catch (IOException e) {
            LOG.error("Could not get status for path:  " + this.getDecodedPathString(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<FileStatus> recurseDirs(FileSystem fileSystem, FileStatus file) {
        if (file.isFile()) {
            return Collections.singletonList(file);
        }
        try {
            return Arrays.stream(fileSystem.listStatus(file.getPath())).flatMap(dir -> this.recurseDirs(fileSystem, (FileStatus)dir).stream()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getDecodedPathString() {
        String auxPath = this.path;
        if (auxPath.indexOf("\\") > -1) {
            auxPath = auxPath.replace("\\", "/");
        }
        return URI.create(Util.escapeFileName((String)auxPath)).getPath();
    }
}

