/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.kafka010.ConsumerStrategies;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.apache.spark.streaming.kafka010.KafkaUtils;
import org.apache.spark.streaming.kafka010.LocationStrategies;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerInputMeta;
import org.pentaho.di.core.osgi.api.NamedClusterOsgi;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.ExecutionResult;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.Context;
import org.pentaho.di.engine.spark.impl.events.OperationErrorEvent;
import org.pentaho.di.engine.spark.impl.functions.KafkaToKettleRowFunction;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metastore.api.IMetaStore;

public class KafkaSparkOperation
implements SparkOperation {
    private final transient TransMeta transMeta;
    private final transient JavaSparkContext sparkContext;
    private final transient Operation operation;
    private transient Context executionContext;
    private transient Transformation transformation;
    private transient Map<String, Transformation> subTransformations;
    private final transient KafkaConsumerInputMeta consumerMeta;
    protected transient SparkOperation.Subscriber subscriber;
    protected transient JavaStreamingContext javaStreamingContext;

    public KafkaSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        this(operation, stepMeta, sparkContext);
        this.executionContext = (Context)executionContext;
        this.transformation = transformation;
        this.subTransformations = (HashMap)transformation.getConfig("SubTransformations").get();
    }

    public KafkaSparkOperation(Operation operation, StepMeta stepMeta, JavaSparkContext sparkContext) {
        this.transMeta = stepMeta.getParentTransMeta();
        this.consumerMeta = (KafkaConsumerInputMeta)Util.getTypedStepMeta((StepMeta)stepMeta, KafkaConsumerInputMeta.class);
        this.operation = operation;
        this.sparkContext = sparkContext;
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(KafkaSparkOperation::new, new Supplier[]{KafkaToKettleRowFunction::new});
    }

    public String getId() {
        return this.operation.getId();
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        this.subscriber = subscriber;
        CompletableFuture.runAsync(this::executeStreamingTransformation, arg_0 -> ((SparkOperation.Subscriber)subscriber).registerDriverAction(arg_0));
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    protected void executeStreamingTransformation() {
        HashMap<String, Object> kafkaParams = new HashMap<String, Object>();
        SparkConf sparkConf = this.sparkContext.sc().conf();
        this.consumerMeta.getConfig().entrySet().forEach(entry -> {
            String propertyValue = this.transMeta.environmentSubstitute((String)entry.getValue());
            if (((String)entry.getKey()).startsWith("spark.")) {
                sparkConf.set((String)entry.getKey(), propertyValue);
            } else {
                kafkaParams.put((String)entry.getKey(), propertyValue);
            }
        });
        if (KafkaConsumerInputMeta.ConnectionType.CLUSTER.equals((Object)this.consumerMeta.getConnectionType())) {
            NamedClusterOsgi namedCluster = this.transMeta.getNamedClusterServiceOsgi().getNamedClusterByName(this.transMeta.environmentSubstitute(this.consumerMeta.getClusterName()), (IMetaStore)this.transMeta.getEmbeddedMetaStore());
            kafkaParams.put("bootstrap.servers", this.transMeta.environmentSubstitute(namedCluster.getKafkaBootstrapServers()));
        } else {
            kafkaParams.put("bootstrap.servers", this.transMeta.environmentSubstitute(this.consumerMeta.getDirectBootstrapServers()));
        }
        kafkaParams.put("key.deserializer", this.consumerMeta.getKeyField().getOutputType().getKafkaDeserializerClass());
        kafkaParams.put("value.deserializer", this.consumerMeta.getMessageField().getOutputType().getKafkaDeserializerClass());
        kafkaParams.put("group.id", this.transMeta.environmentSubstitute(this.consumerMeta.getConsumerGroup()));
        kafkaParams.put("enable.auto.commit", true);
        List topics = this.consumerMeta.getTopics();
        topics = topics.stream().map(topic -> this.transMeta.environmentSubstitute(topic)).collect(Collectors.toList());
        Duration duration = new Duration(Long.parseLong(this.transMeta.environmentSubstitute(this.consumerMeta.getBatchDuration())));
        if (null == this.javaStreamingContext) {
            this.javaStreamingContext = new JavaStreamingContext(this.sparkContext, duration);
        }
        JavaInputDStream stream = KafkaUtils.createDirectStream((JavaStreamingContext)this.javaStreamingContext, (LocationStrategy)LocationStrategies.PreferConsistent(), (ConsumerStrategy)ConsumerStrategies.Subscribe(topics, kafkaParams));
        stream.foreachRDD(this::executeSubTransformation);
        this.javaStreamingContext.start();
        try {
            this.javaStreamingContext.awaitTermination();
        }
        catch (Exception e) {
            OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.operation.getId(), (Throwable)e);
        }
    }

    protected void executeSubTransformation(JavaRDD rdd) {
        String transformationPath = this.transMeta.environmentSubstitute(this.consumerMeta.getTransformationPath());
        Context subTransContext = this.executionContext.createSubTransContext(transformationPath);
        JavaRDD outputRdd = rdd.mapPartitions(new KafkaToKettleRowFunction(this.consumerMeta.getParentStepMeta()).asRegisteredFunction(this.consumerMeta.getParentStepMeta().getStepID()).toFlatMap());
        subTransContext.setInitialRdd(Optional.of(outputRdd));
        this.subscriber.initializeContext((ExecutionContext)subTransContext, subTransContext.getTransformation());
        try {
            ExecutionResult executionResult = (ExecutionResult)subTransContext.execute().get();
            executionResult.getDataEventReport().entrySet().stream().map(e -> ((Metrics)e.getValue()).getDropped()).filter(dropped -> dropped > 0L).findFirst().ifPresent(dropped -> this.javaStreamingContext.stop());
        }
        catch (Exception e2) {
            this.javaStreamingContext.stop();
        }
    }
}

