/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputOutputField;

public class ParquetSchemaUtils {
    public static StructType createSchemaFromMeta(FormatInputOutputField[] fields, boolean allowNullables) {
        StructType schema = new StructType();
        for (FormatInputOutputField f : fields) {
            schema = schema.add(f.getPath(), ParquetSchemaUtils.dataType(f.getType()), allowNullables ? f.isNullable() : true);
        }
        return schema;
    }

    private static DataType dataType(int pentahoValueMetaType) {
        switch (pentahoValueMetaType) {
            case 1: {
                return DataTypes.DoubleType;
            }
            case 2: {
                return DataTypes.StringType;
            }
            case 4: {
                return DataTypes.BooleanType;
            }
            case 5: {
                return DataTypes.LongType;
            }
            case 6: {
                return DataTypes.DoubleType;
            }
            case 7: 
            case 8: {
                return DataTypes.BinaryType;
            }
            case 3: 
            case 9: {
                return DataTypes.TimestampType;
            }
        }
        throw new RuntimeException("Undefined type: " + pentahoValueMetaType);
    }
}

