/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.StructField;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.functions.KettleToSparkRowFunction;
import org.pentaho.di.engine.spark.impl.functions.RowToSparkDatasetConverter;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;

public class TableOutputSparkOperation
implements SparkOperation {
    private final TransMeta transMeta;
    private final TableOutputMeta outputMeta;
    private final Operation operation;
    private final JavaSparkContext sparkContext;
    private MetricsAccumulator metricsAccumulator = MetricsAccumulator.empty();

    public TableOutputSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        this.transMeta = stepMeta.getParentTransMeta();
        this.outputMeta = (TableOutputMeta)Util.getTypedStepMeta((StepMeta)stepMeta, TableOutputMeta.class);
        this.operation = operation;
        this.sparkContext = sparkContext;
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(TableOutputSparkOperation::new, new Supplier[]{KettleToSparkRowFunction::new});
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public String getId() {
        return this.operation.getId();
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        this.metricsAccumulator = subscriber.getMetricsAccumulator();
        JavaRDD rdd = subscriber.getInput().orElse(this.sparkContext.emptyRDD()).cache();
        subscriber.setOutput(rdd);
        this.tableOutputAction((JavaRDD<Row>)rdd);
    }

    private void tableOutputAction(JavaRDD<Row> rdd) {
        Dataset rowDataset = RowToSparkDatasetConverter.convert(rdd, Util.getRowMeta((TransMeta)this.transMeta, (String)this.getId()), this.outputMeta.getParentStepMeta().getStepID(), this.metricsAccumulator);
        try {
            Properties connectionProperties = this.outputMeta.getDatabaseMeta().getConnectionProperties();
            connectionProperties.setProperty("user", this.outputMeta.getDatabaseMeta().getUsername());
            connectionProperties.setProperty("password", this.outputMeta.getDatabaseMeta().getPassword());
            connectionProperties.setProperty("driver", this.outputMeta.getDatabaseMeta().getDriverClass());
            if (this.outputMeta.specifyFields()) {
                StructField[] fields;
                String[] fieldStream = this.outputMeta.getFieldStream();
                String[] fieldDatabase = this.outputMeta.getFieldDatabase();
                List<String> streamList = Arrays.asList(fieldStream);
                for (StructField field : fields = rowDataset.schema().fields()) {
                    if (streamList.contains(field.name())) continue;
                    rowDataset = rowDataset.drop(field.name());
                }
                for (int i = 0; i < fieldStream.length; ++i) {
                    rowDataset = rowDataset.withColumnRenamed(fieldStream[i], fieldDatabase[i]);
                }
            }
            if (this.outputMeta.truncateTable()) {
                Database database = new Database(this.outputMeta.getDatabaseMeta());
                database.connect();
                database.truncateTable(this.outputMeta.getSchemaName(), this.outputMeta.getTableName());
                database.disconnect();
            }
            String table = Utils.isEmpty((CharSequence)this.outputMeta.getSchemaName()) ? this.outputMeta.getTableName() : this.outputMeta.getSchemaName() + "." + this.outputMeta.getTableName();
            rowDataset.write().mode(SaveMode.Append).jdbc(this.outputMeta.getDatabaseMeta().getURL(), table, connectionProperties);
        }
        catch (KettleDatabaseException e) {
            throw new RuntimeException(e);
        }
    }
}

