/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.local;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.apache.aries.rsa.discovery.endpoint.EndpointDescriptionParser;
import org.osgi.framework.Bundle;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EndpointDescriptionBundleParser {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointDescriptionBundleParser.class);
    private static final String REMOTE_SERVICES_HEADER_NAME = "Remote-Service";
    private static final String REMOTE_SERVICES_DIRECTORY = "OSGI-INF/remote-service/";
    private EndpointDescriptionParser parser = new EndpointDescriptionParser();

    public List<EndpointDescription> getAllEndpointDescriptions(Bundle b) {
        Enumeration<URL> urls = this.getEndpointDescriptionURLs(b);
        ArrayList<EndpointDescription> elements = new ArrayList<EndpointDescription>();
        while (urls.hasMoreElements()) {
            URL resourceURL = urls.nextElement();
            try {
                elements.addAll(this.parser.readEndpoints(resourceURL.openStream()));
            }
            catch (Exception ex) {
                LOG.warn("Problem parsing: " + resourceURL, (Throwable)ex);
            }
        }
        return elements;
    }

    Enumeration<URL> getEndpointDescriptionURLs(Bundle b) {
        String dir;
        String origDir = EndpointDescriptionBundleParser.getRemoteServicesDir(b);
        String filePattern = "*.xml";
        if (origDir.endsWith("/")) {
            dir = origDir.substring(0, origDir.length() - 1);
        } else {
            int idx = origDir.lastIndexOf(47);
            if (idx >= 0 & origDir.length() > idx) {
                filePattern = origDir.substring(idx + 1);
                dir = origDir.substring(0, idx);
            } else {
                filePattern = origDir;
                dir = "";
            }
        }
        Enumeration urls = b.findEntries(dir, filePattern, false);
        return urls == null ? Collections.enumeration(new ArrayList()) : urls;
    }

    private static String getRemoteServicesDir(Bundle b) {
        Dictionary headers = b.getHeaders();
        Object header = null;
        if (headers != null) {
            header = headers.get(REMOTE_SERVICES_HEADER_NAME);
        }
        return header == null ? REMOTE_SERVICES_DIRECTORY : header.toString();
    }
}

