/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.osgi;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPackageExtrapolator {
    public static final String ORG_OSGI_FRAMEWORK_SYSTEM_PACKAGES_EXTRA = "org.osgi.framework.system.packages.extra";
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<PackageProvider> providers = new ArrayList<PackageProvider>();

    public SystemPackageExtrapolator() {
        this.providers.add(new JBossModulePackageProvider());
        this.providers.add(new UrlClassLoaderPackageProvider());
    }

    public SystemPackageExtrapolator(List<PackageProvider> providers) {
        this.providers = providers;
    }

    static String getPackageName(JarEntry jarEntry) {
        String name = jarEntry.getName();
        int lastSlash = name.lastIndexOf(47);
        if (lastSlash >= 0) {
            return name.substring(0, lastSlash).replaceAll("\\/", ".");
        }
        return "";
    }

    public Properties expandProperties(Properties properties) {
        HashSet<String> packages = new HashSet<String>();
        for (PackageProvider provider : this.providers) {
            packages.addAll(provider.getPackages());
        }
        String packagesImports = properties.getProperty(ORG_OSGI_FRAMEWORK_SYSTEM_PACKAGES_EXTRA);
        String[] split = packagesImports.split(",");
        Object[] expanded = this.expandPackages(split, packages.toArray(new String[packages.size()]));
        properties.setProperty(ORG_OSGI_FRAMEWORK_SYSTEM_PACKAGES_EXTRA, StringUtils.join((Object[])expanded, (String)","));
        return properties;
    }

    private String[] expandPackages(String[] packages, String[] availablePackages) {
        HashSet<String> qualifiedPackages = new HashSet<String>();
        HashSet<String> qualifiedPackagesWhole = new HashSet<String>();
        HashSet<String> imports = new HashSet<String>();
        for (String pack : packages) {
            if ((pack = pack.trim()).indexOf(";") <= 0 || pack.indexOf("*") != -1) continue;
            qualifiedPackages.add(pack.substring(0, pack.indexOf(";")));
            qualifiedPackagesWhole.add(pack);
        }
        for (String pack : packages) {
            if (StringUtils.isNotEmpty((String)pack) && pack.contains(".*")) {
                String basePackage = pack.substring(0, pack.indexOf("*")).trim();
                String predicate = pack.substring(pack.indexOf("*") + 1);
                for (String aPackage : availablePackages) {
                    if (!aPackage.startsWith(basePackage) || qualifiedPackages.contains(aPackage)) continue;
                    imports.add(aPackage + predicate);
                }
                imports.add(basePackage.substring(0, basePackage.length() - 1) + predicate);
                continue;
            }
            imports.add(pack);
        }
        imports.addAll(qualifiedPackagesWhole);
        return imports.toArray(new String[imports.size()]);
    }

    class UrlClassLoaderPackageProvider
    implements PackageProvider {
        UrlClassLoaderPackageProvider() {
        }

        @Override
        public Set<String> getPackages() {
            HashSet<String> packages = new HashSet<String>();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            do {
                URL[] urLs;
                if (!URLClassLoader.class.isAssignableFrom(classLoader.getClass())) continue;
                for (URL url : urLs = ((URLClassLoader)classLoader).getURLs()) {
                    try {
                        String fileName = URLDecoder.decode(url.getFile());
                        File file = new File(fileName);
                        if (!file.exists() || file.isDirectory()) continue;
                        JarFile jarFile = new JarFile(file);
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            packages.add(SystemPackageExtrapolator.getPackageName(entries.nextElement()));
                        }
                    }
                    catch (IOException e) {
                        SystemPackageExtrapolator.this.logger.debug("Error procesing jar for packages", (Throwable)e);
                    }
                }
            } while ((classLoader = classLoader.getParent()) != null);
            return packages;
        }
    }

    static class JBossModulePackageProvider
    implements PackageProvider {
        private Module module;

        JBossModulePackageProvider() {
        }

        @Override
        public Set<String> getPackages() {
            Set exportedPaths = null;
            if (this.module == null) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader.getClass().getName().equals("org.jboss.modules.ModuleClassLoader")) {
                    exportedPaths = ((ModuleClassLoader)classLoader).getModule().getExportedPaths();
                }
            } else {
                exportedPaths = this.module.getExportedPaths();
            }
            HashSet<String> packages = new HashSet<String>();
            if (exportedPaths != null) {
                for (String exportedPath : exportedPaths) {
                    packages.add(exportedPath.replaceAll("/", "."));
                }
            }
            return packages;
        }

        public void setModule(Module module) {
            this.module = module;
        }
    }

    static interface PackageProvider {
        public Set<String> getPackages();
    }
}

