/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.kettle;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.www.CarteSingleton;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.kettle.DIServerConfig;
import org.pentaho.platform.plugin.action.kettle.Log4jForwardingKettleLoggingEventListener;
import org.pentaho.platform.plugin.action.kettle.PlatformKettleDataSourceProvider;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.xml.XMLParserFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class KettleSystemListener
implements IPentahoSystemListener {
    private boolean usePlatformLogFile = true;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean startup(IPentahoSession session) {
        if (StringUtils.isEmpty((String)System.getProperty("DI_HOME"))) {
            String defaultKettleHomePath = PentahoSystem.getApplicationContext().getSolutionPath("system" + File.separator + "kettle");
            this.logger.error("DI_HOME System Property not properly set. The default location of " + defaultKettleHomePath + " will be used.");
            System.setProperty("DI_HOME", defaultKettleHomePath);
        }
        if (this.usePlatformLogFile) {
            KettleLogStore.init((boolean)false, (boolean)false);
            this.initLogging();
        }
        this.hookInDataSourceProvider();
        try {
            KettleSystemListener.environmentInit(session);
        }
        catch (Throwable t) {
            t.printStackTrace();
            org.pentaho.platform.util.logging.Logger.error((String)KettleSystemListener.class.getName(), (String)Messages.getInstance().getErrorString("KettleSystemListener.ERROR_0001_PLUGIN_LOAD_FAILED"));
        }
        try {
            String slaveServerConfigFilename = "system" + File.separator + "kettle" + File.separator + "slave-server-config.xml";
            File slaveServerConfigFile = new File(PentahoSystem.getApplicationContext().getSolutionPath(slaveServerConfigFilename));
            if (slaveServerConfigFile.exists()) {
                FileInputStream is = new FileInputStream(slaveServerConfigFile);
                Node configNode = this.getSlaveServerConfigNode(is);
                DIServerConfig config = new DIServerConfig(new LogChannel((Object)"Slave server config"), configNode);
                config.setFilename(slaveServerConfigFile.getAbsolutePath());
                SlaveServer slaveServer = new SlaveServer();
                config.setSlaveServer(slaveServer);
                CarteSingleton.setSlaveServerConfig((SlaveServerConfig)config);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            org.pentaho.platform.util.logging.Logger.error((String)KettleSystemListener.class.getName(), (String)t.getMessage());
        }
        return true;
    }

    protected void initLogging() {
        Enumeration appenders = org.apache.log4j.Logger.getRootLogger().getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof FileAppender)) continue;
            Log4jForwardingKettleLoggingEventListener listener = new Log4jForwardingKettleLoggingEventListener(appender);
            KettleLogStore.getAppender().addLoggingEventListener((KettleLoggingEventListener)listener);
        }
    }

    private void hookInDataSourceProvider() {
        try {
            Class<?> clazz = Class.forName("org.pentaho.di.core.database.DataSourceProviderInterface");
            PlatformKettleDataSourceProvider.hookupProvider();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map readProperties(IPentahoSession session) {
        Properties props = new Properties();
        String kettlePropsFilename = "system" + File.separator + "kettle" + File.separator + "kettle.properties";
        InputStream is = null;
        try {
            File f = new File(PentahoSystem.getApplicationContext().getSolutionPath(kettlePropsFilename));
            if (!f.exists()) {
                Properties properties = props;
                return properties;
            }
            is = new FileInputStream(f);
            props.load(is);
        }
        catch (IOException ioe) {
            org.pentaho.platform.util.logging.Logger.error((String)KettleSystemListener.class.getName(), (String)(Messages.getInstance().getString("KettleSystemListener.ERROR_0003_PROPERTY_FILE_READ_FAILED") + ioe.getMessage()), (Throwable)ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        props.put("pentaho.solutionpath", "solution:");
        return props;
    }

    public static void environmentInit(IPentahoSession session) throws KettleException {
        KettleEnvironment.init((boolean)false);
    }

    public void shutdown() {
    }

    public void setUsePlatformLogFile(boolean usePlatformLogFile) {
        this.usePlatformLogFile = usePlatformLogFile;
    }

    @VisibleForTesting
    Node getSlaveServerConfigNode(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        Document document = XMLParserFactoryProducer.createSecureDocBuilderFactory().newDocumentBuilder().parse(is);
        return XMLHandler.getSubNode((Node)document, (String)"slave_config");
    }
}

