/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.net.URL;
import java.util.Enumeration;
import javax.ws.rs.FormParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.xml.DOMConfigurator;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;

@Path(value="/logconfig")
public class Log4jResource {
    private static final Logger LOGGER = Logger.getLogger(Log4jResource.class);
    private static final String CONFIG = "log4j.xml";

    @PUT
    @Path(value="/reload")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully reload from configuration.")})
    @Produces(value={"text/plain"})
    public Response reloadConfiguration() throws Exception {
        LOGGER.setLevel(Level.INFO);
        LOGGER.info((Object)"Reloading configuration...");
        DOMConfigurator.configure((URL)Loader.getResource((String)CONFIG));
        return Response.ok((Object)"Done").build();
    }

    @PUT
    @Path(value="/update")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully update log level."), @ResponseCode(code=304, condition="Log level is not modified.")})
    @Produces(value={"text/plain"})
    public Response updateLogLevel(@FormParam(value="level") String targetLevel, @FormParam(value="category") String category) throws Exception {
        LOGGER.setLevel(Level.INFO);
        if (StringUtils.isBlank((String)targetLevel) && StringUtils.isBlank((String)category)) {
            return Response.notModified((String)"No parameter provided, log level not modified.").build();
        }
        Logger root = LogManager.getRootLogger();
        if (StringUtils.isNotBlank((String)targetLevel)) {
            LOGGER.info((Object)("Request to set log level: " + targetLevel));
            if (StringUtils.isNotBlank((String)category)) {
                LOGGER.info((Object)("Request to set log level for package: " + category));
                Logger catLog = LogManager.exists((String)category);
                if (catLog != null) {
                    catLog.setLevel(Level.toLevel((String)targetLevel, (Level)root.getLevel()));
                    return Response.ok((Object)("Setting log level for: '" + catLog.getName() + "' to be: " + catLog.getLevel())).build();
                }
                return Response.notModified((String)("Category: '" + category + "' not found, log level not modified.")).build();
            }
            root.setLevel(Level.toLevel((String)targetLevel, (Level)root.getLevel()));
            LOGGER.info((Object)("Root logger level set to: " + root.getLevel()));
            Enumeration e = LogManager.getCurrentLoggers();
            while (e.hasMoreElements()) {
                Logger logger = (Logger)e.nextElement();
                logger.setLevel(Level.toLevel((String)targetLevel, (Level)root.getLevel()));
            }
        }
        return Response.ok((Object)"Log level updated.").build();
    }
}

