/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.scheduler2.ComplexJobTrigger;
import org.pentaho.platform.api.scheduler2.IJobTrigger;
import org.pentaho.platform.api.scheduler2.IScheduler;
import org.pentaho.platform.api.scheduler2.SchedulerException;
import org.pentaho.platform.api.scheduler2.SimpleJobTrigger;
import org.pentaho.platform.api.scheduler2.recur.ITimeRecurrence;
import org.pentaho.platform.scheduler2.quartz.QuartzScheduler;
import org.pentaho.platform.scheduler2.recur.QualifiedDayOfWeek;
import org.pentaho.platform.web.http.api.resources.ComplexJobTriggerProxy;
import org.pentaho.platform.web.http.api.resources.JobScheduleRequest;

public class SchedulerResourceUtil {
    private static final Log logger = LogFactory.getLog(SchedulerResourceUtil.class);
    public static final String RESERVEDMAPKEY_LINEAGE_ID = "lineage-id";

    public static IJobTrigger convertScheduleRequestToJobTrigger(JobScheduleRequest scheduleRequest, IScheduler scheduler) throws SchedulerException, UnifiedRepositoryException {
        SimpleJobTrigger jobTrigger;
        boolean runInBackground = scheduleRequest.getSimpleJobTrigger() == null && scheduleRequest.getComplexJobTrigger() == null && scheduleRequest.getCronJobTrigger() == null;
        SimpleJobTrigger simpleJobTrigger = jobTrigger = runInBackground ? new SimpleJobTrigger(new Date(System.currentTimeMillis() + 10000L), null, 0, 0L) : scheduleRequest.getSimpleJobTrigger();
        if (scheduleRequest.getSimpleJobTrigger() != null) {
            SimpleJobTrigger simpleJobTrigger2 = scheduleRequest.getSimpleJobTrigger();
            if (simpleJobTrigger2.getStartTime() == null) {
                simpleJobTrigger2.setStartTime(new Date());
            }
            jobTrigger = simpleJobTrigger2;
        } else if (scheduleRequest.getComplexJobTrigger() != null) {
            ComplexJobTriggerProxy proxyTrigger = scheduleRequest.getComplexJobTrigger();
            ComplexJobTrigger complexJobTrigger = new ComplexJobTrigger();
            complexJobTrigger.setStartTime(proxyTrigger.getStartTime());
            complexJobTrigger.setEndTime(proxyTrigger.getEndTime());
            complexJobTrigger.setDuration(scheduleRequest.getDuration());
            if (proxyTrigger.getDaysOfWeek().length > 0) {
                if (proxyTrigger.getWeeksOfMonth().length > 0) {
                    for (int dayOfWeek : proxyTrigger.getDaysOfWeek()) {
                        for (int weekOfMonth : proxyTrigger.getWeeksOfMonth()) {
                            QualifiedDayOfWeek qualifiedDayOfWeek = new QualifiedDayOfWeek();
                            qualifiedDayOfWeek.setDayOfWeek(QualifiedDayOfWeek.DayOfWeek.values()[dayOfWeek]);
                            if (weekOfMonth == 4) {
                                qualifiedDayOfWeek.setQualifier(QualifiedDayOfWeek.DayOfWeekQualifier.LAST);
                            } else {
                                qualifiedDayOfWeek.setQualifier(QualifiedDayOfWeek.DayOfWeekQualifier.values()[weekOfMonth]);
                            }
                            complexJobTrigger.addDayOfWeekRecurrence((ITimeRecurrence)qualifiedDayOfWeek);
                        }
                    }
                } else {
                    for (int dayOfWeek : proxyTrigger.getDaysOfWeek()) {
                        complexJobTrigger.addDayOfWeekRecurrence(new Integer[]{dayOfWeek + 1});
                    }
                }
            } else if (proxyTrigger.getDaysOfMonth().length > 0) {
                for (int dayOfMonth : proxyTrigger.getDaysOfMonth()) {
                    complexJobTrigger.addDayOfMonthRecurrence(new Integer[]{dayOfMonth});
                }
            }
            for (int month : proxyTrigger.getMonthsOfYear()) {
                complexJobTrigger.addMonthlyRecurrence(new Integer[]{month + 1});
            }
            for (int year : proxyTrigger.getYears()) {
                complexJobTrigger.addYearlyRecurrence(new Integer[]{year});
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(complexJobTrigger.getStartTime());
            complexJobTrigger.setHourlyRecurrence(new Integer[]{calendar.get(11)});
            complexJobTrigger.setMinuteRecurrence(new Integer[]{calendar.get(12)});
            complexJobTrigger.setUiPassParam(scheduleRequest.getComplexJobTrigger().getUiPassParam());
            jobTrigger = complexJobTrigger;
        } else if (scheduleRequest.getCronJobTrigger() != null) {
            if (scheduler instanceof QuartzScheduler) {
                String delims;
                String cronString = scheduleRequest.getCronJobTrigger().getCronString();
                String[] tokens = cronString.split(delims = "[ ]+");
                if (tokens.length < 7) {
                    cronString = cronString + " *";
                }
                ComplexJobTrigger complexJobTrigger = QuartzScheduler.createComplexTrigger((String)cronString);
                complexJobTrigger.setStartTime(scheduleRequest.getCronJobTrigger().getStartTime());
                complexJobTrigger.setEndTime(scheduleRequest.getCronJobTrigger().getEndTime());
                complexJobTrigger.setDuration(scheduleRequest.getCronJobTrigger().getDuration());
                complexJobTrigger.setUiPassParam(scheduleRequest.getCronJobTrigger().getUiPassParam());
                jobTrigger = complexJobTrigger;
            } else {
                throw new IllegalArgumentException();
            }
        }
        return jobTrigger;
    }

    public static void updateStartDateForTimeZone(JobScheduleRequest request) {
        if (request.getSimpleJobTrigger() != null) {
            if (request.getSimpleJobTrigger().getStartTime() != null) {
                Date origStartDate = request.getSimpleJobTrigger().getStartTime();
                Date serverTimeZoneStartDate = SchedulerResourceUtil.convertDateToServerTimeZone(origStartDate, request.getTimeZone());
                request.getSimpleJobTrigger().setStartTime(serverTimeZoneStartDate);
            }
        } else if (request.getComplexJobTrigger() != null) {
            if (request.getComplexJobTrigger().getStartTime() != null) {
                Date origStartDate = request.getComplexJobTrigger().getStartTime();
                Date serverTimeZoneStartDate = SchedulerResourceUtil.convertDateToServerTimeZone(origStartDate, request.getTimeZone());
                request.getComplexJobTrigger().setStartTime(serverTimeZoneStartDate);
            }
        } else if (request.getCronJobTrigger() != null && request.getCronJobTrigger().getStartTime() != null) {
            Date origStartDate = request.getCronJobTrigger().getStartTime();
            Date serverTimeZoneStartDate = SchedulerResourceUtil.convertDateToServerTimeZone(origStartDate, request.getTimeZone());
            request.getCronJobTrigger().setStartTime(serverTimeZoneStartDate);
        }
    }

    public static Date convertDateToServerTimeZone(Date dateTime, String timeZone) {
        Calendar userDefinedTime = Calendar.getInstance();
        userDefinedTime.setTime(dateTime);
        if (!TimeZone.getDefault().getID().equalsIgnoreCase(timeZone)) {
            logger.warn((Object)("original defined time: " + userDefinedTime.getTime().toString() + " on tz:" + timeZone));
            GregorianCalendar quartzStartDate = new GregorianCalendar(TimeZone.getTimeZone(timeZone));
            quartzStartDate.set(1, userDefinedTime.get(1));
            quartzStartDate.set(2, userDefinedTime.get(2));
            quartzStartDate.set(5, userDefinedTime.get(5));
            quartzStartDate.set(11, userDefinedTime.get(11));
            quartzStartDate.set(12, userDefinedTime.get(12));
            quartzStartDate.set(13, userDefinedTime.get(13));
            quartzStartDate.set(14, userDefinedTime.get(14));
            logger.warn((Object)("adapted time for " + TimeZone.getDefault().getID() + ": " + quartzStartDate.getTime().toString()));
            return quartzStartDate.getTime();
        }
        return dateTime;
    }

    public static HashMap<String, Serializable> handlePDIScheduling(RepositoryFile file, HashMap<String, Serializable> parameterMap, Map<String, String> pdiParameters) {
        HashMap<String, Serializable> convertedParameterMap = new HashMap<String, Serializable>();
        boolean paramsAdded = false;
        if (pdiParameters != null) {
            convertedParameterMap.put("parameters", (Serializable)((Object)pdiParameters));
            paramsAdded = true;
        } else {
            pdiParameters = new HashMap<String, String>();
        }
        if (file != null && SchedulerResourceUtil.isPdiFile(file)) {
            for (String param : parameterMap.keySet()) {
                if (StringUtils.isEmpty((String)param) || !parameterMap.containsKey(param)) continue;
                convertedParameterMap.put(param, (Serializable)((Object)parameterMap.get(param).toString()));
                if (paramsAdded) continue;
                pdiParameters.put(param, parameterMap.get(param).toString());
            }
            convertedParameterMap.put("directory", (Serializable)((Object)FilenameUtils.getPathNoEndSeparator((String)file.getPath())));
            String type = SchedulerResourceUtil.isTransformation(file) ? "transformation" : "job";
            convertedParameterMap.put(type, (Serializable)((Object)FilenameUtils.getBaseName((String)file.getPath())));
        } else {
            convertedParameterMap.putAll(parameterMap);
        }
        convertedParameterMap.putIfAbsent("parameters", (Serializable)((Object)pdiParameters));
        return convertedParameterMap;
    }

    public static boolean isPdiFile(RepositoryFile file) {
        return SchedulerResourceUtil.isTransformation(file) || SchedulerResourceUtil.isJob(file);
    }

    public static boolean isTransformation(RepositoryFile file) {
        return file != null && "ktr".equalsIgnoreCase(FilenameUtils.getExtension((String)file.getName()));
    }

    public static boolean isJob(RepositoryFile file) {
        return file != null && "kjb".equalsIgnoreCase(FilenameUtils.getExtension((String)file.getName()));
    }
}

